/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.formplugin.web.appfile.trace;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;

public class AppFileProcessPlugin
extends AbstractFormPlugin {
    private static final String KEY_INCTLINKTIME = "inctlinktime";
    private static final String KEY_ISCURRNODE = "isCurrNode";
    private static final String KEY_STATUS = "status";
    private Long appFileId = 0L;

    public void beforeBindData(EventObject evt) {
        this.appFileId = (Long)this.getView().getFormShowParameter().getCustomParam("appFileId");
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("flexpanelap1");
        listShowParameter.setFormId("tsrsc_appfiletracelist");
        listShowParameter.setBillFormId("tsrsc_appfiletrace");
        listShowParameter.setSendToClient(true);
        listShowParameter.setCustomParam("appFileId", (Object)this.appFileId);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void afterBindData(EventObject evt) {
        this.calAppFileTraceData(this.appFileId);
    }

    private void calAppFileTraceData(Long appFileId) {
        DynamicObject appFile = AppFileDataHelper.queryAppFileById((Object)appFileId);
        Long procId = appFile.getLong("recruproc.id");
        DynamicObjectCollection stages = AppFileHelper.getProcStagesByProcId((Long)procId);
        LinkedHashMap data = Maps.newLinkedHashMapWithExpectedSize((int)stages.size());
        for (DynamicObject stage : stages) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("gap", 0L);
            map.put("name", stage.getString("entryentity.rqmtstg.name"));
            Long stgId = stage.getLong("entryentity.rqmtstg.id");
            if (HRObjectUtils.equals((Object)stgId, (Object)appFile.getLong("recrustg.id"))) {
                map.put(KEY_ISCURRNODE, Boolean.TRUE);
            }
            data.put(stgId, map);
        }
        this.fillData(data, appFile);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(data.size());
        this.getResultList(data, appFile, resultList);
        CustomControl processBar = (CustomControl)this.getControl("customcontrolap");
        processBar.setData(resultList);
    }

    private void getResultList(LinkedHashMap<Long, Map<String, Object>> data, DynamicObject appFile, ArrayList<Map<String, String>> resultList) {
        boolean flag = false;
        for (Map<String, Object> map : data.values()) {
            HashMap result = Maps.newHashMapWithExpectedSize((int)5);
            if (map.get(KEY_ISCURRNODE) != null) {
                flag = true;
                if (!(AppFileHelper.isOut((DynamicObject)appFile) || AppFileHelper.isInvalid((DynamicObject)appFile) || AppFileHelper.isEndEmployed((DynamicObject)appFile))) {
                    result.put(KEY_STATUS, "2");
                } else {
                    result.put(KEY_STATUS, "3");
                }
            } else {
                result.put(KEY_STATUS, flag ? "0" : "1");
            }
            result.put("name", (String)map.get("name"));
            if (!flag || "3".equals(result.get(KEY_STATUS))) {
                String useTimeStr = ResManager.loadKDString((String)"\u8017\u65f6\uff1a", (String)"AppFileProcessPlugin_0", (String)"tsc-tsrsc-formplugin", (Object[])new Object[0]);
                if ((Long)map.get("gap") != 0L) {
                    result.put("desc", useTimeStr + AppFileHelper.calDuration((Long)((Long)map.get("gap"))));
                } else {
                    result.put("desc", useTimeStr + "0h0min");
                }
            }
            resultList.add(result);
        }
    }

    private void fillData(LinkedHashMap<Long, Map<String, Object>> data, DynamicObject appFile) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrsc_appfiletrace");
        DynamicObject[] traces = helper.queryOriginalArray("inctlinktime,inrecrustg.id", new QFilter[]{new QFilter("appfile", "=", (Object)this.appFileId)}, "createtime asc");
        for (int i = 0; i < traces.length; ++i) {
            Long stgId = traces[i].getLong("inrecrustg.id");
            Date linkTime = traces[i].getDate(KEY_INCTLINKTIME);
            Date outTime = i >= traces.length - 1 ? AppFileHelper.getEndDateByStatus((DynamicObject)appFile) : traces[i + 1].getDate(KEY_INCTLINKTIME);
            if (outTime == null) continue;
            long outTimes = outTime.getTime();
            long linkTimes = linkTime.getTime();
            long gap = outTimes - outTimes % 60000L - (linkTimes - linkTimes % 60000L);
            Map<String, Object> map = data.get(stgId);
            if (map == null) continue;
            map.merge("gap", gap, (n1, n2) -> (Long)n1 + (Long)n2);
            if (!HRObjectUtils.equals((Object)stgId, (Object)appFile.getLong("recrustg.id"))) continue;
            map.put(KEY_ISCURRNODE, Boolean.TRUE);
        }
    }
}

