/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.formplugin.web.attachment;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SessionManager;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class FilePreviewPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(FilePreviewPlugin.class);

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String filePath = (String)this.getView().getFormShowParameter().getCustomParam("filepath");
        if (HRStringUtils.isNotEmpty((String)filePath)) {
            String attachmentPreviewUrl = UrlService.getAttachmentPreviewUrl((String)filePath);
            String csrfTokenValue = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
            attachmentPreviewUrl = attachmentPreviewUrl + "&kd_cs_ticket=" + csrfTokenValue + "#toolbar=0";
            logger.info("attachmentPreviewUrl.print\uff1a{}", (Object)attachmentPreviewUrl);
            IFrame resumeIframe = (IFrame)this.getView().getControl("resumeiframe");
            resumeIframe.setSrc(attachmentPreviewUrl);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        String skipCheckPerm = (String)this.getView().getFormShowParameter().getCustomParam("skipCheckPerm");
        if (HRStringUtils.equals((String)skipCheckPerm, (String)Boolean.toString(true))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"downloadbtnnoperm"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"downloadbtn"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"downloadbtn"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"downloadbtnnoperm"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ((HRStringUtils.equals((String)operateKey, (String)"download") || HRStringUtils.equals((String)operateKey, (String)"downloadbtnnoperm")) && args.getOperationResult().isSuccess()) {
            String filePath = (String)this.getView().getFormShowParameter().getCustomParam("filepath");
            String attachmentDownloadUrl = UrlService.getAttachmentFullUrl((String)filePath);
            this.getView().download(attachmentDownloadUrl);
        }
    }
}

