/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.formplugin.web.home;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.entity.bizconfig.ConfigMenuDTO;

public class TsrscSystemConfigPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TsrscSystemConfigPlugin.class);
    private String keys = "rqmtpmainflex,businessunitflex,connectionflex,tenantflex,openapiflex";

    private List<ConfigMenuDTO> pageData(String pageId) {
        ConfigMenuDTO menu1 = new ConfigMenuDTO("\u603b\u4f53\u7b80\u4ecb", "rqmtpmainflex", pageId + "_rqmtpmainflex");
        ConfigMenuDTO menu2 = new ConfigMenuDTO("\u6b65\u9aa4\u4e00\uff1a\u4e1a\u52a1\u5355\u5143\u914d\u7f6e", "businessunitflex", pageId + "_businessunitflex");
        ConfigMenuDTO menu3 = new ConfigMenuDTO("\u6b65\u9aa4\u4e8c\uff1a\u8fde\u63a5\u914d\u7f6e", "connectionflex", pageId + "_connectionflex");
        ConfigMenuDTO menu4 = new ConfigMenuDTO("\u6b65\u9aa4\u4e09\uff1a\u751f\u6001\u4f19\u4f34\u79df\u6237\u914d\u7f6e", "tenantflex", pageId + "_tenantflex");
        ConfigMenuDTO menu5 = new ConfigMenuDTO("\u6b65\u9aa4\u56db\uff1a\u5f00\u653e\u5e73\u53f0\u79d8\u94a5\u83b7\u53d6", "openapiflex", pageId + "_openapiflex");
        ArrayList parent = Lists.newArrayListWithCapacity((int)16);
        parent.add(menu1);
        parent.add(menu2);
        parent.add(menu3);
        parent.add(menu4);
        parent.add(menu5);
        return parent;
    }

    public void customEvent(CustomEventArgs eventArgs) {
        Map cast = null;
        try {
            cast = (Map)HRJSONUtils.cast((String)eventArgs.getEventArgs(), HashMap.class, (Class[])new Class[]{String.class, Object.class});
        }
        catch (IOException ex) {
            logger.error("TsrscSystemConfigPlugin.customEvent.error: ", (Throwable)ex);
        }
        if (cast != null) {
            String key = String.valueOf(cast.get("key"));
            this.showFlex(key);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.loadGeneralDescflex();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String pageId = this.getView().getPageId();
        CustomControl customcontrol = (CustomControl)this.getView().getControl("configmenu");
        customcontrol.setData(this.pageData(pageId));
    }

    private void showFlex(String key) {
        if (HRStringUtils.equals((String)key, (String)"rqmtpmainflex")) {
            this.loadGeneralDescflex();
        } else if (HRStringUtils.equals((String)key, (String)"businessunitflex")) {
            this.loadBusinessunitflex();
        } else if (HRStringUtils.equals((String)key, (String)"connectionflex")) {
            this.loadConnectionconfig();
        } else if (HRStringUtils.equals((String)key, (String)"tenantflex")) {
            this.loadTenantConfig();
        } else if (HRStringUtils.equals((String)key, (String)"openapiflex")) {
            this.loadOpenapiConfig();
        }
    }

    public void loadGeneralDescflex() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrsc_generaldescription");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap6");
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    public void loadBusinessunitflex() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrsc_businessunitconfig");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap6");
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    public void loadConnectionconfig() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrsc_connectionconfig");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap6");
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    public void loadTenantConfig() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrsc_tenantconfig");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap6");
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }

    public void loadOpenapiConfig() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsrsc_openapiconfig");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flexpanelap6");
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm(showParameter);
    }
}

