/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.formplugin.web.msgtemplate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tso.business.domain.offer.helper.OfferAdviceBizHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageCacheService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageParser;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgFormService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgParserBizHelper;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.EmailMessageParser;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.MessageContentDO;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.MessageEntryDto;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.SmsMessageParser;
import kd.tsc.tsrbd.business.domain.msginstance.MsgInstanceHelper;
import kd.tsc.tsrbd.business.domain.msgtrack.service.MsgTrackHelper;
import kd.tsc.tsrbd.common.constants.CfgMsgTemplateConstants;
import kd.tsc.tsrbd.common.entity.msgtrack.MsgTrackDTO;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbd.common.utils.TerracePhoneFormChangeUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TscMsgTempIntegrateEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
UploadListener {
    private static final Log logger = LogFactory.getLog(TscMsgTempIntegrateEdit.class);
    private static final Set<String> EMAIL_ATTACHMENT_SERVICE_NEEDED_SCENE_LIST = Sets.newHashSetWithExpectedSize((int)16);
    private static final String ATTACHMENT_PAGE_CACHE = "attachmentCache";
    private static final String LETTER_LINK = "offerurl";
    private static final String APPLICANT_PHONE = "applyphone";
    private static final String PHONE = "phone";
    private static final Map<String, CfgMessageParser> CFG_MSG_PARSER_MAP = new HashMap<String, CfgMessageParser>(16);

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.getView().setVisible(Boolean.FALSE, new String[]{"mkuser", "bccuser"});
        this.getParentParam();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long msgSceneTypeId = Long.valueOf(customParams.get("msgSceneType").toString());
        Long msgReceiverTypeId = Long.valueOf(customParams.get("msgReceiverType").toString());
        String sendType = (String)customParams.get("sendtype");
        Map<String, String> labelVariableMap = this.constructLabelVariablesMap(msgSceneTypeId, msgReceiverTypeId, sendType);
        this.getView().getPageCache().put("LABEL_VARIABLE_MAP", labelVariableMap.toString());
        this.initMsgTemplate(customParams);
        if (!EMAIL_ATTACHMENT_SERVICE_NEEDED_SCENE_LIST.contains(customParams.get("msgSceneType").toString())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap"});
        }
        this.getModel().setDataChanged(false);
    }

    private void initMsgTemplate(Map<String, Object> customParams) {
        if (Boolean.parseBoolean(customParams.get("letterstatus").toString())) {
            this.getModel().setValue("msgtemplate", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        } else {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_cfgmsginstance");
            QFilter qFilter = new QFilter("billid", "=", customParams.get("offerid"));
            QFilter qFilter2 = new QFilter("receivertype", "=", (Object)customParams.get("msgReceiverType").toString());
            DynamicObject[] msgInstanceDym = helper.query("template,msgchannellist,channelid,category,emailtitle,emailtempcontext,smstempcontext,sendtime", new QFilter[]{qFilter, qFilter2}, "sendtime desc");
            Long initMsgTemplateId = null;
            if (0 == msgInstanceDym.length) {
                Object recruitmentTypeId;
                DynamicObject[] templeteList;
                Long msgReceiverTypeId;
                Long msgSceneTypeId = Long.valueOf(customParams.get("msgSceneType").toString());
                String latestMsgTemplateId = CfgMessageCacheService.getLatestMsgTemplateId((Long)msgSceneTypeId, (Long)(msgReceiverTypeId = Long.valueOf(customParams.get("msgReceiverType").toString())));
                Long l = initMsgTemplateId = latestMsgTemplateId == null ? null : Long.valueOf(latestMsgTemplateId);
                if (null == initMsgTemplateId && (templeteList = this.getTempleteList(msgSceneTypeId, msgReceiverTypeId, recruitmentTypeId = customParams.get("recruitmentType"))) != null && templeteList.length > 0) {
                    initMsgTemplateId = templeteList[0].getLong("id");
                }
            } else {
                initMsgTemplateId = msgInstanceDym[0].getLong("template");
            }
            this.getModel().beginInit();
            this.getModel().setValue("msgtemplate", (Object)initMsgTemplateId);
            this.getModel().endInit();
            DynamicObject msgTemplateDym = this.getView().getModel().getDataEntity().getDynamicObject("msgtemplate");
            if (0 != msgInstanceDym.length) {
                msgTemplateDym.set("msgchannellist", msgInstanceDym[0].get("msgchannellist"));
                DynamicObjectCollection collection = msgTemplateDym.getDynamicObjectCollection("entryentity");
                if (OperationStatus.VIEW == this.getView().getFormShowParameter().getStatus()) {
                    collection.clear();
                }
                Date sendTime = msgInstanceDym[0].getDate("sendtime");
                for (DynamicObject dynamicObject : msgInstanceDym) {
                    if (sendTime.getTime() != dynamicObject.getDate("sendtime").getTime()) break;
                    DynamicObject dynamic = new DynamicObject(collection.getDynamicObjectType());
                    dynamic.set("channelid", dynamicObject.get("channelid"));
                    dynamic.set("category", dynamicObject.get("category"));
                    dynamic.set("emailtitle", dynamicObject.get("emailtitle"));
                    dynamic.set("emailtempcontext", dynamicObject.get("emailtempcontext"));
                    dynamic.set("smstempcontext", dynamicObject.get("smstempcontext"));
                    sendTime = dynamicObject.getDate("sendtime");
                    collection.add((Object)dynamic);
                }
            }
            this.handleNotificationTemplate(customParams, msgTemplateDym);
        }
    }

    private DynamicObject[] getTempleteList(Long msgSceneTypeId, Long msgReceiverTypeId, Object recruitmentTypeId) {
        return CfgMsgTemplateHelper.queryLatestMsgTemplate((Long)msgSceneTypeId, (Long)msgReceiverTypeId, (Object)recruitmentTypeId);
    }

    private void buildChannelsTabs(DynamicObject[] channelObjects, Long msgSceneTypeId, Long msgReceiverTypeId, String sendType) {
        JSONObject channelPageJson = null != this.getView().getPageCache().get("CHANNEL_PAGE_JSON") ? JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON")) : new JSONObject();
        String addTab = this.getView().getPageCache().get("addTab");
        for (DynamicObject channelObject : channelObjects) {
            if ("email".equals(channelObject.getString("category"))) {
                this.createTab("tsrsc_emailmsgtemp", channelObject, channelPageJson, msgSceneTypeId, msgReceiverTypeId, sendType, addTab);
                continue;
            }
            this.createTab("tsrsc_smsmsgtemp", channelObject, channelPageJson, msgSceneTypeId, msgReceiverTypeId, sendType, addTab);
        }
        this.getView().getPageCache().put("CHANNEL_PAGE_JSON", channelPageJson.toString());
    }

    private void createTab(String formId, DynamicObject channelObject, JSONObject json, Long msgSceneTypeId, Long msgReceiverTypeId, String sendType, String addTab) {
        DynamicObjectCollection dynamicObjectCollection;
        FormShowParameter parameter = new FormShowParameter();
        String pageId = parameter.getPageId();
        json.put(channelObject.getString("id"), (Object)pageId);
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.getOpenStyle().setTargetKey("tsctabap");
        parameter.setCaption(channelObject.getString("name"));
        parameter.setCustomParam("msgSceneType", (Object)msgSceneTypeId);
        parameter.setCustomParam("msgReceiverType", (Object)msgReceiverTypeId);
        parameter.setCustomParam("sendtype", (Object)sendType);
        parameter.setCustomParam("msgChannelId", (Object)channelObject.getString("id"));
        parameter.setCustomParam("msgChannelNumber", (Object)channelObject.getString("number"));
        parameter.setCustomParam("category", (Object)channelObject.getString("category"));
        parameter.setStatus(this.getView().getFormShowParameter().getStatus());
        DynamicObject msgtemplate = (DynamicObject)this.getModel().getValue("msgtemplate");
        if (Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParams().get("letterstatus").toString())) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("tsrbd_cfgmsgtemplate");
            DynamicObject dynamicObject = helper.queryOne("entryentity.category, entryentity.channelid, entryentity.emailtitle, entryentity.smstempcontext, entryentity.emailtempcontext", (Object)msgtemplate.getLong("id"));
            dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        } else {
            dynamicObjectCollection = msgtemplate.getDynamicObjectCollection("entryentity");
        }
        String emailTheme = "";
        String smsTemplate = "";
        String emailRichText = "";
        boolean flag = false;
        if (0 != dynamicObjectCollection.size()) {
            for (DynamicObject dyn : dynamicObjectCollection) {
                if (!dyn.getString("channelid").equals(channelObject.getString("id"))) continue;
                parameter.setCustomParam("emailtheme", (Object)dyn.getString("emailtitle"));
                parameter.setCustomParam("smstemplate", (Object)dyn.getString("smstempcontext"));
                parameter.setCustomParam("emailrichtext", (Object)dyn.getString("emailtempcontext"));
                flag = true;
                break;
            }
            if (HRStringUtils.isEmpty((String)addTab) && !flag) {
                for (DynamicObject dyn : dynamicObjectCollection) {
                    if (!dyn.getString("category").equals(channelObject.getString("category"))) continue;
                    parameter.setCustomParam("emailtheme", (Object)dyn.getString("emailtitle"));
                    parameter.setCustomParam("smstemplate", (Object)dyn.getString("smstempcontext"));
                    parameter.setCustomParam("emailrichtext", (Object)dyn.getString("emailtempcontext"));
                    flag = true;
                    break;
                }
            }
        }
        if (HRStringUtils.isEmpty((String)addTab) && !flag) {
            emailTheme = this.getView().getModel().getDataEntity().getString("msgtemplate.emailtheme");
            parameter.setCustomParam("emailtheme", (Object)emailTheme);
            smsTemplate = this.getView().getModel().getDataEntity().getString("msgtemplate.smstemplate");
            parameter.setCustomParam("smstemplate", (Object)smsTemplate);
            DynamicObject msgTemplate = this.getModel().getDataEntity().getDynamicObject("msgtemplate");
            emailRichText = CfgMsgTemplateHelper.queryMsgTemplateEmail((Long)msgTemplate.getLong("id"));
            parameter.setCustomParam("emailrichtext", (Object)emailRichText);
        }
        JSONObject contextJson = new JSONObject();
        contextJson.put("emailtheme", parameter.getCustomParam("emailtheme"));
        contextJson.put("smstemplate", parameter.getCustomParam("smstemplate"));
        contextJson.put("emailrichtext", parameter.getCustomParam("emailrichtext"));
        contextJson.put("category", parameter.getCustomParam("category"));
        this.getView().getPageCache().put((String)parameter.getCustomParam("msgChannelId"), contextJson.toString());
        this.getView().showForm(parameter);
    }

    private void initEmailUser(Map<String, Object> customParams) {
        Object bccUserObj;
        this.setTips(customParams);
        Object mkUserObj = customParams.get("mkuser");
        if (mkUserObj != null) {
            List mkUser = (List)SerializationUtils.fromJsonString((String)mkUserObj.toString(), List.class);
            this.getModel().setValue("mkuser", (Object)mkUser.toArray());
        }
        if ((bccUserObj = customParams.get("bccuser")) != null) {
            List bccUser = (List)SerializationUtils.fromJsonString((String)bccUserObj.toString(), List.class);
            this.getModel().setValue("bccuser", (Object)bccUser.toArray());
        }
    }

    private void setTips(Map<String, Object> customParams) {
        String type = String.valueOf(customParams.get("msgReceiverType"));
        if (CfgMsgRecvType.CANDIDATE.getBaseDataId().equals(type)) {
            MulBasedataEdit text = (MulBasedataEdit)this.getControl("mkuser");
            Tips tips = new Tips();
            String mkUserTips = ResManager.loadKDString((String)"1.\u4e0d\u5f00\u542fOffer Letter\u9644\u4ef6\u52a0\u5bc6\uff0c\u6284\u9001\u4eba\u53ef\u76f4\u63a5\u67e5\u770bOffer Letter\u9644\u4ef6\u5185\u5bb9\uff1b\\r\\n 2.\u5f00\u542fOffer Letter\u9644\u4ef6\u52a0\u5bc6\uff0c\u5efa\u8bae\u201c\u56fa\u5b9a\u5bc6\u7801\u201d\u4e0d\u8981\u968f\u6b63\u6587\u53d1\u9001\uff0c\u5426\u5219\u6284\u9001\u4eba\u5c06\u80fd\u591f\u76f4\u63a5\u67e5\u770bOffer Letter\u9644\u4ef6\u5185\u5bb9\u3002", (String)"MsgTemplateIntegrateEdit_2", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            tips.setContent(new LocaleString(mkUserTips));
            tips.setType("text");
            text.addTips(tips);
            MulBasedataEdit text2 = (MulBasedataEdit)this.getControl("bccuser");
            Tips tips2 = new Tips();
            String bccUserTips = ResManager.loadKDString((String)"1.\u4e0d\u5f00\u542fOffer Letter\u9644\u4ef6\u52a0\u5bc6\uff0c\u5bc6\u9001\u4eba\u53ef\u76f4\u63a5\u67e5\u770bOffer Letter\u9644\u4ef6\u5185\u5bb9\uff1b\\r\\n 2.\u5f00\u542fOffer Letter\u9644\u4ef6\u52a0\u5bc6\uff0c\u5efa\u8bae\u201c\u56fa\u5b9a\u5bc6\u7801\u201d\u4e0d\u8981\u968f\u6b63\u6587\u53d1\u9001\uff0c\u5426\u5219\u5bc6\u9001\u4eba\u5c06\u80fd\u591f\u76f4\u63a5\u67e5\u770bOffer Letter\u9644\u4ef6\u5185\u5bb9\u3002", (String)"MsgTemplateIntegrateEdit_3", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
            tips2.setContent(new LocaleString(bccUserTips));
            tips2.setType("text");
            text2.addTips(tips2);
        }
    }

    private Map<String, String> constructLabelVariablesMap(Long msgPushSceneId, Long msgRecvTypeId, String sendType) {
        DynamicObject[] msgTempVariables = CfgMsgTemplateHelper.getMsgTempVariables((Long)msgPushSceneId, (Long)msgRecvTypeId);
        HashMap map = Maps.newHashMapWithExpectedSize((int)msgTempVariables.length);
        for (DynamicObject msgTempVariable : msgTempVariables) {
            if ("2".equals(sendType) && LETTER_LINK.equals(msgTempVariable.getString("fieldname"))) continue;
            map.put(msgTempVariable.getString("fieldname"), msgTempVariable.getString("name"));
        }
        return map;
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit msgTemplate = (BasedataEdit)this.getControl("msgtemplate");
        msgTemplate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"previewlbl", "vectorap"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption operateOption = formOperate.getOption();
        String operateKey = formOperate.getOperateKey();
        if ("sendmessage".equals(operateKey)) {
            logger.info("{} send message", (Object)RequestContext.get().getCurrUserId());
            this.getParentParam();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            ArrayList<Map<String, Object>> receiverList = (ArrayList<Map<String, Object>>)customParams.get("receiver_list");
            if (null == receiverList) {
                receiverList = new ArrayList<Map<String, Object>>(1);
                receiverList.add(customParams);
            }
            String msgChannelList = this.getModel().getDataEntity().getString("msgchannellist");
            logger.info("the message Channel List:{}", (Object)msgChannelList);
            if (msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
                return;
            }
            DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgChannels((List)CfgMsgFormService.getChannelListId((String)msgChannelList));
            ArrayList<MessageContentDO> afterParseMessageContentDOList = new ArrayList<MessageContentDO>(10);
            ArrayList<MessageEntryDto> beforeParseMessageEntryList = new ArrayList<MessageEntryDto>(10);
            List<String> sendRecentlyIds = this.isSendSuccessfulRecently(customParams, receiverList);
            this.getView().getPageCache().put("sendRecently", String.join((CharSequence)",", sendRecentlyIds));
            if (!sendRecentlyIds.isEmpty() && sendRecentlyIds.size() == receiverList.size()) {
                logger.info("TscMsgTempIntegrateEdit.afterDoOperation.:SendSuccessfulRecently");
                return;
            }
            JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
            for (DynamicObject channel : dynamicObjects) {
                for (Map map : receiverList) {
                    if ("shortMsg".equals(channel.getString("category")) && ObjectUtils.isEmpty(map.get(PHONE))) continue;
                    MessageEntryDto messageEntryDto = new MessageEntryDto();
                    MessageContentDO afterParseMessageContentDO = this.constructMessageContentDOFromView(messageEntryDto, pageJson, channel, operateOption, map);
                    if (null != map.get("oprecordid")) {
                        this.setMsgTrackDTO(customParams, map, afterParseMessageContentDO, channel.getString("category"));
                    }
                    beforeParseMessageEntryList.add(messageEntryDto);
                    afterParseMessageContentDOList.add(afterParseMessageContentDO);
                }
            }
            List msgIds = CfgMessageService.sendMessage(afterParseMessageContentDOList);
            ArrayList objMsgIds = new ArrayList(msgIds);
            args.getOperationResult().setSuccessPkIds(objMsgIds);
            MsgTrackHelper.batchSaveMsgTrackAndObj(afterParseMessageContentDOList);
            MsgInstanceHelper.batchSaveMsgObj(beforeParseMessageEntryList, (String)customParams.get("offerid").toString(), (Long)this.getModel().getDataEntity().getDynamicObject("msgtemplate").getLong("id"), (String)msgChannelList, (Long)Long.valueOf(customParams.get("msgReceiverType").toString()));
        }
    }

    private void getParentParam() {
        DynamicObject contact;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("contactphone", this.getView().getParentView().getModel().getValue("contactphone"));
        customParams.put("contactemail", this.getView().getParentView().getModel().getValue("contactemail"));
        DynamicObject address = (DynamicObject)this.getView().getParentView().getModel().getValue("reportaddress");
        if (!HRObjectUtils.isEmpty((Object)address)) {
            customParams.put("reportaddress", address.getString("name"));
        }
        if (!HRObjectUtils.isEmpty((Object)(contact = (DynamicObject)this.getView().getParentView().getModel().getValue("contact")))) {
            customParams.put("contact", contact.getString("name"));
        }
        IPageCache cache = this.getView().getParentView().getParentView().getPageCache();
        String verifyCode = OfferAdviceBizHelper.getParentCache((IPageCache)cache, (String)"verifycode");
        customParams.put("verifycode", verifyCode);
    }

    private List<String> isSendSuccessfulRecently(Map<String, Object> customParams, List<Map<String, Object>> receiverList) {
        ArrayList<String> sendRecentlyIds = new ArrayList<String>(receiverList.size());
        long pushScene = Long.parseLong((String)customParams.get("msgSceneType"));
        List bizObjIdList = receiverList.stream().map(bizObj -> (Long)bizObj.get("bizobj")).collect(Collectors.toList());
        HRBaseServiceHelper msgTrackHelper = new HRBaseServiceHelper("tsrbd_msgtrack");
        QFilter msgTrackQFilter = new QFilter("sender", "=", (Object)RequestContext.get().getCurrUserId());
        msgTrackQFilter.and("pushscene", "=", (Object)pushScene);
        msgTrackQFilter.and("sendstatus", "=", (Object)"1");
        Date oneMinuteBefore = HRDateTimeUtils.addMinute((Date)new Date(), (long)-1L);
        msgTrackQFilter.and("sendtime", ">=", (Object)oneMinuteBefore);
        DynamicObject[] msgTrackDys = msgTrackHelper.query(new QFilter[]{msgTrackQFilter});
        if (null != msgTrackDys && msgTrackDys.length > 0) {
            HRBaseServiceHelper msgTrackObjHelper = new HRBaseServiceHelper("tsrbd_msgtrackobj");
            List msgTrackIdsList = Arrays.stream(msgTrackDys).map(msgTrackDy -> msgTrackDy.getLong("id")).collect(Collectors.toList());
            QFilter msgTrackObjQFilter = new QFilter("msgtrackid", "in", msgTrackIdsList);
            DynamicObject[] msgTrackObjDys = msgTrackObjHelper.query("msgtrackid,bizobj", new QFilter[]{msgTrackObjQFilter});
            List msgTrackObjIdList = Arrays.stream(msgTrackObjDys).map(msgTrackObjDy -> msgTrackObjDy.getLong("bizobj")).distinct().collect(Collectors.toList());
            for (Long msgTrackObjId : msgTrackObjIdList) {
                for (Long bizObjId : bizObjIdList) {
                    if (!bizObjId.equals(msgTrackObjId)) continue;
                    sendRecentlyIds.add(bizObjId.toString());
                }
            }
        }
        return sendRecentlyIds;
    }

    private MessageContentDO constructMessageContentDOFromView(MessageEntryDto messageEntryDto, JSONObject pageJson, DynamicObject channel, OperateOption operateOption, Map<String, Object> customParams) {
        String messageTemplate = "";
        String theme = ResManager.loadKDString((String)"\u77ed\u4fe1\u901a\u77e5", (String)"MsgTemplateIntegrateEdit_4", (String)"tsc-tso-formplugin", (Object[])new Object[0]);
        Map<String, String> labelVariableMap = TscMsgTempIntegrateEdit.mapStringToMap(this.getView().getPageCache().get("LABEL_VARIABLE_MAP"));
        IFormView tabView = this.getView().getView(pageJson.getString(channel.getString("id")));
        if (HRStringUtils.isEmpty((String)tabView.getPageCache().get("category"))) {
            String contextJsonStr = this.getView().getPageCache().get(channel.getString("id"));
            JSONObject contextJson = JSONObject.parseObject((String)contextJsonStr);
            if ("email".equals(contextJson.getString("category"))) {
                theme = contextJson.getString("emailtheme");
                customParams.put("emailtheme", CfgMsgParserBizHelper.parseEmailTheme((String)theme, labelVariableMap, customParams));
                EmailMessageParser emailMessageParse = new EmailMessageParser();
                String emailTemplate = contextJson.getString("emailrichtext");
                messageEntryDto.setEmailTempContext(emailTemplate);
                messageTemplate = emailMessageParse.parseMessage(emailTemplate, customParams, labelVariableMap);
            } else if ("shortMsg".equals(contextJson.getString("category")) || "shortMsg".equals(channel.getString("category"))) {
                String template = contextJson.getString("smstemplate");
                messageEntryDto.setSmsTempContext(template);
                SmsMessageParser smsMessageParse = new SmsMessageParser();
                messageTemplate = smsMessageParse.parseMessage(template, customParams, labelVariableMap);
            }
        } else if ("email".equals(channel.getString("category"))) {
            theme = CfgMsgParserBizHelper.parseEmailTheme((String)String.valueOf(tabView.getModel().getValue("emailtheme")), labelVariableMap, customParams);
            RichTextEditor emailRichText = (RichTextEditor)tabView.getControl("emailrichtext");
            messageTemplate = emailRichText.getText();
            messageEntryDto.setEmailTempContext(messageTemplate);
        } else {
            messageTemplate = String.valueOf(tabView.getModel().getValue("smstemplate"));
            messageEntryDto.setSmsTempContext(messageTemplate);
        }
        if (ObjectUtils.isNotEmpty((Object)customParams.get("ccFlag"))) {
            theme = ResManager.loadKDString((String)"\u6284\u9001-", (String)"MsgTemplateIntegrateEdit_1", (String)"tsc-tso-formplugin", (Object[])new Object[0]) + theme;
        }
        customParams.put("emailtheme", theme);
        customParams.put("replaceVar", "true");
        String phoneObject = operateOption.getVariableValue(PHONE, (String)customParams.get(PHONE));
        String emailObject = operateOption.getVariableValue("email", (String)customParams.get("email"));
        MessageContentDO afterMessageContentDO = new MessageContentDO();
        afterMessageContentDO.setChannelType(channel.getString("category"));
        afterMessageContentDO.setChannelNumber(channel.getString("number"));
        if (ObjectUtils.isEmpty((Object)customParams.get("ccFlag"))) {
            customParams.put("URL_REPLACE_FLAG", Boolean.TRUE);
        } else {
            customParams.put("URL_REPLACE_FLAG", Boolean.FALSE);
        }
        messageEntryDto.setEmailTitle(theme);
        messageEntryDto.setCategory(channel.getString("category"));
        messageEntryDto.setChannelId(Long.valueOf(channel.getLong("id")));
        String messageContent = CFG_MSG_PARSER_MAP.get(channel.getString("category")).parseMessage(messageTemplate, customParams, labelVariableMap);
        afterMessageContentDO.setMessageContent(messageContent);
        afterMessageContentDO.setReceiverPhone(phoneObject);
        afterMessageContentDO.setReceiverEmail(emailObject);
        afterMessageContentDO.setMessageAttachment(this.wrapMessageAttachment());
        afterMessageContentDO.setEmailTitle(theme);
        if (null != customParams.get("boType")) {
            String boType = customParams.get("boType").toString();
            afterMessageContentDO.setBoType(boType);
        }
        this.setEmailInfo(afterMessageContentDO);
        return afterMessageContentDO;
    }

    private MessageAttachment wrapMessageAttachment() {
        JSONArray attachments;
        IPageCache pageCache = this.getPageCache();
        MessageAttachment messageAttachments = new MessageAttachment();
        String attachmentCache = pageCache.get(ATTACHMENT_PAGE_CACHE);
        if (!HRStringUtils.isEmpty((String)attachmentCache) && (attachments = JSON.parseArray((String)attachmentCache)).size() > 0) {
            ArrayList<String> attachmentNameList = new ArrayList<String>(attachments.size());
            ArrayList<byte[]> attachmentDataList = new ArrayList<byte[]>(attachments.size());
            for (int i = 0; i < attachments.size(); ++i) {
                JSONObject attachment = attachments.getJSONObject(i);
                String attachmentName = attachment.getString("name");
                String fileUrl = attachment.getString("url");
                byte[] attachmentData = fileUrl.contains("redis") ? this.getAttachmentByteData(attachment.getString("url")) : this.getFileBytes(attachment.getString("url"));
                attachmentNameList.add(attachmentName);
                attachmentDataList.add(attachmentData);
            }
            messageAttachments.setAttachmentNames(attachmentNameList);
            messageAttachments.setAttachments(attachmentDataList);
        }
        this.setOfferAttach(messageAttachments);
        logger.info("messageAttachments:{}", (Object)messageAttachments.getAttachmentNames());
        return messageAttachments.getAttachmentNames() == null ? null : messageAttachments;
    }

    private void setOfferAttach(MessageAttachment messageAttachments) {
        String objId = (String)this.getView().getFormShowParameter().getCustomParam("offerattachobjid");
        if (HRStringUtils.isEmpty((String)objId)) {
            return;
        }
        logger.info("kd.tsc.tsrbd.formplugin.web.cfgmsgtemplate.MsgTemplateAttachmentEdit objId is {}", (Object)objId);
        IAppCache appCache = AppCache.get((String)"offerattach");
        List attachments = (List)appCache.get(objId, List.class);
        logger.info("kd.tsc.tsrbd.formplugin.web.cfgmsgtemplate.MsgTemplateAttachmentEdit attachments is {}", (Object)attachments);
        if (CollectionUtils.isEmpty((Collection)attachments)) {
            return;
        }
        JSONArray attachmentArray = new JSONArray();
        for (Map attachment : attachments) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("uid", (Object)((String)attachment.get("uid")));
            jsonObject.put("name", (Object)((String)attachment.get("name")));
            jsonObject.put("url", (Object)((String)attachment.get("url")));
            attachmentArray.add((Object)jsonObject);
        }
        ArrayList<String> attachmentNameList = new ArrayList<String>(attachments.size());
        ArrayList<byte[]> attachmentDataList = new ArrayList<byte[]>(attachments.size());
        for (int i = 0; i < attachmentArray.size(); ++i) {
            JSONObject attachment = attachmentArray.getJSONObject(i);
            String attachmentName = attachment.getString("name");
            String fileUrl = attachment.getString("url");
            byte[] attachmentData = fileUrl.contains("redis") ? this.getAttachmentByteData(attachment.getString("url")) : this.getFileBytes(attachment.getString("url"));
            attachmentNameList.add(attachmentName);
            attachmentDataList.add(attachmentData);
        }
        if (messageAttachments.getAttachmentNames() == null) {
            messageAttachments.setAttachmentNames(attachmentNameList);
        } else {
            messageAttachments.getAttachmentNames().addAll(attachmentNameList);
        }
        if (messageAttachments.getAttachments() == null) {
            messageAttachments.setAttachments(attachmentDataList);
        } else {
            messageAttachments.getAttachments().addAll(attachmentDataList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getFileBytes(String url) {
        InputStream inputStream = null;
        try {
            URL httpUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            inputStream = conn.getInputStream();
            byte[] byArray = this.input2byte(inputStream);
            return byArray;
        }
        catch (Exception e) {
            logger.info("IO Exception:{}", (Object)e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAttachmentByteData(String url) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream is = cache.getInputStream(url);
        byte[] attachmentData = new byte[]{};
        try {
            attachmentData = this.input2byte(is);
        }
        catch (IOException var14) {
            logger.info("IO Exception:{}", (Object)var14.getMessage());
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException var13) {
                logger.error(WfUtils.getExceptionStacktrace((Throwable)var13));
            }
        }
        return attachmentData;
    }

    private byte[] input2byte(InputStream inStream) throws IOException {
        try (ByteArrayOutputStream swapStream = new ByteArrayOutputStream();){
            byte[] in2b;
            int rc;
            byte[] buff = new byte[1024];
            boolean var4 = false;
            while ((rc = inStream.read(buff, 0, 1024)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            byte[] byArray = in2b = swapStream.toByteArray();
            return byArray;
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        IPageCache pageCache = this.getPageCache();
        JSONArray attachments = new JSONArray();
        String attachmentCache = pageCache.get(ATTACHMENT_PAGE_CACHE);
        if (!HRStringUtils.isEmpty((String)attachmentCache)) {
            attachments = JSON.parseArray((String)attachmentCache);
        }
        for (int i = 0; i < urls.length; ++i) {
            Map url = (Map)evt.getUrls()[i];
            JSONObject attachment = new JSONObject();
            attachment.put("uid", (Object)((String)url.get("uid")));
            attachment.put("name", (Object)((String)url.get("name")));
            attachment.put("url", (Object)((String)url.get("url")));
            attachments.add((Object)attachment);
        }
        pageCache.put(ATTACHMENT_PAGE_CACHE, attachments.toJSONString());
    }

    public void remove(UploadEvent evt) {
        Map url = (Map)evt.getUrls()[0];
        String uid = (String)url.get("uid");
        IPageCache pageCache = this.getPageCache();
        String attachmentCache = pageCache.get(ATTACHMENT_PAGE_CACHE);
        if (!HRStringUtils.isEmpty((String)attachmentCache)) {
            JSONArray attachments = JSON.parseArray((String)attachmentCache);
            for (int i = 0; i < attachments.size(); ++i) {
                JSONObject attachment = attachments.getJSONObject(i);
                if (!attachment.getString("uid").equalsIgnoreCase(uid)) continue;
                attachments.remove((Object)attachment);
                break;
            }
            pageCache.put(ATTACHMENT_PAGE_CACHE, attachments.toJSONString());
        }
    }

    private void setEmailInfo(MessageContentDO messageContentDO) {
        DynamicObjectCollection mkUserCollection = this.getModel().getDataEntity().getDynamicObjectCollection("mkuser");
        List emailCrList = mkUserCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getString("email")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        messageContentDO.setEmailCrList(!emailCrList.isEmpty() ? emailCrList : null);
        DynamicObjectCollection bccUserCollection = this.getModel().getDataEntity().getDynamicObjectCollection("bccuser");
        List emailSrList = bccUserCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getString("email")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        messageContentDO.setEmailSrList(!emailSrList.isEmpty() ? emailSrList : null);
    }

    public static Map<String, String> mapStringToMap(String stringMap) {
        String[] strings;
        HashMap<String, String> map = new HashMap<String, String>(16);
        stringMap = stringMap.replaceAll("\\{", "").replaceAll("\\}", "");
        for (String str : strings = stringMap.split(",")) {
            String[] s = str.split("=");
            map.put(s[0], s[1]);
        }
        return map;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("msgtemplate".equals(property)) {
            Object recruscene;
            Object intvcategory;
            Object interviewMethod;
            String sendType;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long msgSceneTypeId = Long.valueOf(customParams.get("msgSceneType").toString());
            Long msgReceiverTypeId = Long.valueOf(customParams.get("msgReceiverType").toString());
            Object recruitmentTypeId = customParams.get("recruitmentType");
            QFilter msgTemplateFilter = new QFilter("msgpushscene", "=", (Object)msgSceneTypeId).and(new QFilter("msgreceiver", "=", (Object)msgReceiverTypeId));
            QFilter baseDataQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"tsrbd_cfgmsgtemplate", (Long)RequestContext.get().getOrgId());
            if (null != baseDataQFilter) {
                msgTemplateFilter.and(baseDataQFilter);
            }
            if (recruitmentTypeId != null) {
                msgTemplateFilter.and("recrutype", "=", recruitmentTypeId);
            }
            if (!HRStringUtils.isEmpty((String)(sendType = (String)customParams.get("sendtype")))) {
                formShowParameter.getListFilterParameter().setFilter(new QFilter("sendtype", "=", (Object)sendType));
            }
            if (ObjectUtils.isNotEmpty(interviewMethod = customParams.get("intvmethod"))) {
                msgTemplateFilter.and("intvmethod.fbasedataid_id", "=", interviewMethod);
            }
            if (ObjectUtils.isNotEmpty(intvcategory = customParams.get("intvcategory"))) {
                msgTemplateFilter.and(new QFilter("intvcategory.fbasedataid_id", "=", intvcategory).or("intvcategory.fbasedataid_id", "=", null));
            }
            if (ObjectUtils.isNotEmpty(recruscene = customParams.get("recruscene")) && Long.parseLong(recruscene.toString()) != 0L) {
                msgTemplateFilter.and(new QFilter("recruscene.fbasedataid_id", "=", recruscene).or("recruscene.fbasedataid_id", "=", null));
            }
            formShowParameter.getListFilterParameter().getQFilters().add(msgTemplateFilter);
            logger.info("TscMsgTempIntegrateEdit.beforeF7Select.msgTemplateFilter->{}", (Object)msgTemplateFilter);
            formShowParameter.getListFilterParameter().setOrderBy("issyspreset desc,modifytime desc");
        }
    }

    private void handleNotificationTemplate(Map<String, Object> customParams, DynamicObject msgTemplateDym) {
        if (msgTemplateDym == null) {
            this.getModel().setValue("msgchannellist", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
            ComboEdit comboEdit = (ComboEdit)this.getControl("msgchannellist");
            ArrayList data = new ArrayList(1);
            comboEdit.setComboItems(data);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
            Long msgSceneTypeId = Long.valueOf(customParams.get("msgSceneType").toString());
            Long msgReceiverTypeId = Long.valueOf(customParams.get("msgReceiverType").toString());
            String sendType = (String)customParams.get("sendtype");
            String msgChannelList = msgTemplateDym.getString("msgchannellist");
            JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
            if (null != pageJson) {
                for (Map.Entry entry : pageJson.entrySet()) {
                    if (null == this.getView().getView(String.valueOf(entry.getValue()))) continue;
                    this.getView().getView(String.valueOf(entry.getValue())).close();
                    this.getView().sendFormAction(this.getView().getView(String.valueOf(entry.getValue())));
                }
            }
            DynamicObject[] channelObjects = CfgMsgTemplateHelper.queryCfgMsgChannels(null);
            if (OperationStatus.VIEW != this.getView().getFormShowParameter().getStatus()) {
                CfgMsgFormService.loadComboItemsInMultiComboEdit((IFormView)this.getView(), (DynamicObject[])channelObjects, (String)"msgchannellist");
                channelObjects = (DynamicObject[])Arrays.stream(channelObjects).filter(channel -> msgChannelList.contains(channel.getString("id"))).toArray(DynamicObject[]::new);
            } else {
                channelObjects = CfgMsgTemplateHelper.queryMsgChannels((List)CfgMsgFormService.getChannelListId((String)msgChannelList));
                CfgMsgFormService.loadComboItemsInMultiComboEdit((IFormView)this.getView(), (DynamicObject[])channelObjects, (String)"msgchannellist");
            }
            this.getModel().beginInit();
            this.getModel().setValue("msgchannellist", (Object)Arrays.stream(channelObjects).map(channel -> channel.getString("id")).collect(Collectors.joining(",")));
            this.getModel().endInit();
            this.getView().updateView("msgchannellist");
            this.buildChannelsTabs(channelObjects, msgSceneTypeId, msgReceiverTypeId, sendType);
            this.activeNotificationMethods();
            if (EMAIL_ATTACHMENT_SERVICE_NEEDED_SCENE_LIST.contains(this.getView().getFormShowParameter().getCustomParams().get("msgSceneType").toString())) {
                long msgTemplateId = msgTemplateDym.getLong("id");
                List attachments = AttachmentServiceHelper.getAttachments((String)"tsrbd_cfgmsgtemplate", (Object)msgTemplateId, (String)"attachmentpanelap");
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
                attachmentPanel.bindData(attachments);
                String cache = this.getPageCache().get(ATTACHMENT_PAGE_CACHE);
                if (!HRStringUtils.isEmpty((String)cache)) {
                    this.getPageCache().remove(ATTACHMENT_PAGE_CACHE);
                }
                JSONArray attachmentArray = new JSONArray();
                for (Map attachment : attachments) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("uid", (Object)((String)attachment.get("uid")));
                    jsonObject.put("name", (Object)((String)attachment.get("name")));
                    jsonObject.put("url", (Object)((String)attachment.get("url")));
                    attachmentArray.add((Object)jsonObject);
                }
                IPageCache pageCache = this.getPageCache();
                pageCache.put(ATTACHMENT_PAGE_CACHE, attachmentArray.toJSONString());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        this.getParentParam();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("previewlbl".equals(control.getKey()) || "vectorap".equals(control.getKey())) {
            this.updateCustomParams(customParams);
            Map<String, String> labelVariableMap = TscMsgTempIntegrateEdit.mapStringToMap(this.getView().getPageCache().get("LABEL_VARIABLE_MAP"));
            IAppCache iAppCache = AppCache.get((String)"tsc_tsrbd_msgtemplate");
            this.getView().getFormShowParameter().setCustomParam("replaceVar", (Object)"true");
            customParams.put("URL_REPLACE_FLAG", Boolean.FALSE);
            String msgChannelStr = this.getModel().getDataEntity().getString("msgchannellist");
            if (HRStringUtils.isEmpty((String)msgChannelStr)) {
                return;
            }
            DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgChannels((List)CfgMsgFormService.getChannelListId((String)msgChannelStr));
            JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
            JSONArray jsonArray = new JSONArray();
            for (DynamicObject dyn : dynamicObjects) {
                IFormView tabView = this.getView().getView(pageJson.getString(dyn.getString("id")));
                HashMap<String, String> map = new HashMap<String, String>(3);
                if (null == tabView || HRStringUtils.isEmpty((String)tabView.getPageCache().get("category"))) {
                    String contextJsonStr = this.getView().getPageCache().get(dyn.getString("id"));
                    JSONObject contextJson = JSONObject.parseObject((String)contextJsonStr);
                    if ("email".equals(contextJson.getString("category"))) {
                        String theme = contextJson.getString("emailtheme");
                        customParams.put("emailtheme", CfgMsgParserBizHelper.parseEmailTheme((String)theme, labelVariableMap, (Map)customParams));
                        EmailMessageParser emailMessageParse = new EmailMessageParser();
                        String emailTemplate = contextJson.getString("emailrichtext");
                        String emailContent = emailMessageParse.parseMessage(emailTemplate, customParams, labelVariableMap);
                        map.put("content", emailContent);
                    } else if ("shortMsg".equals(contextJson.getString("category"))) {
                        String smsTemplate = contextJson.getString("smstemplate");
                        SmsMessageParser smsMessageParse = new SmsMessageParser();
                        String smsContent = smsMessageParse.parseMessage(smsTemplate, customParams, labelVariableMap);
                        map.put("content", smsContent);
                    } else if ("mobileApp".equals(contextJson.getString("category"))) {
                        map.put("content", null);
                    }
                } else if ("email".equals(dyn.getString("category"))) {
                    String theme = String.valueOf(tabView.getModel().getValue("emailtheme"));
                    customParams.put("emailtheme", CfgMsgParserBizHelper.parseEmailTheme((String)theme, labelVariableMap, (Map)customParams));
                    EmailMessageParser emailMessageParse = new EmailMessageParser();
                    RichTextEditor emailRichText = (RichTextEditor)tabView.getControl("emailrichtext");
                    String emailTemplate = emailRichText.getText();
                    String emailContent = emailMessageParse.parseMessage(emailTemplate, customParams, labelVariableMap);
                    map.put("content", emailContent);
                } else if ("shortMsg".equals(dyn.getString("category"))) {
                    String smsTemplate = String.valueOf(tabView.getModel().getValue("smstemplate"));
                    SmsMessageParser smsMessageParse = new SmsMessageParser();
                    String smsContent = smsMessageParse.parseMessage(smsTemplate, customParams, labelVariableMap);
                    map.put("content", smsContent);
                } else if ("mobileApp".equals(dyn.getString("category"))) {
                    map.put("content", null);
                }
                map.put("tabName", dyn.getString("name"));
                map.put("category", dyn.getString("category"));
                jsonArray.add(map);
            }
            iAppCache.put("tabItems", (Object)jsonArray);
            CfgMsgFormService.slidePreviewForm((IFormView)this.getView(), (String)CfgMsgTemplateConstants.MSG_TEMPLATE_ENTITY2);
        }
    }

    private void updateCustomParams(Map<String, Object> customParams) {
        Long offerId = (Long)customParams.get("offerid");
        if (offerId != 0L) {
            DynamicObject offer = OfferServiceHelper.getInstance().getOfferById(offerId);
            if (HRObjectUtils.isEmpty((Object)offer)) {
                return;
            }
            DynamicObject applicant = offer.getDynamicObject("applicant");
            if (!HRObjectUtils.isEmpty((Object)applicant)) {
                customParams.put(APPLICANT_PHONE, TerracePhoneFormChangeUtil.getFormChangePhone((String)applicant.getString(PHONE)));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("msgtemplate".equals(propertyName)) {
            DynamicObject msgTemplateDym = (DynamicObject)args.getChangeSet()[0].getNewValue();
            this.getView().getPageCache().remove("addTab");
            this.handleNotificationTemplate(customParams, msgTemplateDym);
        }
        if ("msgchannellist".equals(propertyName)) {
            this.buildTabPage(customParams, args);
            this.activeNotificationMethods();
        }
    }

    private void buildTabPage(Map<String, Object> customParams, PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        ArrayList newNotifications = null == changeData.getNewValue() ? new ArrayList() : Arrays.asList(String.valueOf(changeData.getNewValue()).split(","));
        ArrayList oldNotifications = null == changeData.getOldValue() ? new ArrayList() : Arrays.asList(String.valueOf(changeData.getOldValue()).split(","));
        for (String newNotification : newNotifications) {
            if (HRStringUtils.isEmpty((String)newNotification) || oldNotifications.contains(newNotification)) continue;
            this.getView().getPageCache().put("addTab", "1");
            Long msgSceneTypeId = Long.valueOf(customParams.get("msgSceneType").toString());
            Long msgReceiverTypeId = Long.valueOf(customParams.get("msgReceiverType").toString());
            String sendType = (String)customParams.get("sendtype");
            this.buildChannelsTabs(CfgMsgTemplateHelper.queryCfgMsgChannels(Collections.singletonList(Long.valueOf(newNotification))), msgSceneTypeId, msgReceiverTypeId, sendType);
        }
        for (String oldNotification : oldNotifications) {
            if (newNotifications.contains(oldNotification) || HRStringUtils.isEmpty((String)oldNotification)) continue;
            JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
            if (null == this.getView().getView(pageJson.getString(oldNotification))) continue;
            this.getView().getView(pageJson.getString(oldNotification)).close();
            this.getView().sendFormAction(this.getView().getView(pageJson.getString(oldNotification)));
            pageJson.remove((Object)oldNotification);
        }
    }

    private void activeNotificationMethods() {
        String msgChannelList = this.getModel().getDataEntity().getString("msgchannellist");
        if (msgChannelList == null || HRStringUtils.isEmpty((String)msgChannelList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2", "mkuser", "bccuser"});
            return;
        }
        DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryMsgChannels((List)CfgMsgFormService.getChannelListId((String)msgChannelList));
        boolean flag = Arrays.stream(dynamicObjects).anyMatch(dyn -> "email".equals(dyn.getString("category")));
        if (flag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mkuser", "bccuser"});
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.initEmailUser(customParams);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mkuser", "bccuser"});
        }
        JSONObject pageJson = JSONObject.parseObject((String)this.getView().getPageCache().get("CHANNEL_PAGE_JSON"));
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
        String[] msgChannels = msgChannelList.split(",");
        Tab tab = (Tab)this.getControl("tsctabap");
        for (String msgChannel : msgChannels) {
            if (HRStringUtils.isEmpty((String)msgChannel)) continue;
            tab.activeTab(pageJson.getString(msgChannel));
            break;
        }
    }

    private void setMsgTrackDTO(Map<String, Object> customParams, Map<String, Object> receiverParam, MessageContentDO messageContentDO, String msgChannel) {
        MsgTrackDTO msgTrackDTO = new MsgTrackDTO();
        String recName = (String)receiverParam.get("candidatename");
        String sceneName = CfgMsgScenes.getSceneNameById((String)((String)customParams.get("msgSceneType")));
        msgTrackDTO.setName(String.format(ResManager.loadKDString((String)"%s\u7684%s\u6d88\u606f", (String)"MsgTemplateIntegrateEdit_0", (String)"tsc-tso-formplugin", (Object[])new Object[0]), recName, sceneName));
        msgTrackDTO.setPushScene(Long.valueOf(Long.parseLong((String)customParams.get("msgSceneType"))));
        msgTrackDTO.setRecType(Long.valueOf(Long.parseLong((String)customParams.get("msgReceiverType"))));
        msgTrackDTO.setRecName(recName);
        msgTrackDTO.setRecEmail(messageContentDO.getReceiverEmail());
        msgTrackDTO.setRecPhone(messageContentDO.getReceiverPhone());
        msgTrackDTO.setNotMethod(Long.valueOf(Long.parseLong(msgChannel)));
        msgTrackDTO.setEmailTitle(messageContentDO.getEmailTitle());
        msgTrackDTO.setSender(Long.valueOf(RequestContext.get().getCurrUserId()));
        msgTrackDTO.setMsgContent(messageContentDO.getMessageContent());
        msgTrackDTO.setOpRecordID((Long)receiverParam.get("oprecordid"));
        msgTrackDTO.setBizEntity(customParams.get("bizentity").toString());
        msgTrackDTO.setBizObj((Long)receiverParam.get("bizobj"));
        messageContentDO.setMsgTrackDTO(msgTrackDTO);
    }

    static {
        CFG_MSG_PARSER_MAP.put("email", (CfgMessageParser)new EmailMessageParser());
        CFG_MSG_PARSER_MAP.put("shortMsg", (CfgMessageParser)new SmsMessageParser());
        CFG_MSG_PARSER_MAP.put("mobileApp", (CfgMessageParser)new SmsMessageParser());
        EMAIL_ATTACHMENT_SERVICE_NEEDED_SCENE_LIST.add(CfgMsgScenes.OFFER_NOTIFY.getBaseDataId());
    }
}

