/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.formplugin.web.msgtemplate;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FireFocusEvent;
import kd.bos.form.control.events.InputFocusListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.util.SecurityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMsgTemplateHelper;
import kd.tsc.tsrbd.common.constants.MsgTplConstants;

public class TscMsgTempTabEdit
extends HRDataBaseEdit
implements InputFocusListener {
    private static Log logger = LogFactory.getLog(TscMsgTempTabEdit.class);

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long msgSceneTypeId = Long.valueOf(String.valueOf(customParams.get("msgSceneType")));
        this.getView().getPageCache().put("msgSceneType", msgSceneTypeId.toString());
        Long msgReceiverTypeId = Long.valueOf(String.valueOf(customParams.get("msgReceiverType")));
        String sendType = String.valueOf(customParams.get("sendtype"));
        Long msgChannelId = Long.valueOf(String.valueOf(customParams.get("msgChannelId")));
        String msgChannelCategory = String.valueOf(customParams.get("category"));
        this.getView().getPageCache().put("category", msgChannelCategory);
        this.getView().getPageCache().saveChanges();
        this.loadTabItems(customParams, msgChannelCategory);
        this.reloadMsgTempVariablesLabelData(msgSceneTypeId, msgReceiverTypeId, msgChannelId, msgChannelCategory, sendType);
        this.getModel().setDataChanged(false);
    }

    public void initialize() {
        super.initialize();
        RichTextEditor richText = (RichTextEditor)this.getControl("emailrichtext");
        if (null != richText) {
            richText.addInputFocusListener((InputFocusListener)this);
        }
    }

    public void reloadMsgTempVariablesLabelData(Long msgPushSceneId, Long msgRecvTypeId, Long msgChannelId, String msgChannelCategory, String sendType) {
        HashMap paramMap = Maps.newHashMap();
        List<Map<String, String>> labelBOList = this.constructMsgTempVariables(msgChannelCategory, msgPushSceneId, msgRecvTypeId, msgChannelId);
        if ("2".equals(sendType)) {
            labelBOList.removeIf(map -> map.containsValue("email_offerurl"));
        }
        paramMap.put("items", this.createLabelShowPanel(labelBOList).createControl().get("items"));
        String flexName = "";
        flexName = "email".equals(msgChannelCategory) ? "emailvariablesap" : "smsvariablesap";
        this.getView().updateControlMetadata(flexName, (Map)paramMap);
    }

    public FlexPanelAp createLabelShowPanel(List<Map<String, String>> labelBOList) {
        FlexPanelAp labelShowPanelAp = new FlexPanelAp();
        labelShowPanelAp.setKey("ffffww");
        for (Map<String, String> labelBO : labelBOList) {
            LabelAp label = this.createLabel(labelBO.get("name"), labelBO.get("id"));
            labelShowPanelAp.getItems().add(label);
        }
        return labelShowPanelAp;
    }

    public LabelAp createLabel(String labelName, String labelTagObjId) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("label" + labelTagObjId);
        labelAp.setName(new LocaleString(labelName));
        labelAp.setForeColor("#0E5FD8");
        labelAp.setFontSize(14);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("20px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        labelAp.setClickable(true);
        return labelAp;
    }

    public List<Map<String, String>> constructMsgTempVariables(String msgChannelCategory, Long msgPushSceneId, Long msgRecvTypeId, Long msgChannelId) {
        DynamicObject[] msgTempVariables = CfgMsgTemplateHelper.getMsgTempVariables((Long)msgPushSceneId, (Long)msgRecvTypeId, (Long)msgChannelId);
        if (0 == msgTempVariables.length) {
            msgTempVariables = "email".equals(msgChannelCategory) ? CfgMsgTemplateHelper.getMsgTempVariables((Long)msgPushSceneId, (Long)msgRecvTypeId, (Long)MsgTplConstants.EMAIL_CHANNEL_PRIMARY_KEY) : CfgMsgTemplateHelper.getMsgTempVariables((Long)msgPushSceneId, (Long)msgRecvTypeId, (Long)MsgTplConstants.SMS_CHANNEL_PRIMARY_KEY);
            for (DynamicObject msgTempVariable : msgTempVariables) {
                DynamicObjectCollection msgchannel = msgTempVariable.getDynamicObjectCollection("msgchannel");
                DynamicObject dynamicObject = msgchannel.addNew();
                dynamicObject.set("fbasedataid", (Object)msgChannelId);
            }
            CfgMsgTemplateHelper.save((DynamicObject[])msgTempVariables);
        }
        List<Map<String, String>> msgTempVariablesList = Arrays.stream(msgTempVariables).map(varx -> this.constructLabelMap((DynamicObject)varx, msgChannelCategory + "_")).collect(Collectors.toList());
        return msgTempVariablesList;
    }

    public Map<String, String> constructLabelMap(DynamicObject dynamicObject, String variablesPrefix) {
        HashMap labelMap = Maps.newHashMap();
        labelMap.put("id", variablesPrefix + dynamicObject.getString("fieldname"));
        labelMap.put("name", dynamicObject.getString("name"));
        return labelMap;
    }

    private void loadTabItems(Map<String, Object> customParams, String msgChannelCategory) {
        if ("email".equals(msgChannelCategory)) {
            this.getModel().setValue("emailtheme", customParams.get("emailtheme"));
            this.getView().updateView("emailtheme");
            String emailRichText = null == customParams.get("emailrichtext") ? null : customParams.get("emailrichtext").toString();
            logger.info("TscMsgTempTabEdit.loadTabItems.emailRichText\uff1a{}", (Object)emailRichText);
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl("emailrichtext");
            richTextEditor.setText(emailRichText);
            this.getView().updateView("emailrichtext");
        } else {
            this.getModel().setValue("smstemplate", customParams.get("smstemplate"));
            this.getView().updateView("smstemplate");
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if (!HRStringUtils.isEmpty((String)key) && key.startsWith("label")) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            args.setControl((Control)vector);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        Long msgSceneTypeId = Long.valueOf(this.getView().getPageCache().get("msgSceneType"));
        if (control.getKey().startsWith("label") && control.getKey().contains("_")) {
            String[] splitString = control.getKey().split("_");
            DynamicObject[] dynamicObjects = CfgMsgTemplateHelper.queryVariablesNameByField((String)splitString[1], (Long)msgSceneTypeId);
            String category = this.getView().getPageCache().get("category");
            if ("email".equals(category)) {
                this.setRichTextClickLabel(dynamicObjects[0].getString("name"));
            } else {
                this.setMultiTextClickLabel(dynamicObjects[0].getString("name"), "smstemplate");
            }
        }
    }

    private void setRichTextClickLabel(String variateName) {
        String variableValue = "{" + variateName + "}";
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod("emailrichtext", "insertText", new Object[]{variableValue});
    }

    private void setMultiTextClickLabel(String variateName, String multiTextEdit) {
        String variableValue = "{" + variateName + "}";
        String value = (String)this.getModel().getValue(multiTextEdit);
        this.getModel().setValue(multiTextEdit, (Object)(value + variableValue));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        this.emailThemeChange(propertyName);
    }

    private void emailThemeChange(String propertyName) {
        if ("emailtheme".equals(propertyName)) {
            this.getModel().setValue("emailtheme", (Object)SecurityUtils.htmlEncode((String)this.getModel().getValue("emailtheme").toString()));
        }
    }

    public void inputFocus(FireFocusEvent fireFocusEvent) {
        if (fireFocusEvent.getSource() instanceof RichTextEditor) {
            RichTextEditor richTextEditor = (RichTextEditor)fireFocusEvent.getSource();
            this.getModel().setValue("richcontent_tag", (Object)richTextEditor.getText());
        }
    }
}

