/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.webapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.business.domain.process.eip.EipProcessService;
import kd.tsc.tsrsc.webapi.res.SendSysMsgsParam;

@ApiController(value="sys", desc="\u7cfb\u7edf\u6d88\u606f\u901a\u77e5")
public class InvokeSysMsController
implements Serializable {
    private static final long serialVersionUID = 8819235141451920565L;
    private static final String PROCESS_NUMBER = "tsrsc_mk_getApplications";
    private static final Log logger = LogFactory.getLog(InvokeSysMsController.class);

    @ApiPostMapping(value="/sendSysMsg", desc="\u7cfb\u7edf\u6d88\u606f\u901a\u77e5")
    public CustomApiResult<String> sendSysMsg(@ApiRequestBody(value="\u5165\u53c2") SendSysMsgsParam sendSysMsgsParam) {
        OperationResult result;
        logger.info("sendSysMsg begin");
        if (sendSysMsgsParam == null) {
            return CustomApiResult.fail((String)"tsrsc_0001", (String)ResManager.loadKDString((String)"API\u53c2\u6570\u65e0\u6548,\u8be6\u7ec6\u89c1API\u6587\u6863", (String)"ERRORCODE_0001", (String)"tsc-tsrsc-webapi", (Object[])new Object[0]));
        }
        String sys = sendSysMsgsParam.getSys();
        String tenantId = sendSysMsgsParam.getTenantId();
        String[] applyIds = sendSysMsgsParam.getApplyIds();
        String operName = sendSysMsgsParam.getOperName();
        String processNumber = sendSysMsgsParam.getProcessNumber();
        if (HRStringUtils.isEmpty((String)processNumber)) {
            processNumber = "tsrsc_mk_scenematch";
        }
        if (HRObjectUtils.isEmpty((Object)tenantId) || HRObjectUtils.isEmpty((Object)sys) || applyIds == null || applyIds.length == 0) {
            return CustomApiResult.fail((String)"tsrsc_0001", (String)ResManager.loadKDString((String)"API\u53c2\u6570\u65e0\u6548,\u8be6\u7ec6\u89c1API\u6587\u6863", (String)"ERRORCODE_0001", (String)"tsc-tsrsc-webapi", (Object[])new Object[0]));
        }
        if (applyIds.length > 1000) {
            return CustomApiResult.fail((String)"tsrsc_0002", (String)ResManager.loadKDString((String)"\u7533\u8bf7\u4ebaID\u6570\u91cf\u8d85\u8fc71000\u6761", (String)"ERRORCODE_0002", (String)"tsc-tsrsc-webapi", (Object[])new Object[0]));
        }
        if (!"MK".equals(sys)) {
            return CustomApiResult.fail((String)"tsrsc_0004", (String)ResManager.loadKDString((String)"\u65e0\u6548\u7684\u751f\u6001\u7cfb\u7edf\u6807\u8bc6", (String)"ERRORCODE_0004", (String)"tsc-tsrsc-webapi", (Object[])new Object[0]));
        }
        if ("MK".equals(sys) && HRObjectUtils.isEmpty((Object)operName)) {
            return CustomApiResult.fail((String)"tsrsc_0005", (String)ResManager.loadKDString((String)"Moka EHR\u64cd\u4f5c\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ERRORCODE_0005", (String)"tsc-tsrsc-webapi", (Object[])new Object[0]));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        DynamicObject[] partnerTenant = serviceHelper.query("apikey", new QFilter[]{new QFilter("tpdatanum", "=", (Object)sys), new QFilter("partner", "=", (Object)"Moka"), new QFilter("serviceprgnum", "=", (Object)processNumber)});
        if (0 == partnerTenant.length) {
            return CustomApiResult.fail((String)"tsrsc_0001", (String)ResManager.loadKDString((String)"API\u53c2\u6570\u65e0\u6548,\u8be6\u7ec6\u89c1API\u6587\u6863", (String)"ERRORCODE_0001", (String)"tsc-tsrsc-webapi", (Object[])new Object[0]));
        }
        DynamicObject atsMsg = BusinessDataServiceHelper.newDynamicObject((String)"tsrsc_atsmsgrecord");
        atsMsg.set("tpdataid", (Object)applyIds[0]);
        atsMsg.set("msgstatus", (Object)"A");
        atsMsg.set("tptenantid", (Object)partnerTenant[0].getString("apikey"));
        atsMsg.set("msgpushway", (Object)"A");
        atsMsg.set("tpsys", (Object)sys);
        atsMsg.set("createtime", (Object)new Date());
        atsMsg.set("enable", (Object)"1");
        atsMsg.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"tsrsc_atsmsgrecord", (DynamicObject)atsMsg, null));
        if ("MK".equals(sys)) {
            this.mokaSpecialDeal(sendSysMsgsParam, atsMsg);
        }
        if ((result = OperationServiceHelper.executeOperate((String)"save", (String)"tsrsc_atsmsgrecord", (DynamicObject[])new DynamicObject[]{atsMsg}, (OperateOption)OperateOption.create())).isSuccess()) {
            List<Object> params = Arrays.asList(null, applyIds, null, tenantId, "A", result.getSuccessPkIds().get(0));
            EipProcessService.asynStart((String)PROCESS_NUMBER, params);
            return CustomApiResult.success((Object)result.getSuccessPkIds().get(0).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        List operateInfos = result.getAllErrorOrValidateInfo();
        for (int index = 0; index < operateInfos.size(); ++index) {
            stringBuilder.append(((IOperateInfo)operateInfos.get(index)).getMessage());
            if (index == operateInfos.size() - 1) continue;
            stringBuilder.append("&");
        }
        return CustomApiResult.fail((String)"tsrsc_0006", (String)stringBuilder.toString());
    }

    private void mokaSpecialDeal(SendSysMsgsParam sendSysMsgsParam, DynamicObject atsMsg) {
        String name = sendSysMsgsParam.getOperName();
        atsMsg.set("operatorname", (Object)name);
        if (!HRObjectUtils.isEmpty((Object)sendSysMsgsParam.getOperNumber())) {
            atsMsg.set("operatornumber", (Object)sendSysMsgsParam.getOperNumber());
        }
    }
}

