/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.business.domain.appfile.service.header;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dtx.util.DynamicObjectSerializeUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tspr.business.domain.appfile.service.AppFileQACheckHelper;
import kd.tsc.tspr.common.constants.appfile.AppFileStatusEnum;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.headtemplate.AbstractHeaderService;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeService;
import org.apache.commons.lang3.StringUtils;

public class AppFileHeaderService
extends AbstractHeaderService {
    private static final Map<String, String> APP_FILE_STATUS_BC = Maps.newHashMapWithExpectedSize((int)2);
    private static final String PAGE_LOCKINFOVIEW = "tspr_appfileflowlockinfo";
    private static final long serialVersionUID = -9069089998736724202L;

    public List<String> getHideItemList(IFormView view) {
        HRBaseServiceHelper appFileHelper;
        DynamicObject appFile;
        String appFileStatus;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        list.add("flexpanelap73");
        list.add("flexpanelap10");
        list.add("labelap51");
        list.add("flexpanelap26");
        list.add("labelap5");
        list.add("flexpanelap25");
        list.add("flexpanelap12");
        list.add("flexpanelap10");
        list.add("flexpanelap9");
        list.add("flexpanelap11");
        list.add("labelap6");
        list.add("flexpanelap7");
        list.add("flexpanelap13");
        boolean hide = false;
        Object pkId = view.getFormShowParameter().getCustomParam("id");
        if (null != pkId && "B,C,E,F".contains(appFileStatus = (appFile = (appFileHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile")).queryOne(pkId)).getString("filestatus"))) {
            hide = true;
        }
        this.setPhotoHide(view, hide);
        return list;
    }

    public List<String> getClickListeners() {
        return Lists.newArrayList((Object[])new String[]{"flexpanelap7", "labelap", "vectorap", "vectorap7", "blacklisticon", "vectorap11", "labelap11", "flexpanelap13", "vectorap6", "flexpanelap71", "labelap1", "vectorap1", "vectorap2", "labelap2", "labelap111", "vectorap112", "applypositionflex"});
    }

    public List<String> getItemClickListeners() {
        return null;
    }

    public void initData(IFormView view) {
        IDataModel model = view.getModel();
        view.setVisible(Boolean.TRUE, new String[]{"vectorap431", "flexpanelap221", "labelap511", "flexpanelap261"});
        FormShowParameter parameter = view.getFormShowParameter();
        Object pkId = parameter.getCustomParam("id");
        if (null != pkId) {
            HRBaseServiceHelper appFileHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile");
            DynamicObject appFile = appFileHelper.queryOne(pkId);
            String appFileStatus = appFile.getString("filestatus");
            if (AppFileStatusEnum.getEnum((String)appFileStatus) != null) {
                model.setValue("filestatus", (Object)AppFileStatusEnum.getEnum((String)appFileStatus).getText().loadKDString());
            }
            String backAndForeColor = APP_FILE_STATUS_BC.get(appFileStatus);
            String[] split = backAndForeColor.split(",");
            HashMap ctrl = Maps.newHashMapWithExpectedSize((int)2);
            ctrl.put("bc", split[0]);
            view.updateControlMetadata("flexpanelap14", (Map)ctrl);
            HashMap foreColorMap = Maps.newHashMapWithExpectedSize((int)2);
            foreColorMap.put("fc", split[1]);
            view.updateControlMetadata("filestatus", (Map)foreColorMap);
            model.setValue("fullname", (Object)appFile.getString("name"));
            model.setValue("number", (Object)appFile.getString("number"));
            DynamicObject resume = appFile.getDynamicObject("appres");
            if (!HRObjectUtils.isEmpty((Object)resume)) {
                this.setPhoto(view, resume.getString("photo"));
            }
            if (!HRObjectUtils.isEmpty((Object)resume)) {
                DynamicObject gender = resume.getDynamicObject("gender");
                model.setValue("gender", (Object)gender);
            }
            if (!HRObjectUtils.isEmpty((Object)resume)) {
                int workYearsNum = resume.getInt("workingyears");
                String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workYearsNum);
                model.setValue("workexp", (Object)workYearShow);
            }
            model.setValue("highestedu", (Object)appFile.getString("highesteducation.name"));
            if (!HRObjectUtils.isEmpty((Object)resume)) {
                String recentPosition = resume.getString("recentposition");
                model.setValue("recentposition", (Object)recentPosition);
            }
            if (!HRObjectUtils.isEmpty((Object)resume)) {
                String recentCompany = resume.getString("recentcompany");
                model.setValue("recentcompany", (Object)recentCompany);
                if (recentCompany == null) {
                    view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap32"});
                }
            }
            model.setValue("phone", (Object)appFile.getString("phone"));
            model.setValue("email", (Object)appFile.getString("email"));
            DynamicObject position = appFile.getDynamicObject("position");
            if (Objects.nonNull(position)) {
                view.getPageCache().put("applyposition", position.getString("id"));
                Label applyPositionLabel = (Label)view.getControl("applyposition");
                applyPositionLabel.setText(position.getString("name"));
            }
            String recrutyp = appFile.getString("recrutyp.name");
            model.setValue("dlychanneltype", (Object)recrutyp);
            if (recrutyp == null) {
                view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap28"});
            }
            if (!HRObjectUtils.isEmpty((Object)resume)) {
                this.setDeliveryInfo(model, resume.getLong("id"));
            }
            this.setStdRsmInfo(view, appFile.getLong("stdrsm.id"));
            view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap72"});
            view.setVisible(Boolean.valueOf(false), new String[]{"flexpanelap711", "flexpanelap7111"});
        }
    }

    public void click(IFormView view, String key) {
        FormShowParameter parameter = view.getFormShowParameter();
        Object pkId = parameter.getCustomParam("id");
        DynamicObject appFile = AppFileHelper.queryOne((long)Long.parseLong(pkId.toString()));
        long stdRsmId = appFile.getLong("stdrsm.id");
        if (key.equals("vectorap7")) {
            this.showRepeatDeliveryPage(view, appFile);
        } else if (key.equals("vectorap6")) {
            this.showStdRsmPage(view, stdRsmId);
        } else if (StringUtils.equals((CharSequence)"labelap", (CharSequence)key) || StringUtils.equals((CharSequence)"vectorap", (CharSequence)key)) {
            this.openSuspectedPage(view, stdRsmId);
        } else if (StringUtils.equals((CharSequence)"vectorap1", (CharSequence)key) || StringUtils.equals((CharSequence)"labelap1", (CharSequence)key)) {
            this.openBlacklistInfoPage(view, stdRsmId);
        } else if (StringUtils.equals((CharSequence)"vectorap11", (CharSequence)key) || StringUtils.equals((CharSequence)"labelap11", (CharSequence)key) || "labelap111".equals(key) || "vectorap112".equals(key)) {
            DynamicObject flowLockInfo = AppFileFlowLockHelper.getFlowLockInfo((Long)stdRsmId);
            if (flowLockInfo != null) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(PAGE_LOCKINFOVIEW);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("data", (Object)DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{flowLockInfo}, (DynamicObjectType)flowLockInfo.getDynamicObjectType()));
                view.showForm(showParameter);
            } else {
                view.showTipNotification(TSCBaseKDString.dataChangedTip());
            }
        } else if (StringUtils.equals((CharSequence)"flexpanelap13", (CharSequence)key)) {
            this.showProccessPage(view);
        } else if (StringUtils.equals((CharSequence)"labelap2", (CharSequence)key) || StringUtils.equals((CharSequence)"vectorap2", (CharSequence)key)) {
            AppFileQACheckHelper.showQACheckInfoPop((IFormView)view, (DynamicObject)appFile, (String)view.getParentView().getPageCache().get("qacheckresult"));
        }
    }

    private void showProccessPage(IFormView formView) {
        FormShowParameter parentParameter = formView.getParentView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        if ("tsivp_intvevaltask".equals(parentParameter.getFormId())) {
            showParameter.setCustomParam("appFileId", parentParameter.getCustomParam("appFileId"));
        } else {
            IDataModel model = formView.getParentView().getModel();
            showParameter.setCustomParam("appFileId", model.getValue("id"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("tsrsc_appfileproc");
        formView.showForm(showParameter);
    }

    public void savePhoto(Object objId, String url) {
        HRBaseServiceHelper appFileHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile");
        DynamicObject appFile = appFileHelper.queryOne(objId);
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srrsm");
        long rsmId = appFile.getLong("appres.id");
        this.logger.info("AppFileHeadEdit.afterUpload.setPicToAppRes.rsmId:{}", (Object)rsmId);
        DynamicObject appRes = serviceHelper.loadSingle((Object)rsmId);
        if (!HRStringUtils.isEmpty((String)url) && appRes != null) {
            appRes.set("photo", (Object)url);
            serviceHelper.updateOne(appRes);
            AppResumeBo appResumeBo = new AppResumeBo(appRes);
            ResumeBoHelper.loadAllListData((AppResumeBo)appResumeBo);
            AddResumeService.diffUpdateStandResume((Long)appRes.getLong("stdrsm"), (AppResumeBo)appResumeBo);
        }
    }

    private void showRepeatDeliveryPage(IFormView view, DynamicObject dataEntity) {
        FormShowParameter showParameter = new FormShowParameter();
        int repeatDeliveryCount = AppFileHelper.queryRepeatDeliveryCount((Long)dataEntity.getLong("id"));
        showParameter.setPageId(view.getPageId() + "repeatdelnum" + repeatDeliveryCount);
        showParameter.setFormId("tstpm_rdeliverylist");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("id", (Object)dataEntity.getLong("id"));
        showParameter.setCustomParam("number", (Object)dataEntity.getString("number"));
        showParameter.setCustomParam("fullname", (Object)dataEntity.getString("name"));
        DynamicObject position = dataEntity.getDynamicObject("position");
        if (position != null) {
            showParameter.setCustomParam("recruposi", (Object)position.getLong("id"));
        }
        showParameter.setCustomParam("repeatdelnum", (Object)repeatDeliveryCount);
        view.showForm(showParameter);
    }

    private void showStdRsmPage(IFormView view, long stdRsmId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tstpm_candidate_detail");
        parameter.setCustomParam("id", (Object)stdRsmId);
        parameter.setCustomParam("type", (Object)"1");
        parameter.setCustomParam("bizappid", (Object)"tsrsc");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(parameter);
    }

    static {
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.IN_PROCESS.getValue(), "#276FF5,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.TBEMP.getValue(), "#276FF5,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.OUT.getValue(), "#666666,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.INVALID.getValue(), "#999999,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.EMPED.getValue(), "#1BA854,#FFFFFF");
        APP_FILE_STATUS_BC.put(AppFileStatusEnum.ENDEMP.getValue(), "#666666,#FFFFFF");
    }
}

