/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.business.domain.arf.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tspr.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.enums.ThirdPartSystemEnum;
import kd.tsc.tstpm.business.domain.rsm.arf.ARFAttachmentHelper;
import kd.tsc.tstpm.business.domain.rsm.common.entity.AppArfBo;

@Deprecated
public class SyncHcfHelper {
    private static final Log logger = LogFactory.getLog(SyncHcfHelper.class);
    public static final String DESCRIPTION = "description";
    public static final String CUSTOMFILENAME = "customfilename";
    public static final String ARF = "arf";
    private static String[] SUBPAGES = new String[]{"tstpm_arfcertificates", "tstpm_arfrsmawrhon", "tstpm_arfrsmeduexp", "tstpm_arfrsminterexp", "tstpm_arfrsmlangabl", "tstpm_arfrsmprjexp", "tstpm_arfrsmworkexp"};

    public static boolean updateArfToCandidate(Long appfileId, Boolean isAdd) {
        DynamicObject appFile = AppFileHelper.queryOne((long)appfileId, (String)"arfrsm, number, name");
        DynamicObject candidate = (DynamicObject)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateByNumberAppFileId", (Object[])new Object[]{appFile.getString("number"), appfileId});
        if (!isAdd.booleanValue() && candidate == null) {
            return false;
        }
        long arfId = appFile.getLong("arfrsm.id");
        Map<String, Object> candidateSyncMap = SyncHcfHelper.generateCandidateSyncVO(appFile, arfId);
        if (candidateSyncMap == null) {
            return false;
        }
        HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"saveOrUpdateCandidate", (Object[])new Object[]{candidateSyncMap});
        SyncHcfHelper.updateArfAttachmentToHcf(appfileId, isAdd);
        return true;
    }

    public static void updateArfAttachmentToHcf(Long appfileId, Boolean isAdd) {
        DynamicObject candidate = (DynamicObject)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCandidateByNumberAppFileId", (Object[])new Object[]{null, appfileId});
        if (!isAdd.booleanValue() && candidate == null) {
            return;
        }
        DynamicObject[] arfAttachs = ARFAttachmentHelper.getInstance().getArfAttachmentInfoByAppfileId(appfileId);
        logger.info("get arfAttachs success {}", (Object)arfAttachs);
        if (arfAttachs == null) {
            return;
        }
        List offerAttachs = (List)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tso", (String)"attachmentServiceApi", (String)"getOfferAttachmentList", (Object[])new Object[]{appfileId, 1000});
        logger.info("get offerAttachs success {}", (Object)offerAttachs);
        List<Object> attachs = new ArrayList();
        if (offerAttachs != null) {
            for (DynamicObject dynamicObject : arfAttachs) {
                boolean flag = false;
                for (Map offerAttach : offerAttachs) {
                    logger.info("get descAttachs success {}/{}", offerAttach.get(DESCRIPTION), (Object)dynamicObject.getString(CUSTOMFILENAME));
                    if (!HRStringUtils.equals((String)String.valueOf(offerAttach.get(DESCRIPTION)), (String)dynamicObject.getString(CUSTOMFILENAME))) continue;
                    flag = true;
                }
                if (flag) continue;
                attachs.add(dynamicObject);
            }
        } else {
            attachs = Arrays.asList((Object[])arfAttachs.clone());
        }
        Long candidateId = candidate.getLong("id");
        DynamicObject baseInfoDyn = (DynamicObject)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"getCurrentCanBaseInfoByCandidateId", (Object[])new Object[]{candidateId});
        AttachmentServiceHelper.remove((String)"hcf_canbaseinfo", (Object)baseInfoDyn.getPkValue());
        for (DynamicObject dynamicObject : attachs) {
            HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hcf", (String)"IHCFService", (String)"uploadAttachment", (Object[])new Object[]{Long.parseLong(baseInfoDyn.getPkValue().toString()), dynamicObject});
        }
    }

    private static Map<String, Object> generateCandidateSyncVO(DynamicObject appFile, Long arfId) {
        AppArfBo appArfBo = SyncHcfHelper.getAppArfBo(arfId);
        logger.info("generateCandidateSyncVO appArfBo is");
        if (appArfBo == null) {
            return null;
        }
        SyncHcfHelper.loadAllListData(appArfBo);
        DynamicObjectCollection dynColl = new DynamicObjectCollection();
        dynColl.add((Object)appArfBo.getRsm());
        Map dyoCollMap = appArfBo.getDyoCollMap();
        List collect = dyoCollMap.values().stream().collect(Collectors.toList());
        collect.add(dynColl);
        Long appFileId = appFile.getLong("id");
        String number = appFile.getString("number");
        String name = appFile.getString("name");
        HashMap<String, Object> candidateSyncMap = new HashMap<String, Object>(16);
        candidateSyncMap.put("apply", ARF);
        candidateSyncMap.put("name", name);
        candidateSyncMap.put("number", number);
        candidateSyncMap.put("billNo", number);
        candidateSyncMap.put("dynCollList", collect);
        candidateSyncMap.put("appFileId", appFileId);
        logger.info("generateCandidateSyncVO candidateSyncVo is");
        return candidateSyncMap;
    }

    public static AppArfBo getAppArfBo(Long arfId) {
        DynamicObject arfDt = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_arfrsm").queryOne((Object)arfId);
        if (arfDt != null) {
            return new AppArfBo(arfDt);
        }
        return null;
    }

    public static void loadAllListData(AppArfBo appArfBo) {
        DynamicObject[] arfPages;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrbd_mtdobjtable");
        QFilter qFilter = new QFilter("formtype", "=", (Object)"7");
        qFilter.and("recrutyp", "=", (Object)1020L);
        qFilter.and("ecosystem", "=", (Object)ThirdPartSystemEnum.MK.getTpSys());
        qFilter.and("ismainentity", "=", (Object)false);
        for (DynamicObject subpage : arfPages = serviceHelper.query("entitykey", qFilter.toArray())) {
            appArfBo.setEntry(subpage.getString("entitykey"), SyncHcfHelper.getRsmList(appArfBo, subpage.getString("entitykey")));
        }
        logger.info("get arfListData success {} {}", (Object)arfPages, (Object)appArfBo);
    }

    public static DynamicObjectCollection getRsmList(AppArfBo appArfBo, String pageNum) {
        DynamicObject rsm = appArfBo.getRsm();
        if (rsm == null || rsm.getLong("id") == 0L || !rsm.getDataEntityState().getFromDatabase()) {
            return new DynamicObjectCollection();
        }
        long rsmId = rsm.getLong("id");
        QFilter qFilter = new QFilter("rsm", "=", (Object)rsmId);
        DynamicObject[] eduExps = ServiceHelperCache.getHrBaseServiceHelper((String)pageNum).loadDynamicObjectArray(pageNum, qFilter.toArray());
        DynamicObjectCollection eduExpList = new DynamicObjectCollection();
        eduExpList.addAll(Arrays.asList(eduExps));
        return eduExpList;
    }
}

