/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.business.domain.datasync;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.enums.ThirdPartSystemEnum;
import kd.tsc.tsrsc.common.enums.TSRSCSyncBoTypeEnum;

public class DataSyncRecordHelper {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("tsrsc_datasyncrecord");

    public static void recordDataSyncOperate(TSRSCSyncBoTypeEnum botype, Date lastSynTime, ThirdPartSystemEnum tpsys) {
        DynamicObject record = DataSyncRecordHelper.getDataSyncRecord(botype, tpsys);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        if (record == null) {
            record = SERVICE_HELPER.generateEmptyDynamicObject();
            record.set("botype", (Object)botype.getBoType());
            record.set("tpsys", (Object)tpsys.getTpSys());
            record.set("creator", (Object)currUserId);
            record.set("createtime", (Object)date);
            record.set("modifier", (Object)currUserId);
            record.set("modifytime", (Object)date);
        }
        record.set("lastsyntime", (Object)lastSynTime);
        record.set("modifier", (Object)currUserId);
        record.set("modifytime", (Object)date);
        SERVICE_HELPER.saveOne(record);
    }

    public static DynamicObject getDataSyncRecord(TSRSCSyncBoTypeEnum botype, ThirdPartSystemEnum tpsys) {
        QFilter botypeFilter = new QFilter("botype", "=", (Object)botype.getBoType());
        QFilter tpsysFilter = new QFilter("tpsys", "=", (Object)tpsys.getTpSys());
        return SERVICE_HELPER.loadDynamicObject(new QFilter[]{botypeFilter, tpsysFilter});
    }
}

