/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.business.domain.synconfig;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.business.domain.synrecord.SynRecordService;

public class SynConfigService {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tsrbs_bindextternalorg");

    public static boolean isHaveARootNode(Long id) {
        DynamicObject result = HELPER.loadDynamicObject(new QFilter("partnertenant", "=", (Object)String.valueOf(id)));
        return null != result;
    }

    public static Long getAdminOrgIdByTenantId(Long id) {
        DynamicObject result = HELPER.loadDynamicObject(new QFilter("partnertenant", "=", (Object)String.valueOf(id)));
        DynamicObject oreignadminorg = result.getDynamicObject("oreignadminorg");
        return oreignadminorg.getLong("id");
    }

    public static DynamicObject getTenantById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        return serviceHelper.loadDynamicObject(new QFilter("id", "=", (Object)id));
    }

    public static void saveTenant(Long tenantId, Long adminOrgId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsrbs_bindextternalorg");
        dynamicObject.set("partnertenant", (Object)String.valueOf(tenantId));
        dynamicObject.set("oreignadminorg", (Object)adminOrgId);
        dynamicObject.set("synchstatus", (Object)"1");
        dynamicObject.set("enable", (Object)"1");
        HELPER.saveOne(dynamicObject);
    }

    public static FormShowParameter getSynedPopForm(Long pkId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tsrbs_synadminorg_view");
        formShowParameter.setCustomParam("tenantId", (Object)pkId);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)SynConfigService.getAdminOrgIdByTenantId(pkId));
        DynamicObject tenant = SynConfigService.getTenantById(pkId);
        formShowParameter.setCustomParam("partner", (Object)tenant.getString("partner"));
        formShowParameter.setCustomParam("hrorgfield", (Object)tenant.getDynamicObject("hrorgfield").getString("name"));
        return formShowParameter;
    }

    public static String getTenantStatusById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        DynamicObject result = serviceHelper.queryOne("enable", new QFilter("id", "=", (Object)id));
        return result.getString("enable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bindRootNode(Long pkId, DynamicObject adminOrg) {
        try (TXHandle tx = TX.required();){
            SynConfigService.saveTenant(pkId, adminOrg.getLong("id"));
            SynRecordService.saveSynRecordObjWithNewOp((DynamicObject)adminOrg, (Long)pkId);
        }
    }
}

