/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.business.domain.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tsrbs.common.enums.DeleteEnum;

public class AppfileOfferDataHandleTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AppfileOfferDataHandleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean flag = true;
        try {
            HRBaseServiceHelper appfileServiceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
            QFilter offerQfilter = new QFilter("offer.id", "=", (Object)0L).or(new QFilter("offer.id", "is null", null));
            Object[] appfileDys = appfileServiceHelper.query("id,offer.id,offerletter.id", new QFilter[]{offerQfilter});
            if (HRArrayUtils.isNotEmpty((Object[])appfileDys)) {
                HRBaseServiceHelper offerServiceHelper = new HRBaseServiceHelper("tso_somk_offerbase");
                ArrayList<Long> statusIds = new ArrayList<Long>(4);
                statusIds.add(OfferStatus.PRE_APPLY.getCode());
                statusIds.add(OfferStatus.APPLYING.getCode());
                statusIds.add(OfferStatus.APPLY_PASS.getCode());
                statusIds.add(OfferStatus.APPLY_TERM.getCode());
                statusIds.add(OfferStatus.ALR_DISCARD.getCode());
                QFilter offerStatusQfilter = new QFilter("status.id", "in", statusIds);
                List appfileIds = Arrays.stream(appfileDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                QFilter appfileIdsQfilter = new QFilter("appfile.id", "in", appfileIds);
                QFilter deleteQfilter = new QFilter("isdelete", "=", (Object)DeleteEnum.NO_DELETE.getCode());
                Object[] offerDys = offerServiceHelper.query("id,status.id,appfile.id,offerletter.id,isdelete", new QFilter[]{offerStatusQfilter, appfileIdsQfilter, deleteQfilter});
                if (HRArrayUtils.isNotEmpty((Object[])offerDys)) {
                    DynamicObjectCollection appfileCol = new DynamicObjectCollection();
                    Arrays.stream(appfileDys).forEach(arg_0 -> AppfileOfferDataHandleTask.lambda$execute$4((DynamicObject[])offerDys, appfileCol, arg_0));
                    if (appfileCol.size() > 0) {
                        appfileServiceHelper.update((DynamicObject[])appfileCol.toArray((Object[])new DynamicObject[0]));
                    }
                }
                QFilter inducQfilter = new QFilter("inductioninfo.id", "=", (Object)0L).or(new QFilter("inductioninfo.id", "is null", null));
                Object[] appfileToInducDys = appfileServiceHelper.query("id,inductioninfo.id", new QFilter[]{inducQfilter});
                if (HRArrayUtils.isEmpty((Object[])appfileToInducDys)) {
                    return;
                }
                HRBaseServiceHelper inducServiceHelper = new HRBaseServiceHelper("tso_inductioninfo");
                QFilter inducToAppfileQfilter = new QFilter("appfile.id", "in", Arrays.stream(appfileToInducDys).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
                Object[] inducDys = inducServiceHelper.query("id,appfile.id", new QFilter[]{inducToAppfileQfilter});
                if (HRArrayUtils.isEmpty((Object[])inducDys)) {
                    return;
                }
                Map<Long, Long> inducIdToAppfileIdMaps = Arrays.stream(inducDys).collect(Collectors.toMap(dy -> dy.getLong("appfile.id"), dy -> dy.getLong("id")));
                DynamicObjectCollection newAppfileCol = new DynamicObjectCollection();
                Arrays.stream(appfileToInducDys).forEach(appfileToInducDy -> {
                    Long inducId = (Long)inducIdToAppfileIdMaps.get(appfileToInducDy.getLong("id"));
                    appfileToInducDy.set("inductioninfo", (Object)inducId);
                    newAppfileCol.add(appfileToInducDy);
                });
                if (newAppfileCol.size() > 0) {
                    appfileServiceHelper.update((DynamicObject[])newAppfileCol.toArray((Object[])new DynamicObject[0]));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("AppfileOfferDataHandleTask exception:", (Throwable)exception);
            flag = false;
        }
        if (flag) {
            ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
            service.disableJob(taskInfo.getJobId());
            service.disableSchedule(taskInfo.getScheduleId());
        }
    }

    private static /* synthetic */ void lambda$execute$4(DynamicObject[] offerDys, DynamicObjectCollection appfileCol, DynamicObject appfileDy) {
        List effectOfferDys = Arrays.stream(offerDys).filter(dy -> dy.getLong("appfile.id") == appfileDy.getLong("id") && dy.getLong("status.id") != OfferStatus.ALR_DISCARD.getCode().longValue()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(effectOfferDys)) {
            appfileDy.set("offer", ((DynamicObject)effectOfferDys.get(0)).get("id"));
            appfileDy.set("offerletter", ((DynamicObject)effectOfferDys.get(0)).get("offerletter.id"));
            appfileCol.add((Object)appfileDy);
        } else {
            List discardOfferDys = Arrays.stream(offerDys).filter(dy -> dy.getLong("appfile.id") == appfileDy.getLong("id") && dy.getLong("status.id") == OfferStatus.ALR_DISCARD.getCode().longValue()).sorted(Comparator.comparingLong(dy -> dy.getLong("id"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(discardOfferDys)) {
                appfileDy.set("offer", ((DynamicObject)discardOfferDys.get(discardOfferDys.size() - 1)).get("id"));
                appfileDy.set("offerletter", ((DynamicObject)discardOfferDys.get(discardOfferDys.size() - 1)).get("offerletter.id"));
                appfileCol.add((Object)appfileDy);
            }
        }
    }
}

