/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.business.domain.task;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.api.ShardingParam;
import kd.bos.schedule.api.ShardingTask;
import kd.bos.schedule.api.StopTask;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.common.utils.PermissionServiceUtils;
import kd.tsc.tsrsc.business.domain.task.AtsMsgTaskService;

public class AtsMsgTask
extends AbstractTask
implements ShardingTask,
StopTask {
    private static final Log LOG = LogFactory.getLog(AtsMsgTask.class);
    private final AtsMsgTaskService msgTaskService = AtsMsgTaskService.Singleton.INSTANCE.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map, ShardingParam shardingParam) throws KDException {
        LOG.info("AtsMsgTask.execute start...");
        Object sysType = map.get("sysType");
        if (sysType == null) {
            LOG.info("sysType is null...");
            return;
        }
        String value = shardingParam.getValue();
        LOG.info("AtsMsgTask.execute param [sysType={},value={}]", sysType, (Object)value);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_partner_tenant");
        DynamicObject result = serviceHelper.queryOne("createtime,apikey,serviceprgnum", new QFilter[]{new QFilter("number", "=", (Object)value)});
        String tenantId = "";
        if (!HRObjectUtils.isEmpty((Object)result)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, 2024);
            calendar.set(2, 8);
            calendar.set(5, 30);
            Date fixedDate = calendar.getTime();
            Date createTime = result.getDate("createtime");
            tenantId = createTime.compareTo(fixedDate) > 0 ? PermissionServiceUtils.decryptData((String)result.getString("apikey")) : result.getString("apikey");
        } else {
            tenantId = value;
        }
        Object processNumber = map.get("processNumber");
        if (processNumber == null || StringUtils.isEmpty((String)processNumber.toString())) {
            processNumber = "tsrsc_mk_scenematch";
        }
        LOG.info("AtsMsgTask.execute param [sysType={},processNumber={},tenantId={}]", new Object[]{sysType, processNumber, tenantId});
        this.msgTaskService.doAtsMsgTask(sysType, tenantId, processNumber);
        LOG.info("AtsMsgTask.execute end...");
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
    }

    public MessageHandler getMessageHandle() {
        return super.getMessageHandle();
    }
}

