/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.business.domain.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.tsc.tso.business.domain.process.eip.EipProcessService;
import kd.tsc.tsrbd.common.utils.PermissionServiceUtils;
import kd.tsc.tsrsc.business.domain.atsmsgrec.ATSMsgRecordHelper;

public class AtsMsgTaskService {
    private static final Log LOG = LogFactory.getLog(AtsMsgTaskService.class);
    private final ATSMsgRecordHelper msgRecordHelper = ATSMsgRecordHelper.getInstance();
    private static final ThreadPool HTREAD_POOL = ThreadPools.newFixedThreadPool((String)"AtsMsg", (int)20, (String)"tsrsc");

    public void doAtsMsgTask(Object sysType, String tenantId, Object processNumber) {
        DynamicObject[] atsMsgObjs = this.getPendingTask(sysType, tenantId);
        LOG.info("AtsMsgTaskService.doAtsMsgTask atsMsgObjs : {}", (Object)atsMsgObjs.length);
        if (atsMsgObjs.length > 0) {
            Map<String, List<DynamicObject>> atsMsgMap = Arrays.stream(atsMsgObjs).collect(Collectors.groupingBy(atsMsg -> atsMsg.getString("tptenantid")));
            for (Map.Entry<String, List<DynamicObject>> entry : atsMsgMap.entrySet()) {
                this.startProcess(entry, processNumber);
            }
        }
    }

    private DynamicObject[] getPendingTask(Object sysType, String tenantId) {
        QFilter qFilter = new QFilter("tpsys", "=", sysType);
        qFilter.and(new QFilter("msgstatus", "=", (Object)"A"));
        qFilter.and(new QFilter("messagetext", "is not null", (Object)""));
        String selectProps = "msgstatus,tptenantid,modifytime";
        DynamicObject[] msgRecord = this.msgRecordHelper.query(selectProps, qFilter.toArray(), "createTime asc");
        LOG.info("msgRecord.length :{}", (Object)msgRecord.length);
        ArrayList collection = Lists.newArrayListWithExpectedSize((int)16);
        if (msgRecord.length > 0) {
            for (DynamicObject dynamic : msgRecord) {
                String tptenantId = dynamic.getString("tptenantid");
                LOG.info("tptenantId:{}, tenantId:{}", (Object)tptenantId, (Object)tenantId);
                if (tenantId.equals(tptenantId)) {
                    collection.add(dynamic);
                    continue;
                }
                if (!tenantId.equals(tptenantId = PermissionServiceUtils.decryptData((String)tptenantId))) continue;
                collection.add(dynamic);
            }
        }
        return collection.toArray(new DynamicObject[0]);
    }

    private void startProcess(Map.Entry<String, List<DynamicObject>> entry, Object processNumber) {
        for (DynamicObject atsMsgObj : entry.getValue()) {
            HTREAD_POOL.execute(() -> {
                EipProcessService.asynStart((String)processNumber.toString(), Arrays.asList(atsMsgObj.getPkValue(), null, processNumber));
                atsMsgObj.set("msgstatus", (Object)"B");
                atsMsgObj.set("modifytime", (Object)new Date());
                this.msgRecordHelper.updateOne(atsMsgObj);
            });
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final AtsMsgTaskService instance = new AtsMsgTaskService();

        public AtsMsgTaskService getInstance() {
            return this.instance;
        }
    }
}

