/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.opplugin.appfile.validator;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class AppFileValidator
extends HRDataBaseValidator {
    private static final String KEY_APPLYOFFER = "applyoffer";
    private static final String KEY_APPLYEMP = "applyemp";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYOFFER)) {
            this.validateOffer(dataEntity);
        } else if (HRStringUtils.equals((String)operateKey, (String)KEY_APPLYEMP)) {
            this.validateApplyEmp(dataEntity);
        } else if (HRStringUtils.equals((String)operateKey, (String)"delete")) {
            this.validateDelete();
        }
    }

    private void validateOffer(ExtendedDataEntity dataEntity) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject dynamicObject = serviceHelper.queryOne((Object)dataEntity.getDataEntity().getLong("id"));
        long offerStatusId = dynamicObject.getLong("offer.status.id");
        if (offerStatusId != 0L && offerStatusId != 1010040L && offerStatusId != 1010050L) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u7684Offer\u6216\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"AppFileValidator_0", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
        } else {
            String inductionStatus = dynamicObject.getString("inductioninfo.inductionstatus");
            if (!HRStringUtils.isEmpty((String)inductionStatus)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u7684Offer\u6216\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"AppFileValidator_0", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateApplyEmp(ExtendedDataEntity dataEntity) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsrsc_appfile_viewmabr");
        DynamicObject dynamicObject = serviceHelper.queryOne((Object)dataEntity.getDataEntity().getLong("id"));
        long offerStatusId = dynamicObject.getLong("offer.status.id");
        long offerLetterStatusId = dynamicObject.getLong("offerletter.datastatus.id");
        long offerReplyStatusId = dynamicObject.getLong("offerletter.replystatus.id");
        String inductionStatus = dynamicObject.getString("inductioninfo.inductionstatus");
        if (!(offerStatusId == 0L && HRStringUtils.isEmpty((String)inductionStatus) || offerLetterStatusId == 1030020L && offerReplyStatusId == 1040030L && HRStringUtils.isEmpty((String)inductionStatus))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5019\u9009\u4ebaOffer\u73af\u8282\u672a\u5b8c\u6210\uff0c\u6216\u5df2\u5b58\u5728\u6709\u6548\u7684\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"AppFileValidator_1", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateDelete() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long offerStatusId = dynamicObject.getLong("offer.status.id");
            String inductionStatus = dynamicObject.getString("inductioninfo.inductionstatus");
            if (offerStatusId != 0L || !HRStringUtils.isEmpty((String)inductionStatus)) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728Offer\u6216\u5165\u804c\u534f\u540c\u5355\u636e\u3002", (String)"AppFileValidator_2", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
            }
        });
    }
}

