/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsrsc.opplugin.home.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.tsc.tsrsc.business.domain.databaselink.DatabaseLinkHelper;

public class TsrscTenantValidator
extends HRCoreBaseBillValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        this.mustInputValidator(dataEntity);
        this.isExistValidator(dataEntity);
        this.isConsistentValidator(dataEntity);
    }

    private void mustInputValidator(ExtendedDataEntity dataEntity) {
        String serviceprgNum;
        String linkConfig;
        String apiKey;
        String tenantName = dataEntity.getValue("name").toString();
        if (HRStringUtils.isEmpty((String)tenantName)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u79df\u6237\u540d\u79f0\u3002", (String)"TsrscTenantValidator_1", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)(apiKey = dataEntity.getValue("apikey").toString()))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165APIKey\u3002", (String)"TsrscTenantValidator_2", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)(linkConfig = dataEntity.getValue("linkconfig").toString()))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8fde\u63a5\u914d\u7f6e\u3002", (String)"TsrscTenantValidator_3", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isEmpty((String)(serviceprgNum = dataEntity.getValue("serviceprgnum").toString()))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u670d\u52a1\u6d41\u7a0b\u7f16\u7801\u3002", (String)"TsrscTenantValidator_4", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
        }
    }

    private void isExistValidator(ExtendedDataEntity dataEntity) {
        String apiKey = dataEntity.getValue("apikey").toString();
        Long pkValue = (Long)dataEntity.getDataEntity().getPkValue();
        if (DatabaseLinkHelper.getInstance().isApiKeyExit(pkValue, apiKey)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"API Key\u503c\u5df2\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u540e\u8f93\u5165\u3002", (String)"TsrscTenantValidator_5", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
        }
    }

    private void isConsistentValidator(ExtendedDataEntity dataEntity) {
        DynamicObject linkConfig;
        String databaseType;
        String partner = dataEntity.getValue("partner").toString();
        if (!HRStringUtils.equalsIgnoreCase((String)partner, (String)(databaseType = (linkConfig = (DynamicObject)dataEntity.getValue("linkconfig")).get("database_type").toString()))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u6001\u4f19\u4f34\u9700\u4e0e\u8fde\u63a5\u914d\u7f6e\u7684\u8fde\u63a5\u7c7b\u578b\u4fdd\u6301\u4e00\u81f4\u3002", (String)"TsrscTenantValidator_7", (String)"tsc-tsrsc-opplugin", (Object[])new Object[0]));
        }
    }
}

