/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.opplugin.web.stdrsm;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tstpm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tstpm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tstpm.business.domain.stdrsm.helper.BlacklistDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.ResumeStatusService;

public class RecycleRecoverOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] entities = this.getDataEntities();
                List list = Arrays.stream(entities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
                DynamicObject[] dys = StdRsmServiceHelper.getStdRsmByDataStatus(list, (ResumeHisDataStatusEnum[])new ResumeHisDataStatusEnum[]{ResumeHisDataStatusEnum.EFFECTING, ResumeHisDataStatusEnum.BLACK_LIST});
                String comMessage = ResManager.loadKDString((String)"\uff1a\u6807\u51c6\u7b80\u5386\u5df2\u6062\u590d\u3002", (String)"RecycleRecoverOp_0", (String)"tsc-tstpm-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity entity : entities) {
                    Arrays.stream(dys).filter(dy -> dy.getLong("id") == ((Long)entity.getBillPkId()).longValue()).findFirst().ifPresent(dy -> {
                        String message = dy.getString("fullname") + dy.getString("number");
                        this.addErrorMessage(entity, message + comMessage);
                    });
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        args.setCancelOperation(true);
        DynamicObject[] entities = args.getDataEntities();
        List idList = Arrays.stream(entities).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        ResumeStatusService service = RsmPrototypeFactory.getResumeStatusService((ModelType)ModelType.MAIN_RSM_DELETE);
        service.setEntryNumber("tstpm_stdrsm");
        service.setDuplicates(new String[]{"tstpm_stdeduexp"});
        List blackListDys = BlacklistDataHelper.getBlackListDys(idList);
        if (!blackListDys.isEmpty()) {
            HashMap blackField = Maps.newHashMapWithExpectedSize((int)1);
            blackField.put("datastatus", ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
            service.batchRecoverResumeStatus(blackListDys, (Map)blackField);
            Sets.SetView difference = Sets.difference(new HashSet(idList), new HashSet(blackListDys));
            if (!difference.isEmpty()) {
                HashMap effectField = Maps.newHashMapWithExpectedSize((int)1);
                effectField.put("datastatus", ResumeHisDataStatusEnum.EFFECTING.getStatus());
                service.batchRecoverResumeStatus(new ArrayList(difference), (Map)effectField);
            }
        } else {
            HashMap effectField = Maps.newHashMapWithExpectedSize((int)1);
            effectField.put("datastatus", ResumeHisDataStatusEnum.EFFECTING.getStatus());
            service.batchRecoverResumeStatus(idList, (Map)effectField);
        }
    }
}

