/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.opplugin.web.talentpool;

import java.util.HashSet;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.validate.AbstractValidator;

public class DeleteTreeValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities != null && this.dataEntities.length > 0) {
            IDataEntityType type = this.dataEntities[0].getDataEntity().getDataEntityType();
            this.deleteValidate((BasedataEntityType)type);
        }
    }

    public void deleteValidate(BasedataEntityType entityType) {
        HashSet<String> failSet = new HashSet<String>();
        BaseDataCheckRefrence check = new BaseDataCheckRefrence();
        String primaryKey = entityType.getPrimaryKey().getName();
        this.quickSortInternally(this.dataEntities, 0, this.dataEntities.length - 1, entityType);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dynamicObject = this.dataEntities[i].getDataEntity();
            String longNumber = dynamicObject.getString("longnumber");
            String parentLongNumber = dynamicObject.getString("parent.longnumber");
            boolean flag = false;
            for (String string : failSet) {
                if (string == null || !string.contains(longNumber)) continue;
                flag = true;
                break;
            }
            if (flag) {
                failSet.add(longNumber);
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5b50\u8282\u70b9\u672a\u80fd\u5220\u9664", (String)"DeleteTreeValidator_0", (String)"tsc-tstpm-opplugin", (Object[])new Object[0]));
                this.dataEntities[i] = null;
                continue;
            }
            this.addIgnoreRefEntityIds(check);
            BaseDataCheckRefrenceResult result = check.checkRef(entityType, dynamicObject.get(primaryKey));
            if (result.getRefenceKey() == null) continue;
            failSet.add(longNumber);
            failSet.add(parentLongNumber);
            this.addMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u5141\u8bb8\u5220\u9664", (String)"DeleteTreeValidator_1", (String)"tsc-tstpm-opplugin", (Object[])new Object[0]));
            this.dataEntities[i] = null;
        }
    }

    public void quickSortInternally(ExtendedDataEntity[] av, int pv, int rv, BasedataEntityType entityType) {
        if (pv >= rv) {
            return;
        }
        int qv = this.partition(av, pv, rv, entityType);
        this.quickSortInternally(av, pv, qv - 1, entityType);
        this.quickSortInternally(av, qv + 1, rv, entityType);
    }

    public int compare(ExtendedDataEntity arg0, ExtendedDataEntity arg1, BasedataEntityType entityType) {
        DynamicObject dynamicObject1 = arg0.getDataEntity();
        DynamicObject dynamicObject2 = arg1.getDataEntity();
        String longNumberDLM = ".";
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (!(property instanceof ParentBasedataProp)) continue;
            longNumberDLM = ((ParentBasedataProp)property).getLongNumberDLM();
        }
        if (dynamicObject1.getString("longnumber").split("\\" + longNumberDLM).length > dynamicObject2.getString("longnumber").split("\\" + longNumberDLM).length) {
            return 1;
        }
        return -1;
    }

    public int partition(ExtendedDataEntity[] av, int pv, int rv, BasedataEntityType entityType) {
        ExtendedDataEntity pivot = av[rv];
        int index = pv;
        for (int j = pv; j < rv; ++j) {
            if (this.compare(av[j], pivot, entityType) <= 0) continue;
            if (index == j) {
                ++index;
                continue;
            }
            ExtendedDataEntity tmp = av[index];
            av[index++] = av[j];
            av[j] = tmp;
        }
        ExtendedDataEntity tmp = av[index];
        av[index] = av[rv];
        av[rv] = tmp;
        return index;
    }

    public void addIgnoreRefEntityIds(BaseDataCheckRefrence checker) {
        String[] entityIds;
        RefObject opValue = new RefObject();
        if (this.getOption().tryGetVariableValue("ignorerefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getIgnoreRefEntityIds().add(entityId);
            }
        }
        opValue = new RefObject();
        if (this.getOption().tryGetVariableValue("checkrefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            for (String entityId : entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getCheckRefEntityIds().add(entityId);
            }
        }
    }
}

