/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.util.HttpClientUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class AttachmentUtil {
    private static final Log log = LogFactory.getLog(AttachmentUtil.class);
    private static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upLoadFile(String urlStr, Long pkId, String fileName, String appId, String formId, int index) {
        if (HRStringUtils.isEmpty((String)urlStr)) {
            return null;
        }
        log.info("AttachmentUtil.upLoadFile.urlStr", (Object)urlStr);
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        String path = "";
        try {
            HttpClient httpClient = HttpClientUtils.wrapperHttpClient((int)10000, (int)600000);
            URL url = new URL(urlStr);
            HttpGet httpGet = new HttpGet(url.toURI());
            httpGet.setHeader("User-Agent", USER_AGENT);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(600000).setRedirectsEnabled(true).build();
            httpGet.setConfig(requestConfig);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            log.info("AttachmentUtil.upLoadFile#response={}", (Object)response);
            inputStream = response.getEntity().getContent();
            if (ObjectUtils.isEmpty((Object)inputStream)) {
                String string = "";
                return string;
            }
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String tempUrl = tempFileCache.saveAsUrl(fileName, inputStream, 7200);
            path = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)appId, (String)formId, (Object)pkId, (String)fileName);
            log.info("AttachmentUtil.upLoadFile.path\uff1a{}", (Object)path);
        }
        catch (ConnectException ce) {
            log.error("AttachmentUtil.Connection timed out", (Throwable)ce);
            if (index < 3) {
                AttachmentUtil.upLoadFile(urlStr, pkId, fileName, appId, formId, index + 1);
            }
        }
        catch (Exception ex) {
            log.error("AttachmentUtil.upLoadFile.Exception", (Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioException) {
                    log.error("AttachmentUtil.upLoadFile.inputStream.close.error->", (Throwable)ioException);
                }
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
        return path;
    }

    private AttachmentUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upLoadFileDirect(String urlStr, Long entityId, String fileName, String entityKey) {
        if (ObjectUtils.isEmpty((Object)urlStr)) {
            return null;
        }
        InputStream inputStream = null;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            inputStream = conn.getInputStream();
        }
        catch (IOException ex) {
            log.error("upLoadFileDirect.error", (Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    log.error("upLoadFileDirect.error", (Throwable)ex);
                }
            }
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String pathParam = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)requestContext.getAccountId(), (String)"tsc", (String)entityKey, (Object)entityId, (String)fileName);
        log.info("AttachmentUtil.upLoadFile.pathParam", (Object)pathParam);
        FileItem fileItem = new FileItem(fileName, pathParam, inputStream);
        fileItem.setCreateNewFileWhenExists(false);
        String path = fileService.upload(fileItem);
        log.info("AttachmentUtil.upLoadFile.path", (Object)path);
        return path;
    }
}

