/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.common.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;

public class CandidateSortUtil {
    private CandidateSortUtil() {
    }

    public static List<DynamicObject> sortExperience(DynamicObject[] array, String startDateField, String endDateField, String createTimeField) {
        int length = array.length;
        ArrayList hadDateList = Lists.newArrayListWithExpectedSize((int)length);
        ArrayList noneDateList = Lists.newArrayListWithExpectedSize((int)length);
        for (DynamicObject dynamicObject : array) {
            Date endingDate = dynamicObject.getDate(endDateField);
            Date startDate = dynamicObject.getDate(startDateField);
            if (Objects.equal((Object)endingDate, null) && Objects.equal((Object)startDate, null)) {
                noneDateList.add(dynamicObject);
                continue;
            }
            hadDateList.add(dynamicObject);
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)length);
        if (!hadDateList.isEmpty()) {
            hadDateList.sort((o1, o2) -> {
                Date o1StartDate = o1.getDate(startDateField);
                Date o1EndingDate = o1.getDate(endDateField);
                Date o1CreateTime = o1.getDate(createTimeField);
                Date o2StartDate = o2.getDate(startDateField);
                Date o2EndingDate = o2.getDate(endDateField);
                Date o2CreateTime = o2.getDate(createTimeField);
                return CandidateSortUtil.getResult(o1StartDate, o1EndingDate, o1CreateTime, o2StartDate, o2EndingDate, o2CreateTime);
            });
            resultList.addAll(hadDateList);
        }
        if (!noneDateList.isEmpty()) {
            noneDateList.sort((o1, o2) -> CandidateSortUtil.compare(o1.getDate(createTimeField), o2.getDate(createTimeField)));
            resultList.addAll(noneDateList);
        }
        return resultList;
    }

    private static int getResult(Date o1StartDate, Date o1EndingDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = o1StartDate != null && o1EndingDate != null ? CandidateSortUtil.handStartAndEnd(o1StartDate, o1EndingDate, o1CreateDate, o2StartDate, o2EndingDate, o2CreateDate) : (o1StartDate != null ? CandidateSortUtil.hadStartNoEnd(o1StartDate, o1CreateDate, o2StartDate, o2EndingDate, o2CreateDate) : CandidateSortUtil.noStartHadEnd(o1EndingDate, o1CreateDate, o2StartDate, o2EndingDate, o2CreateDate));
        return compare;
    }

    private static int handStartAndEnd(Date o1StartDate, Date o1EndingDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = o2StartDate != null && o2EndingDate != null ? CandidateSortUtil.compareBothDate(o1StartDate, o1EndingDate, o1CreateDate, o2StartDate, o2EndingDate, o2CreateDate) : (o2StartDate != null ? CandidateSortUtil.compareSingleDate(o1StartDate, o1CreateDate, o2StartDate, o2CreateDate) : CandidateSortUtil.compareSingleDate(o1EndingDate, o1CreateDate, o2EndingDate, o2CreateDate));
        return compare;
    }

    private static int noStartHadEnd(Date o1EndingDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = o2EndingDate != null ? CandidateSortUtil.compareSingleDate(o1EndingDate, o1CreateDate, o2EndingDate, o2CreateDate) : CandidateSortUtil.compareSingleDate(o1EndingDate, o1CreateDate, o2StartDate, o2CreateDate);
        return compare;
    }

    private static int hadStartNoEnd(Date o1StartDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = o2StartDate != null ? CandidateSortUtil.compareSingleDate(o1StartDate, o1CreateDate, o2StartDate, o2CreateDate) : CandidateSortUtil.compareSingleDate(o1StartDate, o1CreateDate, o2EndingDate, o2CreateDate);
        return compare;
    }

    private static int compareBothDate(Date o1StartDate, Date o1EndingDate, Date o1CreateDate, Date o2StartDate, Date o2EndingDate, Date o2CreateDate) {
        int compare = CandidateSortUtil.compare(o1EndingDate, o2EndingDate);
        if (compare == 0) {
            compare = CandidateSortUtil.compare(o1StartDate, o2StartDate);
        }
        if (compare == 0) {
            compare = CandidateSortUtil.compare(o1CreateDate, o2CreateDate);
        }
        return compare;
    }

    private static int compareSingleDate(Date o1Date, Date o1CreateTime, Date o2Date, Date o2CreateTime) {
        int compare = CandidateSortUtil.compare(o1Date, o2Date);
        if (compare == 0) {
            compare = CandidateSortUtil.compare(o1CreateTime, o2CreateTime);
        }
        return compare;
    }

    private static int compare(Date start, Date end) {
        long endTime;
        long startTime = start == null ? 0L : start.getTime();
        long l = endTime = end == null ? 0L : end.getTime();
        if (startTime == endTime) {
            return 0;
        }
        return startTime > endTime ? -1 : 1;
    }
}

