/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.common.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class ResumeDyUtil {
    public static boolean equals(String compareStr, String ... strings) {
        boolean result = false;
        for (String string : strings) {
            if (!compareStr.equals(string)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id") == 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj == 0L;
        }
        if (obj instanceof BigDecimal) {
            return obj.equals(new BigDecimal(Integer.MAX_VALUE));
        }
        if (obj instanceof Integer) {
            return (Integer)obj == 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return obj instanceof Map && ((Map)obj).isEmpty();
    }

    public static List<Long> getStdRsmIds(Long mainStdRsmId, List<Long> mergeIds) {
        if (null == mergeIds || mergeIds.isEmpty()) {
            return ImmutableList.of((Object)mainStdRsmId);
        }
        ArrayList newMergeIds = Lists.newArrayListWithCapacity((int)(mergeIds.size() + 1));
        newMergeIds.addAll(mergeIds);
        newMergeIds.add(mainStdRsmId);
        return newMergeIds;
    }

    public static Object getInstance(String handlerClass) {
        try {
            Class<?> handle = Class.forName(handlerClass);
            return handle.newInstance();
        }
        catch (Exception e) {
            ErrorCode errorCode = new ErrorCode("CheckDuplicateService.getInstance", e.getMessage());
            throw new KDException(errorCode, new Object[0]);
        }
    }

    public static List<QFilter> getFilterByFields(DynamicObject dy, List<String> fields) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(16);
        for (String field : fields) {
            if (ResumeDyUtil.isEmpty(dy.get(field))) {
                list.clear();
                break;
            }
            if (dy.get(field) instanceof DynamicObject) {
                String keyField = field + "." + "id";
                list.add(new QFilter(field, "=", dy.get(keyField)));
                continue;
            }
            list.add(new QFilter(field, "=", dy.get(field)));
        }
        return list;
    }

    public static Set<String> getIgnoreSet() {
        HashSet ignoreSet = Sets.newHashSetWithExpectedSize((int)16);
        ignoreSet.add("id");
        ignoreSet.add("number");
        ignoreSet.add("creator");
        ignoreSet.add("createtime");
        ignoreSet.add("modifytime");
        ignoreSet.add("modifier");
        return ignoreSet;
    }

    public static <T> List<List<T>> carveUpListByStep(List<T> source, int len) {
        if (source == null || source.size() == 0 || len < 1) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)len);
        int count = (source.size() + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<T> value = null;
            value = (i + 1) * len < source.size() ? source.subList(i * len, (i + 1) * len) : source.subList(i * len, source.size());
            result.add(value);
        }
        return result;
    }

    public static boolean isValueChanged(Object newValue, Object oldValue) {
        return !Objects.deepEquals(newValue, oldValue);
    }
}

