/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.common.utils;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import org.apache.commons.lang3.StringUtils;

public class ViewUtils {
    public static void modifyFlexCaption(IFormView formView, String flexKey, String caption) {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("text", new LocaleString(caption));
        formView.updateControlMetadata(flexKey, (Map)props);
    }

    public static void openOptionBox(IFormView view, CloseCallBack closeCallBack, String title, List<String> msgDetail, MessageBoxOptions messageBoxOptions) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tstpm_operationresult");
        formShowParameter.setShowTitle(false);
        formShowParameter.setCustomParam("title", (Object)title);
        formShowParameter.setCustomParam("errorMsg", msgDetail);
        formShowParameter.setCustomParam("messageBoxOptions", (Object)messageBoxOptions);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(closeCallBack);
        view.showForm(formShowParameter);
    }

    public static String getCommonTipNotification(List<String> checkFailedFieldList) {
        StringBuilder tipNotification = new StringBuilder();
        String preFixNotification = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"ViewUtils_0", (String)"tsc-tstpm-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < checkFailedFieldList.size(); ++i) {
            tipNotification.append("\u201c").append(checkFailedFieldList.get(i)).append("\u201c");
            if (i >= checkFailedFieldList.size() - 1) continue;
            tipNotification.append("\u3001");
        }
        return String.format(Locale.ROOT, preFixNotification, tipNotification.toString());
    }

    public static void setDataChangedFieldInPageCache(IPageCache pageCache, String fieldKey) {
        String dataChangedFields = pageCache.get("datachangedfields");
        if (dataChangedFields == null) {
            pageCache.put("datachangedfields", fieldKey);
        } else if (!dataChangedFields.contains(fieldKey)) {
            pageCache.put("datachangedfields", dataChangedFields + fieldKey);
        }
    }

    public static void showDataChangedConfirm(IFormView view, String changeDesc, ConfirmCallBackListener confirmCallBackListener) {
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"BillView_2", (String)"bos-form-mvc", (Object[])new Object[0]);
        msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
        view.showConfirm(msg, changeDesc, options, ConfirmTypes.Save, confirmCallBackListener, (Map)btnNameMaps);
    }

    private ViewUtils() {
        throw new IllegalStateException("Utility class");
    }
}

