/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.mq.consumer;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.tsc.tstpm.business.domain.laborrelstatus.LaborRelStatusHelper;

public class LaborRelStatusConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(LaborRelStatusConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        log.info("LaborRelStatusConsumer.onMessage.body:{}", (Object)body.toString());
        try {
            this.laborRelStatusHandle((Map)body);
            log.info("LaborRelStatusConsumer.onMessage.end");
            acker.ack(messageId);
        }
        catch (RuntimeException e) {
            acker.discard(messageId);
            log.error("OfferConsumer.onMessage", (Throwable)e);
        }
        catch (Exception e) {
            acker.deny(messageId);
        }
    }

    private void laborRelStatusHandle(Map<String, Object> map) {
        log.info("LaborRelStatusConsumer.laborRelStatusHandle map -> {}", (Object)JSONObject.toJSONString(map));
        DynamicObject laborRelStatus = LaborRelStatusHelper.generateLaborRelStatus();
        this.laborRelStatusHandle(laborRelStatus, map);
        log.info("laborRelStatusHandle map -> {}", (Object)JSONObject.toJSONString(map));
        LaborRelStatusHelper.insertLaborRelStatus(laborRelStatus);
        DynamicObject stdRsm = LaborRelStatusHelper.selectStdRsmById((Long)map.get("stdrsm"));
        log.info("stdRsm id is -> {}", (Object)stdRsm.getLong("id"));
        this.stdRsmHandle(stdRsm, map);
        LaborRelStatusHelper.updateStdRsm(stdRsm);
    }

    private void stdRsmHandle(DynamicObject stdRsm, Map<String, Object> map) {
        stdRsm.set("laborrelstatus", map.get("laborrelstatus"));
    }

    private void laborRelStatusHandle(DynamicObject laborRelStatus, Map<String, Object> map) {
        laborRelStatus.set("laborrelstatus", map.get("laborrelstatus"));
        laborRelStatus.set("laborreltime", map.get("laborreltime"));
        laborRelStatus.set("application", map.get("application"));
        laborRelStatus.set("stdrsm", map.get("stdrsm"));
    }
}

