/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.api.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.web.util.DateUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class ResumeCommonHelper {
    private static final Set<String> DATESET = Sets.newHashSet();

    private ResumeCommonHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<Long, DynamicObject> getEditMap(List<Map<String, Object>> list, String primaryKey, HRBaseServiceHelper serviceHelper) {
        ArrayList idList = Lists.newArrayListWithCapacity((int)list.size());
        for (Map<String, Object> map : list) {
            Long id = (Long)map.get(primaryKey);
            if (id == null || id == 0L) continue;
            idList.add(id);
        }
        Object[] idArr = new Long[idList.size()];
        idList.toArray(idArr);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(idArr);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)list.size());
        for (DynamicObject dy : dynamicObjects) {
            resultMap.put(dy.getLong("id"), dy);
        }
        return resultMap;
    }

    public static void tranValue(Map<String, Object> map, DynamicObject dy) {
        DataEntityPropertyCollection dpc = dy.getDataEntityType().getProperties();
        Set allFields = dpc.stream().map(IMetadata::getName).collect(Collectors.toSet());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!allFields.contains(key)) continue;
            if (DATESET.contains(key)) {
                Date date = DateUtil.str2Date((String)String.valueOf(entry.getValue()), (String)"yyyy-MM-dd");
                dy.set(key, (Object)date);
                continue;
            }
            dy.set(key, entry.getValue());
        }
    }

    public static void setCommonVal(DynamicObject dy, boolean isCreate) {
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (isCreate) {
            dy.set("createtime", (Object)now);
            dy.set("creator", (Object)TSCRequestContext.getUserId());
        }
        dy.set("modifytime", (Object)now);
        dy.set("modifier", (Object)TSCRequestContext.getUserId());
    }

    static {
        DATESET.add("birthday");
    }
}

