/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.api.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tstpm.business.domain.rsm.api.helper.ResumeCommonHelper;

public class ResumeLangAblService {
    private static HRBaseServiceHelper langHelper = new HRBaseServiceHelper("tstpm_rsmlangabl");

    private ResumeLangAblService() {
        throw new IllegalStateException("Utility class");
    }

    public static void modifyResumeLangAbl(List<Map<String, Object>> langAblList) {
        Map<Long, DynamicObject> editMap = ResumeCommonHelper.getEditMap(langAblList, "id", langHelper);
        ArrayList editLangList = Lists.newArrayListWithCapacity((int)langAblList.size());
        ArrayList addLangList = Lists.newArrayListWithCapacity((int)langAblList.size());
        for (Map<String, Object> map : langAblList) {
            Long id = (Long)map.get("id");
            if (id != null && id != 0L) {
                DynamicObject editLangDy = editMap.get(id);
                ResumeLangAblService.editLang(map, editLangList, editLangDy);
                continue;
            }
            ResumeLangAblService.addLang(map, addLangList);
        }
        DynamicObject[] editLangArr = new DynamicObject[editLangList.size()];
        editLangList.toArray(editLangArr);
        langHelper.update(editLangArr);
        DynamicObject[] addLangArr = new DynamicObject[addLangList.size()];
        addLangList.toArray(addLangArr);
        langHelper.save(addLangArr);
    }

    private static void editLang(Map<String, Object> map, List<DynamicObject> editLangList, DynamicObject editLangDy) {
        ResumeLangAblService.langInfo(map, null, false, editLangList, editLangDy);
    }

    private static void addLang(Map<String, Object> map, List<DynamicObject> addLangList) {
        DynamicObject langDy = langHelper.generateEmptyDynamicObject();
        ResumeLangAblService.langInfo(map, ID.genLongId(), true, addLangList, langDy);
    }

    private static void langInfo(Map<String, Object> map, Long id, boolean isCreate, List<DynamicObject> langList, DynamicObject langDy) {
        ResumeCommonHelper.tranValue(map, langDy);
        if (id != null && id != 0L) {
            langDy.set("id", (Object)id);
        }
        ResumeCommonHelper.setCommonVal(langDy, isCreate);
        langList.add(langDy);
    }

    public static void deleteResumeLangAbl(Long pk) {
        langHelper.deleteOne((Object)pk);
    }

    public static List<DynamicObject> queryResumeLangAbl(Long rsmId) {
        String selectProperties = "id,certificatetitle,languagename,langcertscore";
        QFilter rsmQfFilter = new QFilter("rsm", "=", (Object)rsmId);
        DynamicObject[] resumeArr = langHelper.query(selectProperties, new QFilter[]{rsmQfFilter});
        return Arrays.asList(resumeArr);
    }
}

