/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.api.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.dto.TSCBaseResponseDTO;
import kd.tsc.tstpm.business.domain.rsm.api.helper.ResumeCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.api.helper.RsmExpApiHelper;
import kd.tsc.tstpm.business.domain.rsm.api.service.ResumeLangAblService;
import kd.tsc.tstpm.business.domain.rsm.api.service.RsmExpApiService;
import kd.tsc.tstpm.business.domain.rsm.api.service.RsmSubInfoApiService;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class ResumeService {
    private static final Log LOG = LogFactory.getLog(ResumeService.class);
    private static final String RSM = "rsm";
    private static final String EDU = "edu";
    private static final String WORK = "work";
    private static final String PRJ = "prj";
    private static final String LANG = "lang";
    private static final String EXPTMONSALCURC = "exptmonsalcurc";
    private static HRBaseServiceHelper rsmHelper = new HRBaseServiceHelper("tstpm_rsm");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TSCBaseResponseDTO modifyResume(List<Map<String, Object>> resumeList) {
        LOG.info("ResumeService_modifyResume begin...");
        ArrayList editResumeList = Lists.newArrayListWithCapacity((int)resumeList.size());
        ArrayList addResumeList = Lists.newArrayListWithCapacity((int)resumeList.size());
        ArrayList eduList = Lists.newArrayListWithCapacity((int)resumeList.size());
        ArrayList workList = Lists.newArrayListWithCapacity((int)resumeList.size());
        ArrayList prjList = Lists.newArrayListWithCapacity((int)resumeList.size());
        ArrayList langList = Lists.newArrayListWithCapacity((int)resumeList.size());
        ArrayList idList = Lists.newArrayListWithCapacity((int)resumeList.size());
        for (Map<String, Object> map : resumeList) {
            Long rsmId = ID.genLongId();
            DynamicObject rsmDy = rsmHelper.generateEmptyDynamicObject();
            ResumeService.resumeInfo(map, rsmId, null, addResumeList, true, rsmDy);
            String number = CodeRuleServiceHelper.getNumber((String)"tstpm_rsm", (DynamicObject)rsmDy, null);
            rsmDy.set("number", (Object)number);
            ResumeService.resumeChildrenModel(map, eduList, workList, prjList, langList, rsmId);
            idList.add(rsmId);
        }
        try (TXHandle tx = TX.required();){
            ResumeService.saveResume(editResumeList, addResumeList, eduList, workList, prjList, langList);
        }
        return TSCBaseResponseDTO.success((Object)idList);
    }

    private static void saveResume(List<DynamicObject> editResumeList, List<DynamicObject> addResumeList, List<Map<String, Object>> eduList, List<Map<String, Object>> workList, List<Map<String, Object>> prjList, List<Map<String, Object>> langList) {
        LOG.info("ResumeService_saveResume begin...");
        DynamicObject[] addResumeArr = new DynamicObject[addResumeList.size()];
        addResumeList.toArray(addResumeArr);
        rsmHelper.save(addResumeArr);
        RsmExpApiService.getInstance().saveRsmEduExp(eduList, RsmExpApiHelper.timeColumnList(), "tstpm_rsmeduexp");
        RsmSubInfoApiService.getInstance().saveRsmSubInfo(workList, "tstpm_rsmworkexp");
        RsmSubInfoApiService.getInstance().saveRsmSubInfo(prjList, "tstpm_rsmprjexp");
        ResumeLangAblService.modifyResumeLangAbl(langList);
        if (editResumeList.size() == 0) {
            return;
        }
        DynamicObject[] editResumeArr = new DynamicObject[editResumeList.size()];
        editResumeList.toArray(editResumeArr);
        rsmHelper.update(editResumeArr);
    }

    private static void resumeChildrenModel(Map<String, Object> map, List<Map<String, Object>> eduList, List<Map<String, Object>> workList, List<Map<String, Object>> prjList, List<Map<String, Object>> langList, Long rsmId) {
        List edu = (List)map.get(EDU);
        if (edu != null && edu.size() > 0) {
            HashMap rsmMap = Maps.newHashMapWithExpectedSize((int)2);
            rsmMap.put(RSM, rsmId);
            ArrayList eduInfoList = Lists.newArrayListWithCapacity((int)edu.size());
            ResumeService.addRsmID(edu, eduInfoList, rsmId);
            rsmMap.put(EDU, eduInfoList);
            eduList.add(rsmMap);
        }
        List work = (List)map.get(WORK);
        ResumeService.addRsmID(work, workList, rsmId);
        List prj = (List)map.get(PRJ);
        ResumeService.addRsmID(prj, prjList, rsmId);
        List lang = (List)map.get(LANG);
        ResumeService.addRsmID(lang, langList, rsmId);
    }

    private static void addRsmID(List<Map<String, Object>> list, List<Map<String, Object>> childrenModelList, Long rsmId) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (Map<String, Object> mm : list) {
            if (mm == null || mm.size() == 0) continue;
            if (rsmId != null && rsmId != 0L) {
                mm.put(RSM, rsmId);
            }
            childrenModelList.add(mm);
        }
    }

    private static void resumeInfo(Map<String, Object> map, Long rsmId, Long rdeLiveryId, List<DynamicObject> resumeList, boolean isCreate, DynamicObject rsmDy) {
        ResumeCommonHelper.tranValue(map, rsmDy);
        if (rsmId != null && rsmId != 0L) {
            rsmDy.set("id", (Object)rsmId);
        }
        if (rdeLiveryId != null && rdeLiveryId != 0L) {
            rsmDy.set("delivery", (Object)rdeLiveryId);
        }
        ResumeCommonHelper.setCommonVal(rsmDy, isCreate);
        resumeList.add(rsmDy);
    }

    public static DynamicObject queryResumeDetail(Long id) {
        String selectProperties = "id,number,stdrsm,fullname,gender,photo,workingyears,birthday,natreg,phone,email,highesteduschool,highesteducation,recentcompany,recentposition,certificatetype,certificatenumber,expccity,resumestoadd,currentresidence,selfevaluation,exptmonsalcurc,exptmonsal";
        return rsmHelper.queryOne(selectProperties, (Object)id);
    }
}

