/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.api.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tstpm.business.domain.rsm.api.exception.InvalException;
import kd.tsc.tstpm.business.domain.rsm.api.exception.NotFoundException;
import kd.tsc.tstpm.business.domain.rsm.api.exception.OverLimitException;
import org.apache.commons.lang3.StringUtils;

public class ResumeValidateParamsService {
    private static final String EDU = "edu";
    private static final String WORK = "work";
    private static final String PRJ = "prj";
    private static final String LANG = "lang";
    private static final String STARTDATE = "startdate";
    private static final String ENDINGDATE = "endingdate";
    private static final String EXPTMONSALCURC = "exptmonsalcurc";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Map<String, Integer> RESUMESTRMAP = Maps.newHashMapWithExpectedSize((int)12);
    private static final Map<String, Integer> EDUSTRMAP = Maps.newHashMapWithExpectedSize((int)1);
    private static final Map<String, Integer> WORKSTRMAP = Maps.newHashMapWithExpectedSize((int)4);
    private static final Map<String, Integer> PRJSTRMAP = Maps.newHashMapWithExpectedSize((int)3);
    private static final Map<String, Integer> LANGSTRMAP = Maps.newHashMapWithExpectedSize((int)1);
    private static final Set<String> INTEGERMAP = Sets.newHashSet();
    private static final Set<String> NUMBERMAP = Sets.newHashSet();
    private List<Long> natregList = Lists.newArrayList();
    private List<Long> certificatetypeList = Lists.newArrayList();
    private List<Long> expccityList = Lists.newArrayList();
    private List<Long> exptmonsalcurcList = Lists.newArrayList();
    private List<Long> schoolnameList = Lists.newArrayList();
    private List<Long> educationList = Lists.newArrayList();
    private List<Long> industrytypeList = Lists.newArrayList();
    private List<Long> languagenameList = Lists.newArrayList();

    public String validateParams(List<Map<String, Object>> resumeList) {
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> map : resumeList) {
            Object exptmonsalcurc;
            Object expccity;
            Object certificatetype;
            sb.append(this.check(map, RESUMESTRMAP));
            sb.append(this.checkTime(map));
            List edu = (List)map.get(EDU);
            sb.append(this.check(edu, EDUSTRMAP));
            sb.append(ResumeValidateParamsService.check(edu));
            List work = (List)map.get(WORK);
            sb.append(this.check(work, WORKSTRMAP));
            List prj = (List)map.get(PRJ);
            sb.append(this.check(prj, PRJSTRMAP));
            List lang = (List)map.get(LANG);
            sb.append(this.check(lang, LANGSTRMAP));
            Object natreg = map.get("natreg");
            if (natreg != null) {
                this.natregList.add(Long.parseLong(String.valueOf(natreg)));
            }
            if ((certificatetype = map.get("certificatetype")) != null) {
                this.certificatetypeList.add(Long.parseLong(String.valueOf(certificatetype)));
            }
            if ((expccity = map.get("expccity")) != null) {
                this.expccityList.add(Long.parseLong(String.valueOf(expccity)));
            }
            if ((exptmonsalcurc = map.get(EXPTMONSALCURC)) == null) continue;
            this.exptmonsalcurcList.add(Long.parseLong(String.valueOf(exptmonsalcurc)));
        }
        sb.append(ResumeValidateParamsService.checkBasicData(this.natregList, "bd_country", "\u56fd\u7c4d/\u5730\u533a"));
        sb.append(ResumeValidateParamsService.checkBasicData(this.certificatetypeList, "hbss_credentialstype", "\u8bc1\u4ef6\u7c7b\u578b"));
        sb.append(ResumeValidateParamsService.checkBasicData(this.expccityList, "bd_admindivision", "\u671f\u671b\u57ce\u5e02"));
        sb.append(ResumeValidateParamsService.checkBasicData(this.exptmonsalcurcList, "bd_currency", "\u671f\u671b\u6708\u85aa\u5e01\u522b"));
        sb.append(ResumeValidateParamsService.checkBasicData(this.schoolnameList, "hbss_college", "\u9662\u6821"));
        sb.append(ResumeValidateParamsService.checkBasicData(this.educationList, "hbss_diploma", "\u5b66\u5386"));
        sb.append(ResumeValidateParamsService.checkBasicData(this.industrytypeList, "hbss_industrytype", "\u6240\u5c5e\u884c\u4e1a"));
        sb.append(ResumeValidateParamsService.checkBasicData(this.languagenameList, "tsrbd_language", "\u8bed\u79cd"));
        return sb.toString();
    }

    private static String checkBasicData(List<Long> list, String page, String errorMsg) {
        DynamicObject[] query;
        StringBuilder sb = new StringBuilder();
        if (list == null || list.isEmpty()) {
            return sb.toString();
        }
        List distinctList = list.stream().distinct().collect(Collectors.toList());
        HRBaseServiceHelper rsmHelper = new HRBaseServiceHelper(page);
        QFilter qFilter = new QFilter("id", "in", distinctList);
        for (DynamicObject dy : query = rsmHelper.query("id", new QFilter[]{qFilter})) {
            long id = dy.getLong("id");
            distinctList.remove(id);
        }
        if (!distinctList.isEmpty()) {
            throw new NotFoundException(errorMsg + distinctList.toString());
        }
        return sb.toString();
    }

    private static String check(List<Map<String, Object>> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        int index = 0;
        for (Map<String, Object> map : list) {
            Boolean isHighestEdu = (Boolean)map.get("ishighestedu");
            if (isHighestEdu == null || !isHighestEdu.booleanValue()) continue;
            ++index;
        }
        if (index > 1) {
            return "\u6700\u9ad8\u5b66\u5386\u4e0d\u80fd\u6709\u591a\u4e2a";
        }
        return "";
    }

    private String check(List<Map<String, Object>> list, Map<String, Integer> strMap) {
        StringBuilder sb = new StringBuilder();
        if (list == null || list.isEmpty()) {
            return sb.toString();
        }
        for (Map<String, Object> map : list) {
            if (map == null || map.size() == 0) continue;
            sb.append(this.check(map, strMap));
            sb.append(this.checkTime(map));
        }
        return sb.toString();
    }

    private String checkTime(Map<String, Object> map) {
        Object start = map.get(STARTDATE);
        Object end = map.get(ENDINGDATE);
        Object birthdayObj = map.get("birthday");
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_FORMAT);
        try {
            Date endingDate;
            Date startDate;
            if (start != null && end != null && (startDate = sdf.parse(String.valueOf(start))).after(endingDate = sdf.parse(String.valueOf(end)))) {
                sb.append("\u5f00\u59cb\u65f6\u95f4\u5728\u7ed3\u675f\u65f6\u95f4\u4e4b\u524d\uff1b");
            }
            if (birthdayObj != null) {
                sdf.parse(String.valueOf(birthdayObj));
            }
        }
        catch (Exception e) {
            InvalException exception = new InvalException("\u65f6\u95f4\u683c\u5f0f\u9700\u4e3a\uff1ayyyy-MM-dd HH:mm:ss");
            exception.initCause(e);
            throw exception;
        }
        return sb.toString();
    }

    private String check(Map<String, Object> map, Map<String, Integer> strMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            if (obj == null) continue;
            String value = String.valueOf(obj);
            if (strMap.containsKey(key)) {
                Integer length = strMap.get(key);
                if (value == null || ResumeValidateParamsService.getWordCount(value) <= length) continue;
                throw new OverLimitException(key + "length too long");
            }
            if (INTEGERMAP.contains(key)) {
                ResumeValidateParamsService.isInteger(key, value);
                continue;
            }
            if (NUMBERMAP.contains(key)) {
                ResumeValidateParamsService.isNumber(key, value);
                continue;
            }
            this.addId(key, value);
        }
        return sb.toString();
    }

    private void addId(String key, String value) {
        if (HRStringUtils.equals((String)"schoolname", (String)key)) {
            this.schoolnameList.add(Long.parseLong(value));
        } else if (HRStringUtils.equals((String)"education", (String)key)) {
            this.educationList.add(Long.parseLong(value));
        } else if (HRStringUtils.equals((String)"industrytype", (String)key)) {
            this.industrytypeList.add(Long.parseLong(value));
        } else if (HRStringUtils.equals((String)"languagename", (String)key)) {
            this.languagenameList.add(Long.parseLong(value));
        }
    }

    private static int getWordCount(String inputStr) {
        inputStr = inputStr.replaceAll("[^\\x00-\\xff]", "**");
        return inputStr.length();
    }

    private static void isInteger(String key, String str) {
        boolean isInteger = StringUtils.isNumeric((CharSequence)str);
        if (!isInteger) {
            throw new InvalException(key + " should be Integer");
        }
    }

    private static void isNumber(String key, String str) {
        BigDecimal bigDecimal = new BigDecimal(str);
        long length = bigDecimal.longValue();
        if (String.valueOf(length).length() > 13) {
            throw new OverLimitException(key + " Integer part too long");
        }
    }

    static {
        RESUMESTRMAP.put("fullname", 100);
        RESUMESTRMAP.put("gender", 2);
        RESUMESTRMAP.put("photo", 255);
        RESUMESTRMAP.put("phone", 50);
        RESUMESTRMAP.put("email", 100);
        RESUMESTRMAP.put("recentcompany", 100);
        RESUMESTRMAP.put("recentposition", 100);
        RESUMESTRMAP.put("certificatenumber", 100);
        RESUMESTRMAP.put("resumestoadd", 255);
        RESUMESTRMAP.put("currentresidence", 50);
        RESUMESTRMAP.put("selfevaluation", 500);
        EDUSTRMAP.put("specialtyname", 100);
        WORKSTRMAP.put("companyname", 100);
        WORKSTRMAP.put("positionname", 100);
        WORKSTRMAP.put("workresponsibility", 1500);
        WORKSTRMAP.put("department", 200);
        PRJSTRMAP.put("projectname", 100);
        PRJSTRMAP.put("projectjob", 100);
        PRJSTRMAP.put("projectresp", 2000);
        PRJSTRMAP.put("projectdesc", 2000);
        LANGSTRMAP.put("certificatetitle", 100);
        INTEGERMAP.add("exptmonsal");
        INTEGERMAP.add("underlingnumber");
        NUMBERMAP.add("workingyears");
        NUMBERMAP.add("langcertscore");
    }
}

