/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.api.service;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.dto.TSCBaseResponseDTO;
import kd.tsc.tsrbd.common.enums.TSCErrorCodeEnum;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsrbs.common.exception.TSCBizException;
import kd.tsc.tstpm.business.domain.rsm.api.helper.RsmExpApiHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmEduExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RsmExpApiService {
    private static final Log LOGGER = LogFactory.getLog(RsmExpApiService.class);
    private static HRBaseServiceHelper eduExpServiceHelper = RsmEduExpHelper.EDUEXPSERVICEHELPER;
    private static RsmExpApiService rsmExpApiService = new RsmExpApiService();

    private RsmExpApiService() {
    }

    public static RsmExpApiService getInstance() {
        return rsmExpApiService;
    }

    public TSCBaseResponseDTO saveRsmEduExp(List<Map<String, Object>> dataList, List<String> timeColumnList, String pageNumber) {
        LOGGER.info("saveRsmEduExp timeColumnList:{},pageNumber:{}", timeColumnList, (Object)pageNumber);
        if (dataList.isEmpty()) {
            return TSCBaseResponseDTO.fail((TSCErrorCodeEnum)TSCErrorCodeEnum.PARAM_MISS, (String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        try {
            for (Map<String, Object> data : dataList) {
                Long rsm = (Long)data.get("rsm");
                List eduList = (List)data.get("edu");
                Pair<DynamicObjectCollection, DynamicObject[]> saveModify = RsmExpApiHelper.saveAndModifyRsmExpSortHandle(eduList, timeColumnList, pageNumber);
                for (DynamicObject dynamicObject : (DynamicObjectCollection)saveModify.getLeft()) {
                    dynamicObject.set("lengthofstudy", (Object)ResumeAnalysisHelper.calculateDuration((DynamicObject)dynamicObject));
                }
                for (DynamicObject dynamicObject : (DynamicObject[])saveModify.getRight()) {
                    dynamicObject.set("lengthofstudy", (Object)ResumeAnalysisHelper.calculateDuration((DynamicObject)dynamicObject));
                }
                if (!((DynamicObjectCollection)saveModify.getLeft()).isEmpty()) {
                    eduExpServiceHelper.save((DynamicObjectCollection)saveModify.getLeft());
                }
                DynamicObjectCollection left = (DynamicObjectCollection)saveModify.getLeft();
                DynamicObject highestEdu = this.setHighestEdu(left);
                this.updateHighEdu(rsm, highestEdu);
            }
        }
        catch (Exception exception) {
            LOGGER.info("\u4fdd\u5b58\u5f02\u5e38\uff01", (Object)exception);
            throw new TSCBizException((Throwable)exception);
        }
        return TSCBaseResponseDTO.success((Object)"\u6570\u636e\u4fdd\u5b58\u6210\u529f");
    }

    private DynamicObject setHighestEdu(DynamicObjectCollection left) {
        DynamicObject highestEdu = null;
        for (DynamicObject dy : left) {
            boolean isHighestEdu = dy.getBoolean("ishighestedu");
            if (!isHighestEdu) continue;
            highestEdu = dy;
        }
        return highestEdu;
    }

    private void updateHighEdu(Long rsm, DynamicObject highestEdu) {
        if (rsm != null) {
            if (highestEdu != null) {
                this.updateHighestEduExp(rsm, highestEdu);
            } else {
                this.updateHighestEduExp(rsm);
            }
        }
    }

    public TSCBaseResponseDTO delRsmEduExp(long eduId) {
        LOGGER.info("delRsmEduExp  eduId:{}", (Object)eduId);
        try {
            QFilter qFilter = new QFilter("id", "=", (Object)eduId);
            DynamicObject dynamicObject = eduExpServiceHelper.loadDynamicObject(qFilter.toArray());
            if (dynamicObject == null) {
                return TSCBaseResponseDTO.fail((TSCErrorCodeEnum)TSCErrorCodeEnum.DATA_NOT_FOUND, (String)"\u5220\u9664ID\u4e0d\u5b58\u5728\uff01");
            }
            eduExpServiceHelper.deleteByFilter(qFilter.toArray());
            if (dynamicObject.getBoolean("ishighestedu")) {
                this.updateHighestEduExp(dynamicObject.getLong("rsm"));
            }
        }
        catch (Exception exception) {
            LOGGER.info("\u5220\u9664\u5f02\u5e38\uff01", (Object)exception);
            return TSCBaseResponseDTO.fail((TSCErrorCodeEnum)TSCErrorCodeEnum.BUSINESS_ERROR, (String)"\u63a5\u53e3\u5f02\u5e38\uff01");
        }
        return TSCBaseResponseDTO.success((Object)"\u5220\u9664\u6210\u529f\uff01");
    }

    public void updateHighestEduExp(long rsmID) {
        LOGGER.info("updateHighestEduExp  rsmID:{}", (Object)rsmID);
        List<DynamicObject> eduExpList = RsmEduExpHelper.findEduExps(rsmID, null);
        List sortRsmEduExpList = ResumeExpSortHelper.sortRsmEduExp(eduExpList);
        DynamicObject highestEdu = null;
        if (!sortRsmEduExpList.isEmpty()) {
            highestEdu = (DynamicObject)sortRsmEduExpList.get(0);
            eduExpServiceHelper.update(sortRsmEduExpList.toArray(new DynamicObject[0]));
        }
        this.updateHighestEduExp(rsmID, highestEdu);
    }

    public void updateHighestEduExp(long rsmID, DynamicObject highestEdu) {
        DynamicObject rsm = RsmHelper.findOne(rsmID);
        ResumeExpSortHelper.setHighestEduInfo((DynamicObject)highestEdu, (DynamicObject)rsm);
        RsmHelper.rsmServiceHelper.updateOne(rsm);
    }
}

