/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.arf;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.field.DateEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.business.domain.perm.offerapprove.ARFRCheckPerm;
import kd.tsc.tsrbd.business.domain.perm.offerapprove.CheckPermFactory;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsrbs.common.enums.NeedDisposeEmptyFieldEnum;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;
import org.apache.commons.lang3.ObjectUtils;

public class ARFRsmHelper {
    private static final String KEY_OPSTATUS = "operationstatus";
    private static final String LINEFEED = "\\\\r\\\\n";
    private static final String LINEFEED_REPLACE = "\r\n";
    public static final HRBaseServiceHelper rsmServiceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srscarfmarfrsm");
    public static final String RSM_QUERY_PROP = "id,highesteduschool,highesteducation,hestspecialtycat,highestspecialty,highestdegree,index,recentcompany,recentposition,stdrsm,fullname,gender,natreg,birthday,age,partwt,workingyears,jobstatus,phone,email";

    public static DynamicObject findOne(long id) {
        return rsmServiceHelper.queryOne((Object)id);
    }

    private ARFRsmHelper() {
    }

    public static DynamicObject[] findRsmById(Long rsmId, String queryProp) {
        QFilter qFilter = new QFilter("id", "=", (Object)rsmId);
        if (HRStringUtils.isNotEmpty((String)queryProp)) {
            return rsmServiceHelper.query(queryProp, qFilter.toArray());
        }
        return rsmServiceHelper.loadDynamicObjectArray(qFilter.toArray());
    }

    public static DynamicObject[] findRsmByStdRsmIds(List<Long> stdRsmIds) {
        HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srrsm");
        QFilter qFilter = new QFilter("stdrsm", "in", stdRsmIds);
        return serviceHelper.query("id,fullname,createtime,modifytime,stdrsm,delivery", qFilter.toArray(), "createtime desc");
    }

    public static void handlerPartwtChange(Date date, IFormView view) {
        IDataModel model = view.getModel();
        model.beginInit();
        if (date != null) {
            int totalMonth = ResumeAnalysisHelper.calMonthByStartDate((Date)date);
            model.setValue("workingyears", (Object)totalMonth);
            RsmCommonHelper.setShowWorkYears(totalMonth, view);
        } else {
            model.setValue("workingyears", null);
            model.setValue("showworkingyears", null);
        }
        model.endInit();
        view.updateView("workingyears");
        view.updateView("showworkingyears");
    }

    public static void setDataControlMinMax(Date startDate, Date endDate, IFormView view) {
        DateEdit startDateEdit = (DateEdit)view.getControl("startdate");
        DateEdit endDateEdit = (DateEdit)view.getControl("endingdate");
        if (null != startDate) {
            endDateEdit.setMinDate(startDate);
        }
        if (null != endDate) {
            startDateEdit.setMaxDate(endDate);
        }
    }

    public static boolean dealDateTime(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        DataEntityPropertyCollection dpc = dataEntity.getDataEntityType().getProperties();
        Set allFields = dpc.stream().map(IMetadata::getName).collect(Collectors.toSet());
        return allFields.contains("startdate");
    }

    public static void handleExpEditPropertyChange(PropertyChangedArgs pde, IFormView view) {
        String propertyKey = pde.getProperty().getName();
        IDataModel model = view.getModel();
        if ("startdate".equals(propertyKey)) {
            Date startDate = (Date)pde.getChangeSet()[0].getNewValue();
            Date endingDate = model.getDataEntity().getDate("endingdate");
            ARFRsmHelper.setDataControlMinMax(startDate, endingDate, view);
        } else if ("endingdate".equals(propertyKey)) {
            Date endingDate = (Date)pde.getChangeSet()[0].getNewValue();
            Date startDate = model.getDataEntity().getDate("startdate");
            ARFRsmHelper.setDataControlMinMax(startDate, endingDate, view);
        } else if ("ishitherto".equals(propertyKey)) {
            view.setEnable(Boolean.valueOf(!model.getDataEntity().getBoolean("ishitherto")), new String[]{"endingdate"});
            if (model.getDataEntity().getBoolean("ishitherto")) {
                model.setValue("endingdate", null);
            }
        }
    }

    public static void handleRsmExpAfterBindData(IFormView view) {
        IDataModel model = view.getModel();
        Date startDate = model.getDataEntity().getDate("startdate");
        Date endingDate = model.getDataEntity().getDate("endingdate");
        ARFRsmHelper.setDataControlMinMax(startDate, endingDate, view);
    }

    public static void setExpEditDataModel(BizDataEventArgs pde, IFormView view, String entityId) {
        Object pkId = view.getFormShowParameter().getCustomParam("pkId");
        if (pkId == null) {
            return;
        }
        Long expExpId = (Long)pkId;
        String dataSource = (String)view.getFormShowParameter().getCustomParam("dataSource");
        if (expExpId != 0L && "1".equals(dataSource)) {
            IPageCache pageCache = view.getParentView().getPageCache();
            DynamicObject expDy = ResumeUtilsHelper.findExpById((IPageCache)pageCache, (Long)expExpId, (String)entityId);
            pde.setDataEntity((Object)expDy);
        }
    }

    public static void deleteCacheData(IPageCache pageCache, long deleteExpId, String entityId) {
        List cacheEduExps = ResumeUtilsHelper.deserializeDynamicObject((IPageCache)pageCache, (String)entityId);
        if (cacheEduExps != null && !cacheEduExps.isEmpty()) {
            for (DynamicObject cacheEduExp : cacheEduExps) {
                if (deleteExpId != cacheEduExp.getLong("id")) continue;
                cacheEduExps.remove(cacheEduExp);
                break;
            }
            if (!cacheEduExps.isEmpty()) {
                String expStr = DynamicObjectSerializeUtil.serialize((Object[])cacheEduExps.toArray(), (DynamicObjectType)((DynamicObject)cacheEduExps.get(0)).getDynamicObjectType());
                pageCache.put(entityId, expStr);
            } else {
                pageCache.remove(entityId);
            }
        }
    }

    public static void showConfirmDeleteRsmExp(String billFormId, IFormView view) {
        view.showConfirm(SrRsmKDString.deleteOneDataTip(), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(billFormId));
    }

    public static boolean showDataChangeForm(IFormView view, IFormView parentView, ConfirmCallBackListener confirmCallBacks) {
        return ARFRsmHelper.showDataChangeForm(view, parentView, "", confirmCallBacks);
    }

    public static boolean showDataChangeForm(IFormView view, IFormView parentView, String cacheKey, ConfirmCallBackListener confirmCallBacks) {
        String changeDataMessage = view.getPageCache().get(cacheKey + view.getEntityId());
        if (HRStringUtils.isNotEmpty((String)changeDataMessage)) {
            String changeDataMessagePrefix = SrRsmKDString.billIsChange();
            String detailMsg = changeDataMessagePrefix + changeDataMessage;
            ARFRsmHelper.showDataChangeForm(detailMsg, view, parentView, confirmCallBacks);
            return true;
        }
        return false;
    }

    public static void showDataChangeForm(String detailMsg, IFormView view, IFormView parentView, ConfirmCallBackListener confirmCallBacks) {
        String msg = SrRsmKDString.confirmSaveChange();
        msg = msg.replace(LINEFEED, LINEFEED_REPLACE);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), SrRsmKDString.returnUpdate());
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), SrRsmKDString.directQuit());
        if (null != parentView) {
            parentView.showConfirm(msg, detailMsg, options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
        } else {
            view.showConfirm(msg, detailMsg, options, ConfirmTypes.Save, confirmCallBacks, (Map)btnNameMaps);
        }
    }

    public static void saveRsm(DynamicObject rsmDy) {
        rsmServiceHelper.saveOne(rsmDy);
    }

    public static void rsmExpListPackageData(PackageDataEvent pde, IFormView view) {
        DynamicObject rowData = pde.getRowData();
        ColumnDesc source = (ColumnDesc)pde.getSource();
        String fieldKey = source.getFieldKey();
        ARFRsmHelper.setSpecialValue(pde, rowData, source, fieldKey);
        if (HRStringUtils.equals((String)"schoolname.name", (String)fieldKey)) {
            String number = rowData.getString("schoolname.number");
            if (HRStringUtils.equals((String)"30000010_S", (String)number)) {
                pde.setFormatValue((Object)rowData.getString("othschname"));
            }
        } else if (HRStringUtils.equals((String)"langcertscore", (String)fieldKey)) {
            BigDecimal bigDecimal = rowData.getBigDecimal("langcertscore");
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                pde.setFormatValue((Object)"-");
            }
        } else if (HRStringUtils.equals((String)KEY_OPSTATUS, (String)fieldKey)) {
            pde.setFormatValue((Object)view.getFormShowParameter().getStatusValue());
        } else if (fieldKey.contains("showlength") || "showprojectduration".equals(fieldKey)) {
            Date startDate = rowData.getDate("startdate");
            Date endingDate = rowData.getDate("endingdate");
            if (rowData.getDynamicObjectType().getProperties().containsKey((Object)"ishitherto") && rowData.getBoolean("ishitherto")) {
                endingDate = new Date();
            }
            int month = ResumeAnalysisHelper.calMonthByStartDate((Date)startDate, (Date)endingDate);
            pde.setFormatValue((Object)ResumeAnalysisHelper.getWorkYearShow((int)month));
        } else if (HRStringUtils.equals((String)"languagename.name", (String)fieldKey)) {
            String number = rowData.getString("languagename.number");
            if (HRStringUtils.equals((String)"1080_S", (String)number)) {
                pde.setFormatValue((Object)rowData.getString("othlanguagetype"));
            }
        } else if (HRStringUtils.equals((String)"industrytype.name", (String)fieldKey)) {
            String number = rowData.getString("industrytype.number");
            boolean isContainOthLanguageType = rowData.getDynamicObjectType().getProperties().containsKey((Object)"industrytypetxt");
            if (HRStringUtils.equals((String)"1210_S", (String)number) && isContainOthLanguageType) {
                pde.setFormatValue((Object)rowData.getString("industrytypetxt"));
            }
        }
    }

    private static void setSpecialValue(PackageDataEvent pde, DynamicObject rowData, ColumnDesc source, String fieldKey) {
        if (NeedDisposeEmptyFieldEnum.isExist((String)fieldKey)) {
            boolean isEmpty;
            boolean bl = isEmpty = rowData.get(fieldKey) == null || "".equals(pde.getFormatValue());
            if (isEmpty) {
                pde.setFormatValue((Object)"-");
            }
        }
    }

    public static boolean appFileValidCanEdit(IFormView view) {
        DynamicObject rsmDy = view.getModel().getDataEntity();
        long appFileId = rsmDy.getLong("appfile");
        if (appFileId == 0L) {
            return true;
        }
        if (!RsmAppFileHelper.appFileIsInProcess(appFileId)) {
            IFormView parentView = view.getParentView();
            parentView.showTipNotification(SrRsmKDString.editInProcess());
            view.sendFormAction(parentView);
            return false;
        }
        return true;
    }

    public static boolean rsmExpValidCanEdit(long expId, String expEntityId, IFormView view) {
        long appFileId;
        long rsmId;
        DynamicObject[] rsmDyArr;
        DynamicObject expDy = ServiceHelperCache.getHrBaseServiceHelper((String)expEntityId).queryOne("rsm", (Object)expId);
        if (null != expDy && null != (rsmDyArr = ARFRsmHelper.findRsmById(rsmId = expDy.getLong("rsm"), "appfile")) && rsmDyArr.length > 0 && !RsmAppFileHelper.appFileIsInProcess(appFileId = rsmDyArr[0].getLong("appfile"))) {
            IFormView parentView = view.getParentView().getParentView();
            parentView.showTipNotification(SrRsmKDString.editInProcess());
            view.sendFormAction(parentView);
            return false;
        }
        return true;
    }

    public static DynamicObject getAppFileByStdRsmMidAndPositionId(Long mid, Long positionId, Date applyTime) {
        return AppFileMService.getAppFileByStdRsmIdAndPositionId(mid, positionId, applyTime);
    }

    public static void reloadExpList(IFormView view) {
        Long rsmId = view.getModel().getDataEntity().getLong("id");
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String ecosystem = dataEntity.getString("tpsys");
        if (ObjectUtils.isEmpty((Object)ecosystem)) {
            ecosystem = "KD";
        }
        Long recrutyp = Optional.ofNullable(dataEntity.getDynamicObject("recrutyp")).map(dynamicObject -> dynamicObject.getLong("id")).orElse(1020L);
        Map entryInfoMap = ResumeMetadataService.getEntryInfo((String)"7", (Long)recrutyp, (String)ecosystem, (boolean)false);
        for (Map.Entry entry : entryInfoMap.entrySet()) {
            ARFRsmHelper.reloadRsmExpView((String)entry.getKey(), (String)entry.getValue(), rsmId, view);
        }
    }

    public static void reloadRsmExpView(String pageKey, String containerKey, Long rsmId, IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        ListShowParameter expShowParameter = FormShowHelper.createListFormShowParameter((String)"tstpm_list_rsm", (String)containerKey, (String)pageKey, (ShowType)ShowType.InContainer, null);
        if (rsmId == null) {
            expShowParameter.setCustomParam("rsm_id", (Object)"0");
        } else {
            expShowParameter.setCustomParam("rsm_id", (Object)rsmId.toString());
        }
        String dataSource = (String)formShowParameter.getCustomParam("dataSource");
        expShowParameter.setCustomParam("dataSource", (Object)dataSource);
        expShowParameter.setStatus(formShowParameter.getStatus());
        ARFRCheckPerm checkPerm = (ARFRCheckPerm)CheckPermFactory.getInstance().getCheckPerm("arfr");
        boolean isSkipCheckPerm = checkPerm.skipCheckPerm(view, Long.valueOf(RequestContext.get().getCurrUserId()));
        if (isSkipCheckPerm) {
            expShowParameter.setHasRight(true);
        }
        view.showForm((FormShowParameter)expShowParameter);
        view.getPageCache().put("pageid_" + pageKey, expShowParameter.getPageId());
    }
}

