/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.constants.rsm.ResumeConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;

public class ResumeBoHelper {
    private static final HRBaseServiceHelper RSM_HELPER = new HRBaseServiceHelper("tstpm_srrsm");

    private ResumeBoHelper() {
    }

    public static AppResumeBo getAppResumeBo(Long rsmId) {
        return RsmCommonService.getAppResumeBo((Long)rsmId);
    }

    public static void setDeliveryIsDisplayNew(long appFileId, AppResumeBo resumeBo) {
        DynamicObject[] deliveryDyArr;
        DynamicObject appFile = null;
        if (appFileId != 0L) {
            appFile = RsmAppFileHelper.queryOneById(appFileId, "id,name,number,deliveryrec,isbinddelyrec");
        }
        if (appFileId == 0L || HRObjectUtils.isEmpty((Object)appFile)) {
            ResumeBoHelper.setDeliveryDisplayFalse(resumeBo);
            resumeBo.getRsm().set("appfile", null);
            return;
        }
        resumeBo.getRsm().set("appfile", appFile.get("id"));
        DynamicObject delivery = resumeBo.getDelivery();
        if (delivery == null) {
            return;
        }
        QFilter appFileQFilter = new QFilter("appfile", "=", (Object)appFileId);
        DynamicObject[] rsmArr = ResumeUtilsHelper.getServiceHelper((String)"tstpm_srrsm").query("id,appfile,delivery", new QFilter[]{appFileQFilter});
        ArrayList deliveryIdList = Lists.newArrayListWithExpectedSize((int)rsmArr.length);
        for (DynamicObject dy : rsmArr) {
            DynamicObject deliveryDy = dy.getDynamicObject("delivery");
            if (deliveryDy == null) continue;
            deliveryIdList.add(deliveryDy.getLong("id"));
        }
        if (deliveryIdList == null || deliveryIdList.isEmpty()) {
            return;
        }
        HRBaseServiceHelper serviceHelper = ResumeUtilsHelper.getServiceHelper((String)"tstpm_srrdelivery");
        QFilter idQFilter = new QFilter("id", "in", (Object)deliveryIdList);
        for (DynamicObject deliveryDy : deliveryDyArr = serviceHelper.query("id,isfiledisplay", new QFilter[]{idQFilter})) {
            deliveryDy.set("isfiledisplay", (Object)Boolean.FALSE);
        }
        serviceHelper.update(deliveryDyArr);
    }

    public static void setDeliveryIsDisplay(long appFileId, AppResumeBo resumeBo) {
        DynamicObject appFile = null;
        if (appFileId != 0L) {
            appFile = RsmAppFileHelper.queryOneById(appFileId, "id,name,number,deliveryrec,isbinddelyrec");
            if (null != appFile) {
                if (!appFile.getBoolean("isbinddelyrec")) {
                    DynamicObject deliveryDy = appFile.getDynamicObject("deliveryrec");
                    if (deliveryDy != null && deliveryDy.getLong("id") != 0L && deliveryDy.getDataEntityState().getFromDatabase()) {
                        deliveryDy.set("isfiledisplay", (Object)Boolean.FALSE);
                        ResumeUtilsHelper.getServiceHelper((String)"tstpm_srrdelivery").updateOne(deliveryDy);
                    }
                } else {
                    ResumeBoHelper.setDeliveryDisplayFalse(resumeBo);
                }
            }
        } else {
            ResumeBoHelper.setDeliveryDisplayFalse(resumeBo);
        }
        if (null == appFile) {
            resumeBo.getRsm().set("appfile", null);
        } else {
            resumeBo.getRsm().set("appfile", appFile.get("id"));
        }
    }

    public static void setDeliveryDisplayFalse(AppResumeBo resumeBo) {
        DynamicObject deliveryDy = resumeBo.getDelivery();
        if (null != deliveryDy) {
            deliveryDy.set("isfiledisplay", (Object)Boolean.FALSE);
        }
    }

    public static void save(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        DynamicObject delivery = resumeBo.getDelivery();
        try (TXHandle txHandle = TX.required();){
            if (delivery != null) {
                RSM_HELPER.saveOne(delivery);
            }
            ResumeBoHelper.beforeSaveOpRsm(resumeBo);
            ResumeBoHelper.saveOneRsm(rsm);
            ResumeBoHelper.handlerAppFile(resumeBo);
            ResumeBoHelper.handlerSubForm(resumeBo);
        }
    }

    public static void handlerSubForm(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        if (null == rsm) {
            return;
        }
        for (String pagekey : ResumeConstants.SUBPAGES) {
            if (pagekey.startsWith("tsirm")) continue;
            ServiceHelperCache.getHrBaseServiceHelper((String)pagekey).deleteByFilter(new QFilter[]{new QFilter("rsm", "=", (Object)rsm.getLong("id"))});
        }
        for (DynamicObjectCollection coll : resumeBo.getDyoCollMap().values()) {
            if (coll == null || coll.isEmpty()) continue;
            RSM_HELPER.save(coll);
        }
    }

    private static void beforeSaveOpRsm(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        DynamicObject delivery = resumeBo.getDelivery();
        if (null != delivery) {
            rsm.set("delivery", (Object)delivery.getLong("id"));
            rsm.set("delivery_id", (Object)delivery.getLong("id"));
        }
    }

    private static void handlerAppFile(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        long appFileId = ResumeUtilsHelper.getId((DynamicObject)rsm, (String)"appfile");
        if (appFileId != 0L) {
            DynamicObject appFile = RsmAppFileHelper.queryOneById(appFileId);
            RsmCommonService.updateAppFileByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
            if (!appFile.getBoolean("isbinddelyrec")) {
                RsmCommonService.updateAppFileDeliveryByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
                appFile.set("appres", (Object)resumeBo.getRsm());
            }
            long recrutypId = resumeBo.getRsm().getLong("recrutyp");
            appFile.set("recrutyp", (Object)recrutypId);
            AppFileMService.saveOne(appFile);
        }
    }

    public static AppResumeBo copy(AppResumeBo resumeBo) {
        DynamicObject rsm = resumeBo.getRsm();
        Date currDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        HashSet rsmIgnoreKeys = Sets.newHashSet();
        ResumeBoHelper.handleIgnoreKeys(rsmIgnoreKeys);
        rsmIgnoreKeys.add("appfile");
        rsmIgnoreKeys.add("delivery");
        rsmIgnoreKeys.add("appfile_id");
        rsmIgnoreKeys.add("delivery_id");
        DynamicObject newRsm = RSM_HELPER.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)rsm, (DynamicObject)newRsm, (Set)rsmIgnoreKeys);
        ResumeBoHelper.handleDyo(newRsm, currDate);
        HashSet deliveryIgnoreKeys = Sets.newHashSet();
        ResumeBoHelper.handleIgnoreKeys(deliveryIgnoreKeys);
        DynamicObject delivery = ResumeBoHelper.getDelivery(resumeBo);
        DynamicObject newDelivery = RSM_HELPER.generateEmptyDynamicObject(delivery.getDataEntityType().getName());
        HRDynamicObjectUtils.copy((DynamicObject)delivery, (DynamicObject)newDelivery, (Set)deliveryIgnoreKeys);
        ResumeBoHelper.handleDyo(newDelivery, currDate);
        newDelivery.set("applytime", (Object)currDate);
        AppResumeBo newAppResumeBo = new AppResumeBo(newRsm, newDelivery);
        ResumeBoHelper.loadAllListData(resumeBo);
        Map dyoCollMap = resumeBo.getDyoCollMap();
        for (Map.Entry entry : dyoCollMap.entrySet()) {
            DynamicObjectCollection oldColl = (DynamicObjectCollection)entry.getValue();
            if (oldColl == null || oldColl.isEmpty()) continue;
            DynamicObjectCollection newColl = new DynamicObjectCollection();
            for (DynamicObject oldDyo : oldColl) {
                DynamicObject newDyo = RSM_HELPER.generateEmptyDynamicObject((String)entry.getKey());
                HashSet<String> dyoIgnoreKeys = new HashSet<String>();
                dyoIgnoreKeys.add("rsm");
                ResumeBoHelper.handleIgnoreKeys(dyoIgnoreKeys);
                HRDynamicObjectUtils.copy((DynamicObject)oldDyo, (DynamicObject)newDyo, dyoIgnoreKeys);
                newDyo.set("rsm", (Object)newRsm.getLong("id"));
                ResumeBoHelper.handleDyo(newDyo, currDate);
                newColl.add((Object)newDyo);
            }
            newAppResumeBo.setEntry((String)entry.getKey(), newColl);
        }
        return newAppResumeBo;
    }

    private static void handleIgnoreKeys(Set<String> set) {
        set.add("id");
        set.add("createtime");
        set.add("creator");
        set.add("modifytime");
        set.add("modifier");
    }

    private static void handleDyo(DynamicObject dyo, Date time) {
        dyo.set("id", (Object)ID.genLongId());
        dyo.set("createtime", (Object)time);
        dyo.set("creator", (Object)TSCRequestContext.getUserId());
        dyo.set("modifytime", null);
        dyo.set("modifier", null);
    }

    public static void loadAllListData(AppResumeBo resumeBo) {
        RsmCommonService.loadAllListData((AppResumeBo)resumeBo);
    }

    public static DynamicObject[] getRsmByStdRsmIds(List<Long> stdRsmIds) {
        QFilter filter = new QFilter("stdrsm", "in", stdRsmIds);
        return RSM_HELPER.query("delivery, delivery.applytime, appfile,fullname,stdrsm", new QFilter[]{filter}, "delivery.applytime desc");
    }

    public static DynamicObject[] getAppFileNotNullOfRsmByStdRsmIds(List<Long> stdRsmIds) {
        QFilter filter = new QFilter("stdrsm", "in", stdRsmIds);
        filter.and("appfile", "!=", (Object)0L);
        return RSM_HELPER.query("delivery, appfile,fullname,stdrsm", new QFilter[]{filter}, "delivery.applytime desc");
    }

    public static void setResumeBoExp(AppResumeBo resumeBo, String expSubPage) {
        for (String subpage : ResumeConstants.SUBPAGES) {
            if (subpage.equals(expSubPage)) continue;
            DynamicObjectCollection collection = RsmCommonService.getRsmList((AppResumeBo)resumeBo, (String)subpage);
            resumeBo.setEntry(subpage, collection);
        }
    }

    public static void saveOneRsm(DynamicObject rsm) {
        if (null == rsm) {
            return;
        }
        String number = rsm.getString("number");
        if (HRStringUtils.isEmpty((String)number)) {
            String codeNumber = CodeRuleServiceHelper.getNumber((String)"tstpm_rsm", (DynamicObject)rsm, null);
            rsm.set("number", (Object)codeNumber);
        }
        RSM_HELPER.saveOne(rsm);
    }

    public static DynamicObject getDelivery(AppResumeBo resumeBo) {
        return RsmCommonService.getDelivery((AppResumeBo)resumeBo);
    }

    public static DynamicObject getDelivery(DynamicObject rsmDt) {
        return RsmCommonService.getDelivery((DynamicObject)rsmDt);
    }

    public static void updateAppFileDeliveryByAppResume(DynamicObject appFile, AppResumeBo resumeBo) {
        RsmCommonService.updateAppFileDeliveryByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
    }

    public static void updateAppFileByAppResume(DynamicObject appFile, AppResumeBo resumeBo) {
        RsmCommonService.updateAppFileByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
    }
}

