/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmEduExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmLangAblHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmPrjExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmWorkExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmWorkRelHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.arf.ARFRsmAwrhonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.arf.ARFRsmEduExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.arf.ARFRsmInterexpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.arf.ARFRsmLangAblHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.arf.ARFRsmPrjExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.arf.ARFRsmWorkExpHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmApiService;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;
import org.apache.commons.lang3.StringUtils;

public class RsmCommonHelper {
    private static final Log LOG = LogFactory.getLog(RsmCommonHelper.class);
    private static final String FORMATSTR = "\u201c%s\u201d\u3001";
    private static final Set<String> KEY_FIELDS = Sets.newHashSet((Object[])new String[]{"phone", "email", "fullname", "highesteducation", "birthday", "partwt", "certificatenumber"});
    public static final HRBaseServiceHelper RSMDAO = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srrsm");

    private RsmCommonHelper() {
    }

    public static List<DynamicObject> getAllExpSortList(Long rsmId, List<DynamicObject> cacheData, String entityName) {
        List<Object> expSortList = Lists.newArrayListWithExpectedSize((int)1);
        switch (entityName) {
            case "tstpm_srrsmworkrela": {
                expSortList = RsmWorkRelHelper.getAllWorkRelSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srrsmeduexp": {
                expSortList = RsmEduExpHelper.getAllEduExpSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srrsmlangabl": {
                expSortList = RsmLangAblHelper.getAllLangAblSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srrsmworkexp": {
                expSortList = RsmWorkExpHelper.getAllEduWorkSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srrsmprjexp": {
                expSortList = RsmPrjExpHelper.getAllEduWorkSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srscarfmrsmeduexp": {
                expSortList = ARFRsmEduExpHelper.getAllEduExpSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srscarfmrsminterexp": {
                expSortList = ARFRsmInterexpHelper.getAllEduExpSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srscarfmrsmprjexp": {
                expSortList = ARFRsmPrjExpHelper.getAllEduWorkSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srscarfmrsmworkexp": {
                expSortList = ARFRsmWorkExpHelper.getAllEduWorkSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srscarfmrsmlangabl": {
                expSortList = ARFRsmLangAblHelper.getAllLangAblSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_srscarfmrsmawrhon": {
                expSortList = ARFRsmAwrhonHelper.getAllEduExpSortList(rsmId, cacheData);
                break;
            }
        }
        if (!expSortList.isEmpty()) {
            expSortList.forEach(exp -> exp.set("rsm", (Object)rsmId));
        }
        return expSortList;
    }

    public static List<DynamicObject> getAllExpSortListSC(Long rsmId, List<DynamicObject> cacheData, String entityName) {
        List<Object> expSortList = Lists.newArrayListWithExpectedSize((int)1);
        switch (entityName) {
            case "tstpm_scsrrsmeduexp": {
                expSortList = RsmEduExpHelper.getAllEduExpSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_scsrrsmlangabl": {
                expSortList = RsmLangAblHelper.getAllLangAblSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_scsrrsmworkexp": {
                expSortList = RsmWorkExpHelper.getAllEduWorkSortList(rsmId, cacheData);
                break;
            }
            case "tstpm_scsrrsmprjexp": {
                expSortList = RsmPrjExpHelper.getAllEduWorkSortList(rsmId, cacheData);
                break;
            }
        }
        if (!expSortList.isEmpty()) {
            expSortList.forEach(exp -> exp.set("rsm", (Object)rsmId));
        }
        return expSortList;
    }

    public static void setShowWorkYears(int totalMonth, IFormView view) {
        IDataModel model = view.getModel();
        model.setValue("showworkingyears", (Object)ResumeAnalysisHelper.getWorkYearShow((int)totalMonth));
        view.updateView("showworkingyears");
    }

    public static void setShowAge(IFormView view) {
        IDataModel model = view.getModel();
        Date birthDay = model.getDataEntity().getDate("birthday");
        if (Objects.isNull(birthDay)) {
            return;
        }
        model.setValue("age", (Object)ResumeAnalysisHelper.calculateAge((Date)birthDay));
        view.updateView("showworkingyears");
    }

    public static String checkAdminDivision(DynamicObject dataEntity, IFormView childView) {
        String rgstprmtrsdId = dataEntity.getString("rgstprmtrsd");
        if (HRStringUtils.isNotEmpty((String)rgstprmtrsdId) && !rgstprmtrsdId.equals("0") && !ResumeUtilsHelper.checkAdminDivision((long)Long.parseLong(rgstprmtrsdId), (int)3)) {
            String tips = SrRsmKDString.leastCountry();
            childView.showFieldTip(ResumeUtilsHelper.createFieldTip((String)tips, (String)"rgstprmtrsd"));
            return tips;
        }
        String nativeplaceId = dataEntity.getString("nativeplace");
        if (HRStringUtils.isNotEmpty((String)nativeplaceId) && !nativeplaceId.equals("0") && !ResumeUtilsHelper.checkAdminDivision((long)Long.parseLong(nativeplaceId), (int)2)) {
            String tips = SrRsmKDString.leastCity();
            childView.showFieldTip(ResumeUtilsHelper.createFieldTip((String)tips, (String)"nativeplace"));
            return tips;
        }
        return null;
    }

    public static String checkMustInput(DynamicObject dataEntity, IFormView view) {
        Date birthdayV;
        String genderV;
        String tipMsgResult = SrRsmKDString.pleaseInputAs();
        String tips = SrRsmKDString.notNull();
        String tipMsg = "";
        String fullNameV = dataEntity.getString("fullname");
        if (HRStringUtils.isEmpty((String)fullNameV)) {
            FieldEdit fullNameF = (FieldEdit)view.getControl("fullname");
            String localName = fullNameF.getProperty().getDisplayName().getLocaleValue();
            tipMsg = String.format(Locale.ROOT, FORMATSTR, localName);
            view.showFieldTip(ResumeUtilsHelper.createFieldTip((String)tips, (String)"fullname"));
        }
        if (HRStringUtils.isEmpty((String)(genderV = dataEntity.getString("gender")))) {
            ComboEdit genderF = (ComboEdit)view.getControl("gender");
            String localName = genderF.getProperty().getDisplayName().getLocaleValue();
            tipMsg = tipMsg + String.format(Locale.ROOT, FORMATSTR, localName);
            view.showFieldTip(ResumeUtilsHelper.createFieldTip((String)tips, (String)"gender"));
        }
        if (null == (birthdayV = dataEntity.getDate("birthday"))) {
            DateEdit birthdayF = (DateEdit)view.getControl("birthday");
            String localName = birthdayF.getProperty().getDisplayName().getLocaleValue();
            tipMsg = tipMsg + String.format(Locale.ROOT, FORMATSTR, localName);
            view.showFieldTip(ResumeUtilsHelper.createFieldTip((String)tips, (String)"birthday"));
        }
        if (HRStringUtils.isNotEmpty((String)tipMsg)) {
            tipMsg = StringUtils.removeEnd((String)tipMsg, (String)"\u3001");
            return String.format(Locale.ROOT, tipMsgResult, tipMsg);
        }
        return null;
    }

    public static String checkPhoneEmail(DynamicObject dataEntity, IFormView view, String phoneKey, String emailKey) {
        String phone = dataEntity.getString(phoneKey);
        String email = dataEntity.getString(emailKey);
        if (StringUtils.isBlank((CharSequence)phone) && StringUtils.isBlank((CharSequence)email)) {
            String tip = SrRsmKDString.phoneOrEmailMust();
            DeleteRule deleteRule = ResumeUtilsHelper.createDeleteRule((String[])new String[]{phoneKey, emailKey});
            FieldTip phoneFieldTip = ResumeUtilsHelper.createFieldTip((String)tip, (String)phoneKey);
            FieldTip emailFieldTip = ResumeUtilsHelper.createFieldTip((String)tip, (String)emailKey);
            phoneFieldTip.setDeleteRule(deleteRule);
            emailFieldTip.setDeleteRule(deleteRule);
            view.showFieldTip(phoneFieldTip);
            view.showFieldTip(emailFieldTip);
            return tip;
        }
        return null;
    }

    public static String validPhoneEmail(DynamicObject dataEntity, IFormView childView) {
        String phone = dataEntity.getString("phone");
        String email = dataEntity.getString("email");
        if (StringUtils.isNotBlank((CharSequence)phone) && !ResumeAnalysisHelper.checkPhone((String)phone)) {
            String tip = SrRsmKDString.phoneError();
            childView.showFieldTip(ResumeUtilsHelper.createFieldTip((String)tip, (String)"phone"));
            return tip;
        }
        if (StringUtils.isNotBlank((CharSequence)email) && !ResumeAnalysisHelper.checkEmail((String)email)) {
            String tip = SrRsmKDString.emailError();
            childView.showFieldTip(ResumeUtilsHelper.createFieldTip((String)tip, (String)"email"));
            return tip;
        }
        return null;
    }

    public static void copyResume(DynamicObject fromObj, DynamicObject toObj) {
        HashSet<String> ignoreKeys = new HashSet<String>(16);
        ignoreKeys.add("id");
        ignoreKeys.add("creator");
        ignoreKeys.add("createtime");
        ignoreKeys.add("appfile");
        ignoreKeys.add("delivery");
        ignoreKeys.add("rsmsource");
        ignoreKeys.add("stdrsm");
        ResumeUtilsHelper.copyObj((DynamicObject)fromObj, (DynamicObject)toObj, ignoreKeys);
    }

    public static void showSimpleRsm(IFormView view, boolean isShow) {
        boolean visibleSim = isShow && view.getEntityId().equals("tstpm_srrsm");
        view.setVisible(Boolean.valueOf(!visibleSim), new String[]{"panel_perinfo", "panel_contactinfo", "advpanel_eduexp", "advpanel_wordexp", "advpanel_prjexp", "panel_selfdesc", "advpanel_workrelaexp", "panel_jobintention", "advpanel_langexp"});
        view.setVisible(Boolean.valueOf(visibleSim), new String[]{"panel_candidateinfo"});
    }

    public static AppResumeBo getUpdateResumeBo(DynamicObject rsm, List<DynamicObject> expList, String entityId) {
        AppResumeBo resumeBo = new AppResumeBo(rsm);
        ResumeBoHelper.setResumeBoExp(resumeBo, entityId);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            resumeBo.setEntry(entityId, expList);
        }
        return resumeBo;
    }

    public static boolean expDataIsChanged(IPageCache pageCache, List<DynamicObject> expList) {
        for (DynamicObject exp : expList) {
            if (!exp.getDataEntityState().getFromDatabase()) {
                return true;
            }
            DynamicObject oldExpCache = ResumeUtilsHelper.deserialize((IPageCache)pageCache, (String)RsmCommonHelper.getCacheEntityKey(exp), (String)exp.getDataEntityType().getName());
            if (!ResumeUtilsHelper.dataIsChanged((DynamicObject)oldExpCache, (DynamicObject)exp, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static void executeUpdateExp(DynamicObject rsm, List<DynamicObject> expList, String entityId, IPageCache pageCache, boolean isDelete) {
        AppResumeBo resumeBo = RsmCommonHelper.getUpdateResumeBo(rsm, expList, entityId);
        boolean isDiffUpdateStdRsm = isDelete || RsmCommonHelper.expDataIsChanged(pageCache, expList);
        RsmCommonHelper.updateRsmInfo(rsm, resumeBo, Boolean.TRUE, isDiffUpdateStdRsm, pageCache);
    }

    public static boolean dataIsChanged(IPageCache pageCache, DynamicObject rsm) {
        DynamicObject oldRsm = ResumeUtilsHelper.deserialize((IPageCache)pageCache, (String)RsmCommonHelper.getCacheEntityKey(rsm), (String)rsm.getDataEntityType().getName());
        return ResumeUtilsHelper.dataIsChanged((DynamicObject)oldRsm, (DynamicObject)rsm, (boolean)false);
    }

    public static void updateRsmInfo(DynamicObject rsm, AppResumeBo resumeBo, Boolean pubAiLabel, Boolean isDiffUpdateStdRsm, IPageCache pageCache) {
        Long stdrsmId = rsm.getLong("stdrsm");
        Long rsmId = rsm.getLong("id");
        DynamicObject oldRsm = RsmHelper.findRsmById(rsmId, "photo")[0];
        rsm.set("photo", (Object)oldRsm.getString("photo"));
        ResumeUtilsHelper.setModifierAndTime((DynamicObject)rsm);
        try (TXHandle tx = TX.required();){
            DynamicObject appFile;
            LOG.info("RsmCommonHelper.updateRsmInfo.updateOne,RSMID:{},STDRSMID:{}", (Object)rsmId, (Object)stdrsmId);
            RSMDAO.updateOne(rsm);
            LOG.info("RsmCommonHelper.updateRsmInfo.diffUpdateStandResume,RSMID:{},STDRSMID:{}", (Object)rsmId, (Object)stdrsmId);
            String photo = resumeBo.getRsm().getString("photo");
            LOG.info("RsmCommonHelper.updateRsmInfo.diffUpdateStandResume,PHOTO:{}", (Object)photo);
            if (Boolean.TRUE.equals(isDiffUpdateStdRsm)) {
                AddResumeService.diffUpdateStandResume(stdrsmId, resumeBo, ResumeTypeEnum.APP_FILE_UPDATE);
                LOG.info("RsmCommonHelper.updateRsmInfo.diffUpdateStandResume");
            }
            if ((appFile = RsmAppFileHelper.findAppFileByRsmId(rsmId)) != null) {
                RsmCommonService.updateAppFileByAppResume((DynamicObject)appFile, (AppResumeBo)resumeBo);
                appFile.set("isbinddelyrec", (Object)"1");
                LOG.info("RsmCommonHelper.updateRsmInfo.AppFileHelper.update,RSMID:{}", (Object)rsmId);
                AppFileMService.save(new DynamicObject[]{appFile});
                if (Boolean.TRUE.equals(isDiffUpdateStdRsm)) {
                    RsmCommonHelper.addRsmUpdateOpRecord(rsm, resumeBo, pageCache, appFile);
                }
            }
        }
        RsmCommonHelper.outTransaction(rsmId, pubAiLabel);
    }

    private static void addRsmUpdateOpRecord(DynamicObject rsm, AppResumeBo resumeBo, IPageCache pageCache, DynamicObject appFile) {
        Iterable bizChangedProperties = resumeBo.getRsm().getDataEntityState().getBizChangedProperties();
        Iterator<IDataEntityProperty> bizChangeProps = bizChangedProperties.iterator();
        ArrayList keyChangeList = Lists.newArrayList();
        DynamicObject originRsm = null;
        RsmCommonHelper.handleKeyFieldChange(rsm, pageCache, bizChangeProps, keyChangeList, originRsm);
        Map<String, List<Map<String, String>>> changeListMap = Collections.singletonMap(appFile.getString("id"), keyChangeList);
        AppFileMService.addRsmUpdateOpRecord(new DynamicObject[]{appFile}, changeListMap);
    }

    private static void handleKeyFieldChange(DynamicObject rsm, IPageCache pageCache, Iterator<IDataEntityProperty> bizChangeProps, List<Map<String, String>> keyChangeList, DynamicObject originRsm) {
        while (bizChangeProps.hasNext()) {
            IDataEntityProperty next = bizChangeProps.next();
            if (!KEY_FIELDS.contains(next.getName())) continue;
            if (originRsm == null) {
                originRsm = ResumeUtilsHelper.deserialize((IPageCache)pageCache, (String)RsmCommonHelper.getCacheEntityKey(rsm), (String)rsm.getDataEntityType().getName());
            }
            HashMap map = Maps.newHashMapWithExpectedSize((int)4);
            map.put("fieldkey", next.getName());
            map.put("fieldname", next.getDisplayName().getLocaleValue());
            RsmCommonHelper.setValue(next, rsm, map, originRsm);
            keyChangeList.add(map);
        }
    }

    private static void setValue(IDataEntityProperty next, DynamicObject rsm, Map<String, String> map, DynamicObject originRsm) {
        String newValue = "";
        String oldValue = "";
        if (next instanceof FieldProp) {
            Object oldValueObj;
            FieldProp fieldProp = (FieldProp)next;
            Object newValueObj = fieldProp.getBasePropDisplayValue((Object)rsm);
            if (newValueObj != null) {
                newValue = newValueObj.toString();
            }
            if ((oldValueObj = fieldProp.getBasePropDisplayValue((Object)originRsm)) != null) {
                oldValue = oldValueObj.toString();
            }
        } else {
            newValue = rsm.getString(next.getName());
            if (originRsm != null) {
                oldValue = originRsm.getString(next.getName());
            }
        }
        map.put("newvalue", newValue);
        map.put("oldvalue", oldValue);
    }

    public static void coverOldRsm(AppResumeBo resumeBo, ResumeTypeEnum resumeTypeEnum) {
        DynamicObject rsm = resumeBo.getRsm();
        ResumeUtilsHelper.setModifierAndTime((DynamicObject)rsm);
        Long stdRsmId = rsm.getLong("stdrsm");
        try (TXHandle txHandle = TX.requiresNew();){
            ResumeBoHelper.save(resumeBo);
            LOG.info("RsmUtilsHelper.coverOldRsm resumeBo.save()");
            AddResumeService.diffUpdateStandResume(stdRsmId, resumeBo, resumeTypeEnum);
            LOG.info("RsmUtilsHelper.coverOldRsm diffUpdateStandResume");
        }
        RsmCommonHelper.outTransaction(rsm.getLong("id"), Boolean.TRUE);
    }

    public static void outTransaction(long rsmId, Boolean pubAiLabel) {
        if (Boolean.TRUE.equals(pubAiLabel)) {
            LOG.info("RsmCommonHelper.outTransaction.publishRsmMsgToAILabel.update,RSMID:{}", (Object)rsmId);
            RsmApiService.publishRsmMsgToAILabel(rsmId);
        }
    }

    public static void showAppFile(IFormView view, Object appFileId, String msg) {
        String entityId = RsmCommonService.getOpenAppFileEntityId((Object)appFileId);
        if (!HRStringUtils.isEmpty((String)entityId)) {
            view.showErrorNotification(SrRsmKDString.notHaveAppFileRight());
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(entityId);
        showParameter.setPkId(appFileId);
        showParameter.setCustomParam("successMsg", (Object)msg);
        view.showForm((FormShowParameter)showParameter);
    }

    public static String getCacheEntityKey(DynamicObject entity) {
        return "key_data_cache_prefix_" + entity.getPkValue();
    }
}

