/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmExpCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;

public class RsmLangAblHelper {
    private static final Log logger = LogFactory.getLog(RsmLangAblHelper.class);
    private static final HRBaseServiceHelper LANGABLSERVICEHELPER = new HRBaseServiceHelper("tstpm_srrsmlangabl");

    private RsmLangAblHelper() {
    }

    public static List<DynamicObject> findLangAbl(Long rsmId, Object[] excludeIds) {
        return RsmExpCommonHelper.findRsmExpDyList(rsmId, excludeIds, LANGABLSERVICEHELPER);
    }

    public static DynamicObject[] findLangAbl(Object[] ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return LANGABLSERVICEHELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public static void saveRsmLangAbl(List<DynamicObject> langAblSorts, Long rsmId, IPageCache pageCache) {
        if (langAblSorts == null || langAblSorts.isEmpty()) {
            return;
        }
        DynamicObject rsm = RsmHelper.findOne(rsmId);
        try (TXHandle tx = TX.required();){
            LANGABLSERVICEHELPER.save(langAblSorts.toArray(new DynamicObject[0]));
            RsmCommonHelper.executeUpdateExp(rsm, langAblSorts, "tstpm_srrsmlangabl", pageCache, false);
        }
    }

    public static void deleteLangAbl(IPageCache pageCache, Long deleteLangAblId, Long rsmId, String dataSource) {
        if (rsmId != null && rsmId != 0L && !"1".equals(dataSource)) {
            List<DynamicObject> langAblList = RsmLangAblHelper.findLangAbl(rsmId, new Object[]{deleteLangAblId});
            DynamicObject[] dellangAblArr = RsmLangAblHelper.findLangAbl(new Object[]{deleteLangAblId});
            if (dellangAblArr != null && dellangAblArr.length > 0) {
                DynamicObject rsm = RsmHelper.findOne(rsmId);
                try (TXHandle tx = TX.required();){
                    LANGABLSERVICEHELPER.deleteOne((Object)deleteLangAblId);
                    RsmCommonHelper.executeUpdateExp(rsm, langAblList, "tstpm_srrsmlangabl", pageCache, true);
                }
            }
        } else {
            RsmHelper.deleteCacheData(pageCache, deleteLangAblId, "tstpm_srrsmlangabl");
        }
    }

    public static List<DynamicObject> getAllLangAblSortList(Long rsmId, List<DynamicObject> cacheDataList) {
        ArrayList allExps = Lists.newArrayListWithExpectedSize((int)4);
        if (cacheDataList != null && !cacheDataList.isEmpty()) {
            allExps.addAll(cacheDataList);
        }
        if (rsmId != null && rsmId != 0L && cacheDataList != null) {
            ArrayList cacheIdList = Lists.newArrayListWithExpectedSize((int)cacheDataList.size());
            for (DynamicObject cacheData : cacheDataList) {
                long id = cacheData.getLong("id");
                if (id == 0L) continue;
                cacheIdList.add(id);
            }
            allExps.addAll(RsmLangAblHelper.findLangAbl(rsmId, cacheIdList.toArray()));
        }
        if (!allExps.isEmpty()) {
            return ResumeExpSortHelper.sortAllDy((List)allExps);
        }
        return Lists.newArrayListWithExpectedSize((int)49);
    }
}

