/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmExpCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmWorkExpHelper;

public class RsmPrjExpHelper {
    private static final Log LOG = LogFactory.getLog(RsmWorkExpHelper.class);
    private static final HRBaseServiceHelper PRJEXPHELPER = new HRBaseServiceHelper("tstpm_srrsmprjexp");

    private RsmPrjExpHelper() {
    }

    public static List<DynamicObject> findPrjExps(Long rsmId, Object[] excludeIds) {
        return RsmExpCommonHelper.findRsmExpDyList(rsmId, excludeIds, PRJEXPHELPER);
    }

    public static DynamicObject[] findPrjExps(Object[] ids) {
        return PRJEXPHELPER.loadDynamicObjectArray(new QFilter("id", "in", (Object)ids).toArray());
    }

    public static List<DynamicObject> getAllEduWorkSortList(Long rsmId, List<DynamicObject> cacheDataList) {
        ArrayList allExps = Lists.newArrayListWithExpectedSize((int)4);
        if (cacheDataList != null && !cacheDataList.isEmpty()) {
            allExps.addAll(cacheDataList);
        }
        if (rsmId != null && rsmId != 0L && cacheDataList != null) {
            ArrayList cacheIdList = Lists.newArrayListWithExpectedSize((int)cacheDataList.size());
            for (DynamicObject cacheData : cacheDataList) {
                long id = cacheData.getLong("id");
                if (id == 0L) continue;
                cacheIdList.add(id);
            }
            allExps.addAll(RsmPrjExpHelper.findPrjExps(rsmId, cacheIdList.toArray()));
        }
        if (!allExps.isEmpty()) {
            return ResumeExpSortHelper.sortRsmPrjExp((List)allExps);
        }
        return Lists.newArrayListWithExpectedSize((int)49);
    }

    public static void saveRsmPrjExp(List<DynamicObject> sortResults, Long rsmId, IPageCache pageCache) {
        if (sortResults == null || sortResults.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.required();){
            DynamicObject rsm = RsmHelper.findOne(rsmId);
            PRJEXPHELPER.save(sortResults.toArray(new DynamicObject[sortResults.size()]));
            RsmCommonHelper.executeUpdateExp(rsm, sortResults, "tstpm_srrsmprjexp", pageCache, false);
        }
    }

    public static void deletePrjExp(IPageCache pageCache, Long delPrjId, Long rsmId, String dataSource) {
        if (rsmId != null && rsmId != 0L && !"1".equals(dataSource)) {
            List<DynamicObject> prjExpList = RsmPrjExpHelper.findPrjExps(rsmId, new Object[]{delPrjId});
            DynamicObject[] delPrjExpArr = RsmPrjExpHelper.findPrjExps(new Object[]{delPrjId});
            if (delPrjExpArr != null && delPrjExpArr.length > 0) {
                try (TXHandle tx = TX.required();){
                    DynamicObject rsm = RsmHelper.findOne(rsmId);
                    ResumeUtilsHelper.getServiceHelper((String)"tstpm_srrsmprjexp").deleteOne((Object)delPrjId);
                    RsmCommonHelper.executeUpdateExp(rsm, prjExpList, "tstpm_srrsmprjexp", pageCache, true);
                }
            }
        } else {
            RsmHelper.deleteCacheData(pageCache, delPrjId, "tstpm_srrsmprjexp");
        }
    }
}

