/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmExpCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;

public class RsmWorkRelHelper {
    private static final Log logger = LogFactory.getLog(RsmWorkRelHelper.class);
    private static final HRBaseServiceHelper WORKRELSERVICEHELPER = new HRBaseServiceHelper("tstpm_srrsmworkrela");

    private RsmWorkRelHelper() {
    }

    public static List<DynamicObject> findWorkRel(Long rsmId, Object[] excludeIds) {
        return RsmExpCommonHelper.findRsmExpDyList(rsmId, excludeIds, WORKRELSERVICEHELPER);
    }

    public static DynamicObject[] findWorkRel(Object[] ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return WORKRELSERVICEHELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public static void saveRsmWorkRelation(List<DynamicObject> workRelSorts, Long rsmId, IPageCache pageCache) {
        if (workRelSorts == null || workRelSorts.isEmpty()) {
            return;
        }
        DynamicObject rsm = RsmHelper.findOne(rsmId);
        try (TXHandle tx = TX.required();){
            WORKRELSERVICEHELPER.save(workRelSorts.toArray(new DynamicObject[workRelSorts.size()]));
            RsmCommonHelper.executeUpdateExp(rsm, workRelSorts, "tstpm_srrsmworkrela", pageCache, false);
        }
    }

    public static void deleteWorkRel(IPageCache pageCache, Long deleteWorkRelId, Long rsmId, String dataSource) {
        if (rsmId != null && rsmId != 0L && !"1".equals(dataSource)) {
            List<DynamicObject> workRelList = RsmWorkRelHelper.findWorkRel(rsmId, new Object[]{deleteWorkRelId});
            DynamicObject[] delWorkRelArr = RsmWorkRelHelper.findWorkRel(new Object[]{deleteWorkRelId});
            if (delWorkRelArr != null && delWorkRelArr.length > 0) {
                DynamicObject rsm = RsmHelper.findOne(rsmId);
                try (TXHandle tx = TX.required();){
                    WORKRELSERVICEHELPER.deleteOne((Object)deleteWorkRelId);
                    RsmCommonHelper.executeUpdateExp(rsm, workRelList, "tstpm_srrsmworkrela", pageCache, true);
                }
            }
        } else {
            RsmHelper.deleteCacheData(pageCache, deleteWorkRelId, "tstpm_srrsmworkrela");
        }
    }

    public static List<DynamicObject> getAllWorkRelSortList(Long rsmId, List<DynamicObject> cacheDataList) {
        ArrayList allExps = Lists.newArrayListWithExpectedSize((int)4);
        if (cacheDataList != null && !cacheDataList.isEmpty()) {
            allExps.addAll(cacheDataList);
        }
        if (rsmId != null && rsmId != 0L && cacheDataList != null) {
            ArrayList cacheIdList = Lists.newArrayListWithExpectedSize((int)cacheDataList.size());
            for (DynamicObject cacheData : cacheDataList) {
                long id = cacheData.getLong("id");
                if (id == 0L) continue;
                cacheIdList.add(id);
            }
            allExps.addAll(RsmWorkRelHelper.findWorkRel(rsmId, cacheIdList.toArray()));
        }
        if (!allExps.isEmpty()) {
            return ResumeExpSortHelper.sortAllDy((List)allExps);
        }
        return Lists.newArrayListWithExpectedSize((int)49);
    }
}

