/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.helper.arf;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmExpCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;

public class ARFRsmEduExpHelper {
    private static final Log logger = LogFactory.getLog(ARFRsmEduExpHelper.class);
    public static final HRBaseServiceHelper EDUEXPSERVICEHELPER = new HRBaseServiceHelper("tstpm_arfrsmeduexp");

    private ARFRsmEduExpHelper() {
    }

    public static List<DynamicObject> findEduExps(Long rsmId, Object[] excludeIds) {
        return RsmExpCommonHelper.findRsmExpDyList(rsmId, excludeIds, EDUEXPSERVICEHELPER);
    }

    public static DynamicObject[] findEduExps(Object[] ids) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return EDUEXPSERVICEHELPER.loadDynamicObjectArray(qFilter.toArray());
    }

    public static void saveRsmEduExp(List<DynamicObject> eduExpSorts, Long rsmId, IPageCache pageCache) {
        if (eduExpSorts == null || eduExpSorts.isEmpty()) {
            return;
        }
        DynamicObject rsm = RsmHelper.findOne(rsmId);
        ResumeExpSortHelper.setHighestEduInfo((DynamicObject)eduExpSorts.get(0), (DynamicObject)rsm);
        try (TXHandle tx = TX.required();){
            EDUEXPSERVICEHELPER.save(eduExpSorts.toArray(new DynamicObject[eduExpSorts.size()]));
            RsmCommonHelper.executeUpdateExp(rsm, eduExpSorts, "tstpm_srrsmeduexp", pageCache, false);
        }
    }

    public static void deleteEduExp(IPageCache pageCache, Long deleteEduExpId, Long rsmId, String dataSource) {
        if (rsmId != null && rsmId != 0L && !"1".equals(dataSource)) {
            List<DynamicObject> eduExpList = ARFRsmEduExpHelper.findEduExps(rsmId, new Object[]{deleteEduExpId});
            DynamicObject[] delEduExpArr = ARFRsmEduExpHelper.findEduExps(new Object[]{deleteEduExpId});
            if (delEduExpArr != null && delEduExpArr.length > 0) {
                DynamicObject delEduExp = delEduExpArr[0];
                try (TXHandle tx = TX.required();){
                    DynamicObject rsm = RsmHelper.findOne(rsmId);
                    ARFRsmEduExpHelper.updateRsmAndEduExp(rsm, delEduExp, eduExpList);
                    EDUEXPSERVICEHELPER.deleteOne((Object)deleteEduExpId);
                    RsmCommonHelper.executeUpdateExp(rsm, eduExpList, "tstpm_srrsmeduexp", pageCache, true);
                }
            }
        } else {
            RsmHelper.deleteCacheData(pageCache, deleteEduExpId, "tstpm_srrsmeduexp");
        }
    }

    private static void updateRsmAndEduExp(DynamicObject rsm, DynamicObject delEduExp, List<DynamicObject> eduExpList) {
        if (delEduExp.getBoolean("ishighestedu")) {
            if (!eduExpList.isEmpty()) {
                eduExpList = ResumeExpSortHelper.sortRsmEduExp(eduExpList);
                ResumeExpSortHelper.setHighestEduInfo((DynamicObject)((DynamicObject)eduExpList.get(0)), (DynamicObject)rsm);
                EDUEXPSERVICEHELPER.update(eduExpList.toArray(new DynamicObject[eduExpList.size()]));
            } else {
                ResumeExpSortHelper.setHighestEduInfo(null, (DynamicObject)rsm);
            }
            RsmHelper.rsmServiceHelper.updateOne(rsm);
        }
    }

    public static List<DynamicObject> getAllEduExpSortList(Long rsmId, List<DynamicObject> cacheDataList) {
        ArrayList allExps = Lists.newArrayListWithExpectedSize((int)4);
        if (cacheDataList != null && !cacheDataList.isEmpty()) {
            allExps.addAll(cacheDataList);
        }
        if (rsmId != null && rsmId != 0L && cacheDataList != null) {
            ArrayList cacheIdList = Lists.newArrayListWithExpectedSize((int)cacheDataList.size());
            for (DynamicObject cacheData : cacheDataList) {
                long id = cacheData.getLong("id");
                if (id == 0L) continue;
                cacheIdList.add(id);
            }
            allExps.addAll(ARFRsmEduExpHelper.findEduExps(rsmId, cacheIdList.toArray()));
        }
        if (!allExps.isEmpty()) {
            return ResumeExpSortHelper.sortRsmEduExp((List)allExps);
        }
        return Lists.newArrayListWithExpectedSize((int)49);
    }
}

