/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.helper.arf;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmExpCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;

public class ARFRsmWorkExpHelper {
    private static final Log LOG = LogFactory.getLog(ARFRsmWorkExpHelper.class);
    private static final HRBaseServiceHelper WORKEXPHELPER = new HRBaseServiceHelper("tstpm_arfrsmworkexp");

    private ARFRsmWorkExpHelper() {
    }

    public static List<DynamicObject> findWorkExps(Long rsmId, Object[] excludeIds) {
        return RsmExpCommonHelper.findRsmExpDyList(rsmId, excludeIds, WORKEXPHELPER);
    }

    public static DynamicObject[] findWorkExps(Object[] ids) {
        return WORKEXPHELPER.loadDynamicObjectArray(new QFilter("id", "in", (Object)ids).toArray());
    }

    public static List<DynamicObject> getAllEduWorkSortList(Long rsmId, List<DynamicObject> cacheDataList) {
        ArrayList allExps = Lists.newArrayListWithExpectedSize((int)4);
        if (cacheDataList != null && !cacheDataList.isEmpty()) {
            allExps.addAll(cacheDataList);
        }
        if (rsmId != null && rsmId != 0L && cacheDataList != null) {
            ArrayList cacheIdList = Lists.newArrayListWithExpectedSize((int)cacheDataList.size());
            for (DynamicObject cacheData : cacheDataList) {
                long id = cacheData.getLong("id");
                if (id == 0L) continue;
                cacheIdList.add(id);
            }
            allExps.addAll(ARFRsmWorkExpHelper.findWorkExps(rsmId, cacheIdList.toArray()));
        }
        if (!allExps.isEmpty()) {
            return ResumeExpSortHelper.sortRsmWorkExp((List)allExps);
        }
        return Lists.newArrayListWithExpectedSize((int)49);
    }

    public static void saveRsmWorkExp(List<DynamicObject> sortResults, Long rsmId, IPageCache pageCache) {
        if (sortResults == null || sortResults.isEmpty()) {
            return;
        }
        DynamicObject rsm = RsmHelper.findOne(rsmId);
        ResumeExpSortHelper.setRecentWorkInfo((DynamicObject)sortResults.get(0), (DynamicObject)rsm);
        try (TXHandle tx = TX.required();){
            ResumeUtilsHelper.getServiceHelper((String)"tstpm_srrsmworkexp").save(sortResults.toArray(new DynamicObject[sortResults.size()]));
            RsmCommonHelper.executeUpdateExp(rsm, sortResults, "tstpm_srrsmworkexp", pageCache, false);
        }
    }

    public static void deleteWorkExp(IPageCache pageCache, Long deleteWorkId, Long rsmId, String dataSource) {
        if (rsmId != null && rsmId != 0L && !"1".equals(dataSource)) {
            ARFRsmWorkExpHelper.handleDeleteWorkExp(pageCache, deleteWorkId, rsmId);
        } else {
            RsmHelper.deleteCacheData(pageCache, deleteWorkId, "tstpm_srrsmworkexp");
        }
    }

    private static void handleDeleteWorkExp(IPageCache pageCache, Long deleteWorkId, Long rsmId) {
        List<DynamicObject> workExpList = ARFRsmWorkExpHelper.findWorkExps(rsmId, new Object[]{deleteWorkId});
        DynamicObject[] delWorkExpArr = ARFRsmWorkExpHelper.findWorkExps(new Object[]{deleteWorkId});
        if (delWorkExpArr != null && delWorkExpArr.length > 0) {
            DynamicObject delWorkExp = delWorkExpArr[0];
            DynamicObject rsm = RsmHelper.findOne(rsmId);
            try (TXHandle tx = TX.required();){
                ARFRsmWorkExpHelper.handleDeleteWorkExpUpdateRsm(delWorkExp, rsm, workExpList);
                ResumeUtilsHelper.getServiceHelper((String)"tstpm_srrsmworkexp").deleteOne((Object)deleteWorkId);
                RsmCommonHelper.executeUpdateExp(rsm, workExpList, "tstpm_srrsmworkexp", pageCache, true);
            }
        }
    }

    private static void handleDeleteWorkExpUpdateRsm(DynamicObject delWorkExp, DynamicObject rsm, List<DynamicObject> workExpList) {
        if (delWorkExp.getBoolean("isrecwork")) {
            if (workExpList != null && !workExpList.isEmpty()) {
                workExpList = ResumeExpSortHelper.sortRsmWorkExp(workExpList);
                ResumeExpSortHelper.setRecentWorkInfo((DynamicObject)((DynamicObject)workExpList.get(0)), (DynamicObject)rsm);
                ResumeUtilsHelper.getServiceHelper((String)"tstpm_srrsmworkexp").update(workExpList.toArray(new DynamicObject[workExpList.size()]));
            } else {
                ResumeExpSortHelper.setRecentWorkInfo(null, (DynamicObject)rsm);
            }
            RsmHelper.rsmServiceHelper.updateOne(rsm);
        }
    }
}

