/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.mhelper;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class RsmAppFileHelper {
    private static final HRBaseServiceHelper APPFILEDAO = ServiceHelperCache.getHrBaseServiceHelper((String)"tspr_appfile");

    private RsmAppFileHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static DynamicObject queryOneById(long id) {
        return RsmAppFileHelper.queryOneById(id, "");
    }

    public static DynamicObject queryOneById(long id, String queryProp) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject[] appfiles = RsmAppFileHelper.query(qFilter.toArray(), queryProp);
        if (null != appfiles && appfiles.length > 0) {
            return appfiles[0];
        }
        return null;
    }

    public static DynamicObject[] queryByIds(List<Long> ids) {
        return RsmAppFileHelper.queryByIds(ids, "");
    }

    public static DynamicObject[] queryByIds(List<Long> ids, String queryProp) {
        QFilter qFilter = new QFilter("id", "in", ids);
        return RsmAppFileHelper.query(qFilter.toArray(), queryProp);
    }

    public static DynamicObject findAppFileByRsmId(Long rsmId) {
        String queryProp = "id,name,number,isbinddelyrec,phone,email,jobstatus,birthday,highesteduschool,highesteducation,appres,deliveryrec,applytime,resacqmthd,recruchnlnm,highestspecialty";
        QFilter qFilter = new QFilter("appres", "=", (Object)rsmId);
        DynamicObject[] appFile = RsmAppFileHelper.query(qFilter.toArray(), queryProp);
        return null != appFile && appFile.length > 0 ? appFile[0] : null;
    }

    public static DynamicObject[] findAppFileByRsmId(List<Long> rsmIdList) {
        String queryProp = "id,name,number,isbinddelyrec,phone,email,jobstatus,birthday,highesteduschool,highesteducation,appres,deliveryrec,applytime,resacqmthd,recruchnlnm,highestspecialty";
        QFilter qFilter = new QFilter("appres", "in", rsmIdList);
        return RsmAppFileHelper.query(qFilter.toArray(), queryProp);
    }

    private static DynamicObject[] query(QFilter[] qFilters, String queryProp) {
        if (HRStringUtils.isNotEmpty((String)queryProp)) {
            return APPFILEDAO.query(queryProp, qFilters);
        }
        return APPFILEDAO.loadDynamicObjectArray(qFilters);
    }

    public static boolean appFileIsInProcess(long appFileId) {
        DynamicObject appFileDy = RsmAppFileHelper.queryOneById(appFileId, "filestatus");
        if (appFileDy == null) {
            return false;
        }
        return "A".equals(appFileDy.getString("filestatus"));
    }
}

