/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.tsc.tsrbd.business.domain.headtemplate.HeaderService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveAppFileResult;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.exception.TSCBizException;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeService;

public class AppFileMService {
    private static final Log LOG = LogFactory.getLog(AppFileMService.class);
    private static final String APPID = "tspr";
    private static final String SERVICENAME = "appFileService";

    public static void updateOne(DynamicObject appFile) {
        AppFileMService.saveOne(appFile);
    }

    public static void update(DynamicObject[] appfiles) {
        AppFileMService.save(appfiles);
    }

    public static void saveOne(DynamicObject appfile) {
        AppFileMService.save(new DynamicObject[]{appfile});
    }

    private AppFileMService() {
        throw new IllegalStateException("Utility class");
    }

    public static void save(DynamicObject[] appfiles) {
        try {
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"updateAppFiles", (Object[])new Object[]{Lists.newArrayList((Object[])appfiles)});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.updateAppFiles error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static void addRsmUpdateOpRecord(long appFileId) {
        try {
            ArrayList appFileIdList = Lists.newArrayListWithExpectedSize((int)1);
            appFileIdList.add(appFileId);
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"addRsmUpdateOpRecord", (Object[])new Object[]{appFileIdList, new HashMap(appFileIdList.size())});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.addRsmUpdateOpRecord error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static void addRsmUpdateOpRecord(DynamicObject[] appFiles, Map<String, List<Map<String, String>>> changeListMap) {
        try {
            List appFileIdList = Arrays.stream(appFiles).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"addRsmUpdateOpRecord", (Object[])new Object[]{Lists.newArrayList(appFileIdList), changeListMap});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.addRsmUpdateOpRecord error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static void addInviteRsmUpdateOpRecord(List<Long> appFileIdList) {
        try {
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"addInviteRsmUpdateOpRecord", (Object[])new Object[]{appFileIdList});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.addInviteRsmUpdateOpRecord error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static boolean hasEditRight(Long appFileId) {
        boolean hasEditRight;
        try {
            hasEditRight = (Boolean)DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"hasEditRight", (Object[])new Object[]{appFileId});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.hasEditRight error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
        return hasEditRight;
    }

    public static void mergeCandidate(long mergeToId, long mergeFromId) {
        try {
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"mergeCandidate", (Object[])new Object[]{mergeToId, mergeFromId});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.mergeCandidate error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static SaveAppFileResult saveAppFileOperation(DynamicObject appFile, DynamicObject position, AppResumeBo resumeBo) {
        SaveAppFileResult saveAppFileResult;
        try {
            saveAppFileResult = (SaveAppFileResult)DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"saveAppFile", (Object[])new Object[]{appFile, position, resumeBo});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.saveAppFile error", (Throwable)ex);
            throw ex;
        }
        return saveAppFileResult;
    }

    public static void eliminateAppFile(DynamicObject[] appFiles, String type, Long reasonId, Map<String, String> detailedReason) {
        try {
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"eliminateAppFile", (Object[])new Object[]{Lists.newArrayList((Object[])appFiles), type, reasonId, detailedReason});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.eliminateAppFile error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static DynamicObject getAppFileByStdRsmIdAndPositionId(Long stdRsmId, Long positionId, Date applyTime) {
        try {
            return (DynamicObject)DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"getAppFileByStdRsmIdAndPositionId", (Object[])new Object[]{stdRsmId, positionId, applyTime});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.getAppFileByStdRsmIdAndPositionId error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static void updateStdRsmInfo(Long stdRsmId, Map<String, String> stdRsmInfoMap) {
        try {
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"updateStdRsmInfo", (Object[])new Object[]{stdRsmId, stdRsmInfoMap});
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.updateStdRsmInfo error", (Throwable)ex);
            throw ex;
        }
    }

    public static void afterAppFileSaveHandle(SaveCandidateResult result, DynamicObject positionDt, AppResumeBo resumeBo) {
        AppFileMService.afterAppFileSaveHandle(result.getAppFileId(), result.getRsmId(), positionDt, resumeBo);
    }

    public static void afterAppFileSaveHandle(Long appFileId, Long rsmId, DynamicObject positionDt, AppResumeBo resumeBo) {
        if (positionDt != null) {
            AddResumeService.filterEliminateCandidate(appFileId, rsmId, positionDt.getLong("id"));
            LOG.info("AddCandidate afterHandlerOperation filterEliminateCandidate");
            AddResumeService.updatePositionCandidateNumber(positionDt);
            LOG.info("AddCandidate afterHandlerOperation updatePositionCandidateNumber");
        }
        Long stdRsmId = resumeBo.getRsm().getLong("stdrsm");
        AppFileMService.updateStdRsmInfo(appFileId, positionDt, resumeBo, stdRsmId);
    }

    private static void updateStdRsmInfo(Long appFileId, DynamicObject positionDt, AppResumeBo resumeBo, Long stdRsmId) {
        try {
            LOG.info("afterHandlerOperation.updateStdRsmInfo.start:{}", (Object)stdRsmId);
            HashMap stdRsmInfoMap = Maps.newHashMapWithExpectedSize((int)4);
            if (positionDt != null) {
                stdRsmInfoMap.put("position", positionDt.getString("id"));
                if (appFileId != null && appFileId != 0L) {
                    stdRsmInfoMap.put("appfile", String.valueOf(appFileId));
                }
            }
            Object recChannelObj = resumeBo.getDelivery().get("recruchnlnm");
            if (resumeBo.getDelivery().get("recruchnlnm") instanceof Long) {
                stdRsmInfoMap.put("recruchnlnm", ((Long)recChannelObj).toString());
            } else if (recChannelObj instanceof DynamicObject) {
                stdRsmInfoMap.put("recruchnlnm", ((DynamicObject)recChannelObj).getString("id"));
            }
            LOG.info("afterHandlerOperation.updateStdRsmInfo.info:{}", (Object)stdRsmInfoMap);
            AppFileMService.updateStdRsmInfo(stdRsmId, stdRsmInfoMap);
        }
        catch (Exception ex) {
            LOG.error("afterHandlerOperation.updateStdRsmInfo.error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
    }

    public static DynamicObject[] getAppFilesByStdRsmId(Long stdRsmId) {
        try {
            return (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"getAppFilesByStdRsmId", (Object[])new Object[]{stdRsmId});
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.getAppFilesByStdRsmId error", (Throwable)ex);
            throw ex;
        }
    }

    public static HeaderService getAppFileHeaderService(String type) {
        try {
            return (HeaderService)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tssrm", (String)"appFileDataServiceApi", (String)"getAppFileHeaderService", (Object[])new Object[]{type});
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.getAppFileHeaderService error", (Throwable)ex);
            throw ex;
        }
    }

    public static HeaderService getRscAppFileHeaderService(String type) {
        try {
            return (HeaderService)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tsrsc", (String)"appFileDataServiceApi", (String)"getAppFileHeaderService", (Object[])new Object[]{type});
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.getRscAppFileHeaderService error", (Throwable)ex);
            throw ex;
        }
    }

    public static void showAppFilePortraitForm(IFormView view, Long appFileId) {
        try {
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"showAppFilePortraitForm", (Object[])new Object[]{view, appFileId});
        }
        catch (RuntimeException ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.showAppFilePortraitForm error", (Throwable)ex);
            throw ex;
        }
    }

    public static DynamicObject queryAppfileById(Long appfileId, String properties) {
        DynamicObject appfile = null;
        try {
            appfile = (DynamicObject)DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"queryOne", (Object[])new Object[]{appfileId, properties});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.eliminateAppFile error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
        return appfile;
    }

    public static DynamicObject[] queryAppFileByFilter(QFilter qFilter, String properties) {
        DynamicObject[] appfile = null;
        try {
            appfile = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"queryAppFileByFilter", (Object[])new Object[]{qFilter, properties});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.eliminateAppFile error", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
        return appfile;
    }

    public static Map<String, Long> getAppFileByTpDataId(List<String> tpDataIdList) {
        HashMap<String, Long> resultMap = new HashMap(8);
        try {
            resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"tsc", (String)APPID, (String)SERVICENAME, (String)"getAppFileByTpdataid", (Object[])new Object[]{tpDataIdList});
        }
        catch (Exception ex) {
            LOG.error("AppFileMService=>tsc.tstpm.appFileService.saveAppFile getAppFileByTpdataid", (Throwable)ex);
            throw new TSCBizException((Throwable)ex);
        }
        return resultMap;
    }
}

