/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.common.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;

public class AILabelMsgHelper {
    private static final Log LOG = LogFactory.getLog(AILabelMsgHelper.class);
    private static final Map<String, String> GENDER_MAP = new HashMap<String, String>(3);
    private static final HRBaseServiceHelper[] BASIC_HELPER;
    private static final HRBaseServiceHelper[] EDU_HELPER;
    private static final HRBaseServiceHelper[] WORKEXP_HELPER;
    private static final HRBaseServiceHelper[] PRJEXP_HELPER;
    private static final HRBaseServiceHelper[] PATINV_HELPER;
    private static final HRBaseServiceHelper[] LANG_HELPER;
    private static final HRBaseServiceHelper[] CERT_HELPER;
    private static final HRBaseServiceHelper[] PROFSKL_HELPER;
    private static final String[] RSM_FIELD;
    private static final Long[] RSM_LABEL_TYPE;

    private AILabelMsgHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishMsg(Long rsmId, Integer type) {
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createSimplePublisher("tsc", "tsc.tspr.ailabel_queue");
            HashMap params = Maps.newHashMapWithExpectedSize((int)3);
            params.put("tagobjid", rsmId);
            params.put("data", SerializationUtils.toJsonString(AILabelMsgHelper.buildAILabelData(rsmId, type)));
            params.put("tagobjtypeid", RSM_LABEL_TYPE[type]);
            pub.publish((Object)params);
            LOG.info("AILabel.publish.success.tagObjId : {} tagObjType : {}", (Object)rsmId, (Object)type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishMsg(Long rsmId, Long eventId, Integer type) {
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createSimplePublisher("tsc", "tsc.tspr.ailabel_queue");
            HashMap params = Maps.newHashMapWithExpectedSize((int)3);
            params.put("tagobjid", rsmId);
            params.put("version", eventId);
            params.put("data", SerializationUtils.toJsonString(AILabelMsgHelper.buildAILabelData(rsmId, type)));
            params.put("tagobjtypeid", RSM_LABEL_TYPE[type]);
            pub.publish((Object)params);
            LOG.info("AILabel.publish.success.tagObjId : {} tagObjType : {}", (Object)rsmId, (Object)type);
        }
    }

    public static Map<String, Object> buildAILabelData(Long rsmId, Integer type) {
        HRBaseServiceHelper jobSkillDao;
        HRBaseServiceHelper certDao;
        HashMap dataMap = Maps.newHashMap();
        DynamicObject rsm = BASIC_HELPER[type].queryOne((Object)rsmId);
        dataMap.put("basics", AILabelMsgHelper.buildBasicData(rsm));
        QFilter[] qFilters = new QFilter[]{new QFilter(RSM_FIELD[type], "=", (Object)rsmId)};
        String queryEduProp = "startdate,endingdate,specialtyname,education.name,degree.name,schoolname.name,educationform.name";
        DynamicObjectCollection edus = EDU_HELPER[type].queryOriginalCollection(queryEduProp, qFilters);
        dataMap.put("educations", AILabelMsgHelper.buildEduData(edus));
        String queryWorkProp = "startdate,endingdate,companyname,positionname,underlingnumber,workresponsibility,workachievement";
        DynamicObjectCollection workExps = WORKEXP_HELPER[type].queryOriginalCollection(queryWorkProp, qFilters);
        dataMap.put("employments", AILabelMsgHelper.buildWorkExpData(workExps));
        String queryPrjExp = "startdate,endingdate,projectname,belongscompany,projectjob,projectdesc,projectresp";
        DynamicObjectCollection prjExps = PRJEXP_HELPER[type].queryOriginalCollection(queryPrjExp, qFilters);
        dataMap.put("projects", AILabelMsgHelper.buildProExpData(prjExps));
        HRBaseServiceHelper patInvsDao = PATINV_HELPER[type];
        if (null != patInvsDao) {
            DynamicObjectCollection patInvs = patInvsDao.queryOriginalCollection("patentname", qFilters);
            dataMap.put("achievements", AILabelMsgHelper.buildPatInvData(patInvs));
        }
        HashMap skillMap = Maps.newHashMapWithExpectedSize((int)3);
        HRBaseServiceHelper langDao = LANG_HELPER[type];
        if (null != langDao) {
            DynamicObjectCollection langs = langDao.queryOriginalCollection("languagename.name,listandspkabl.name,literacy.name", qFilters);
            skillMap.put("languages", AILabelMsgHelper.buildLangData(langs));
        }
        if (null != (certDao = CERT_HELPER[type])) {
            DynamicObjectCollection certs = certDao.queryOriginalCollection("awardname", qFilters);
            skillMap.put("certificates", AILabelMsgHelper.buildCertData(certs));
        }
        if (null != (jobSkillDao = PROFSKL_HELPER[type])) {
            DynamicObjectCollection jobSkills = jobSkillDao.queryOriginalCollection("skillname,mastery.name", qFilters);
            skillMap.put("job_skills", AILabelMsgHelper.buildJobSkillData(jobSkills));
        }
        dataMap.put("skills", skillMap);
        dataMap.put("raw_text", AILabelMsgHelper.buildRawTextData(rsm, workExps, prjExps));
        return dataMap;
    }

    private static Object buildJobSkillData(DynamicObjectCollection jobSkills) {
        ArrayList jobSkillData = Lists.newArrayListWithCapacity((int)jobSkills.size());
        for (DynamicObject jobSkill : jobSkills) {
            HashMap jobSkillMap = Maps.newHashMapWithExpectedSize((int)2);
            jobSkillMap.put("skill_name", jobSkill.getString("skillname"));
            jobSkillMap.put("skill_level", jobSkill.getString("mastery.name"));
            jobSkillData.add(jobSkillMap);
        }
        return jobSkillData;
    }

    private static Object buildCertData(DynamicObjectCollection certs) {
        ArrayList certNames = Lists.newArrayListWithCapacity((int)certs.size());
        for (DynamicObject cert : certs) {
            certNames.add(cert.getString("awardname"));
        }
        return certNames;
    }

    private static Object buildLangData(DynamicObjectCollection langs) {
        ArrayList langData = Lists.newArrayListWithCapacity((int)langs.size());
        for (DynamicObject lang : langs) {
            HashMap listenJobSkillMap = Maps.newHashMapWithExpectedSize((int)3);
            String languageName = lang.getString("languagename.name");
            listenJobSkillMap.put("name", languageName);
            listenJobSkillMap.put("prop", ResManager.loadKDString((String)"\u542c\u8bf4", (String)"AILabelMsgHelper_0", (String)"tsc-tstpm-business", (Object[])new Object[0]));
            listenJobSkillMap.put("level", lang.getString("listandspkabl.name"));
            langData.add(listenJobSkillMap);
            HashMap readJobSkillMap = Maps.newHashMapWithExpectedSize((int)3);
            readJobSkillMap.put("name", languageName);
            readJobSkillMap.put("prop", ResManager.loadKDString((String)"\u8bfb\u5199", (String)"AILabelMsgHelper_1", (String)"tsc-tstpm-business", (Object[])new Object[0]));
            readJobSkillMap.put("level", lang.getString("literacy.name"));
            langData.add(readJobSkillMap);
        }
        return langData;
    }

    private static Object buildPatInvData(DynamicObjectCollection patInvs) {
        HashMap patInvMap = Maps.newHashMapWithExpectedSize((int)1);
        ArrayList patInvNames = Lists.newArrayListWithCapacity((int)patInvs.size());
        for (DynamicObject patInv : patInvs) {
            patInvNames.add(patInv.getString("patentname"));
        }
        patInvMap.put("patents", patInvNames);
        return patInvMap;
    }

    private static Object buildProExpData(DynamicObjectCollection proExps) {
        ArrayList data = Lists.newArrayListWithCapacity((int)proExps.size());
        for (DynamicObject proExp : proExps) {
            HashMap row = Maps.newHashMap();
            String startDate = proExp.getString("startdate");
            if (HRStringUtils.isNotEmpty((String)startDate)) {
                startDate = startDate.substring(0, 7);
            }
            row.put("start_date", startDate);
            String endDate = proExp.getString("endingdate");
            if (HRStringUtils.isNotEmpty((String)endDate)) {
                endDate = endDate.substring(0, 7);
            }
            row.put("end_date", endDate);
            row.put("project_name", proExp.get("projectname"));
            row.put("project_company_name", proExp.get("belongscompany"));
            row.put("project_role", proExp.get("projectjob"));
            row.put("project_description", proExp.get("projectdesc"));
            row.put("project_work", proExp.get("projectresp"));
            data.add(row);
        }
        return data;
    }

    private static Object buildWorkExpData(DynamicObjectCollection workExps) {
        ArrayList workExpDataList = Lists.newArrayListWithCapacity((int)workExps.size());
        for (DynamicObject workExp : workExps) {
            HashMap eduData = Maps.newHashMap();
            eduData.put("company_name", workExp.getString("companyname"));
            String startDate = workExp.getString("startdate");
            if (HRStringUtils.isNotEmpty((String)startDate)) {
                startDate = startDate.substring(0, 7);
            }
            eduData.put("start_date", startDate);
            String endDate = workExp.getString("endingdate");
            if (HRStringUtils.isNotEmpty((String)endDate)) {
                endDate = endDate.substring(0, 7);
            }
            eduData.put("end_date", endDate);
            eduData.put("title", workExp.getString("positionname"));
            eduData.put("underling_number", workExp.getInt("underlingnumber"));
            workExpDataList.add(eduData);
        }
        return workExpDataList;
    }

    private static Object buildEduData(DynamicObjectCollection edus) {
        ArrayList eduDataList = Lists.newArrayListWithCapacity((int)edus.size());
        for (DynamicObject edu : edus) {
            HashMap eduData = Maps.newHashMap();
            String startDate = edu.getString("startdate");
            if (HRStringUtils.isNotEmpty((String)startDate)) {
                startDate = startDate.substring(0, 7);
            }
            eduData.put("start_date", startDate);
            String endDate = edu.getString("endingdate");
            if (HRStringUtils.isNotEmpty((String)endDate)) {
                endDate = endDate.substring(0, 7);
            }
            eduData.put("end_date", endDate);
            String specialtyname = edu.getString("specialtyname");
            ArrayList<String> specialtynames = new ArrayList<String>(1);
            if (null != specialtyname) {
                specialtynames.add(specialtyname);
                eduData.put("major_name", specialtynames);
            }
            eduData.put("education", edu.getString("education.name"));
            String degree = edu.getString("degree.name");
            ArrayList<String> degrees = new ArrayList<String>(1);
            if (null != degree) {
                degrees.add(degree);
                eduData.put("degree", degrees);
            }
            eduData.put("school_name", edu.getString("schoolname.name"));
            eduData.put("education_form", edu.getString("educationform.name"));
            eduDataList.add(eduData);
        }
        return eduDataList;
    }

    private static Map<String, Object> buildBasicData(DynamicObject rsm) {
        DynamicObject nationObj;
        HashMap basicData = Maps.newHashMap();
        String birthday = rsm.getString("birthday");
        if (HRStringUtils.isNotEmpty((String)birthday)) {
            birthday = birthday.substring(0, 10);
        }
        basicData.put("age", rsm.getInt("age"));
        DynamicObject natreg = rsm.getDynamicObject("natreg");
        if (null != natreg) {
            basicData.put("nationality", natreg.getString("name"));
        }
        if (null != (nationObj = rsm.getDynamicObject("nation"))) {
            basicData.put("nation", nationObj.getString("name"));
        }
        basicData.put("gender", GENDER_MAP.get(rsm.getString("gender")));
        String nativePlaceId = rsm.getString("nativeplace");
        basicData.put("native_place", ORMUtil.getAdminDivisionFullName((String)nativePlaceId));
        DynamicObject politicalObj = rsm.getDynamicObject("politicsstatus");
        if (null != politicalObj) {
            basicData.put("political_status", politicalObj.getString("name"));
        }
        String startWorkTime = rsm.getString("partwt");
        Float duration = null;
        if (HRStringUtils.isNotEmpty((String)startWorkTime)) {
            String partwt = startWorkTime.substring(0, 10);
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate partwtDate = LocalDate.parse(partwt, dateTimeFormatter);
            long months = ChronoUnit.MONTHS.between(partwtDate, LocalDate.now());
            float years = (float)months / 12.0f;
            BigDecimal bigDecimal = BigDecimal.valueOf(years);
            duration = Float.valueOf(bigDecimal.setScale(1, 4).floatValue());
            startWorkTime = startWorkTime.substring(0, 7);
        }
        basicData.put("total_work_duration", duration);
        basicData.put("start_work_time", startWorkTime);
        return basicData;
    }

    private static Object buildRawTextData(DynamicObject rsm, DynamicObjectCollection workExps, DynamicObjectCollection prjExps) {
        StringBuilder rawTextDataStr = new StringBuilder(rsm.getString("selfevaluation"));
        rawTextDataStr.append('\u3002');
        for (DynamicObject workExp : workExps) {
            rawTextDataStr.append(workExp.getString("workresponsibility"));
            rawTextDataStr.append('\u3002');
            rawTextDataStr.append(workExp.getString("workachievement"));
            rawTextDataStr.append('\u3002');
        }
        for (DynamicObject prjExp : prjExps) {
            rawTextDataStr.append(prjExp.getString("projectresp"));
            rawTextDataStr.append('\u3002');
            rawTextDataStr.append(prjExp.getString("projectdesc"));
            rawTextDataStr.append('\u3002');
        }
        return rawTextDataStr;
    }

    static {
        GENDER_MAP.put("0", "\u7537");
        GENDER_MAP.put("1", "\u5973");
        GENDER_MAP.put("2", "\u672a\u77e5");
        BASIC_HELPER = new HRBaseServiceHelper[]{new HRBaseServiceHelper("tstpm_srrsm"), new HRBaseServiceHelper("tstpm_stdrsm")};
        EDU_HELPER = new HRBaseServiceHelper[]{new HRBaseServiceHelper("tstpm_srrsmeduexp"), new HRBaseServiceHelper("tstpm_stdeduexp")};
        WORKEXP_HELPER = new HRBaseServiceHelper[]{new HRBaseServiceHelper("tstpm_srrsmworkexp"), new HRBaseServiceHelper("tstpm_stdworkexp")};
        PRJEXP_HELPER = new HRBaseServiceHelper[]{new HRBaseServiceHelper("tstpm_srrsmprjexp"), new HRBaseServiceHelper("tstpm_stdprjexp")};
        PATINV_HELPER = new HRBaseServiceHelper[]{new HRBaseServiceHelper("tstpm_srrsmpatinv"), null};
        LANG_HELPER = new HRBaseServiceHelper[]{new HRBaseServiceHelper("tstpm_srrsmlangabl"), new HRBaseServiceHelper("tstpm_stdlangabl")};
        CERT_HELPER = new HRBaseServiceHelper[]{new HRBaseServiceHelper("tstpm_srrsmawrhon"), null};
        PROFSKL_HELPER = new HRBaseServiceHelper[]{new HRBaseServiceHelper("tstpm_srrsmproskl"), null};
        RSM_FIELD = new String[]{"rsm", "stdrsm"};
        RSM_LABEL_TYPE = new Long[]{LabelTagObjTypeEnum.OUT_RESUME.getId(), LabelTagObjTypeEnum.OUT_STDRSM.getId()};
    }
}

