/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.rsmupdate.service;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tstpm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;

public class RsmInviteUpdateService {
    private static final Log logger = LogFactory.getLog(RsmInviteUpdateService.class);

    private RsmInviteUpdateService() {
    }

    public static void setDataModel(IFormView view, DynamicObject rsmDy) {
        IDataModel model = view.getModel();
        model.setValue("objtype", (Object)"rsm");
        if (null != rsmDy) {
            String name = rsmDy.getString("fullname");
            model.setValue("fullname", (Object)name);
            model.setValue("objId", rsmDy.get("id"));
        }
    }

    public static void submitAndSendEmail(IFormView view, ConfirmCallBackListener confirmCallBackListener) {
        logger.info("RsmInviteUpdateHelper.submitAndSendEmail.begin");
        String tempPageId = view.getPageCache().get("temp_pageid");
        IFormView tempView = view.getView(tempPageId);
        OperateOption operateOption = RsmInviteUpdateService.buildOperateOption(view);
        OperationResult operationResult = tempView.invokeOperation("sendMessage", operateOption);
        view.sendFormAction(tempView);
        if (operationResult.isSuccess()) {
            view.showMessage(SrRsmKDString.sendSuccess(), MessageTypes.Commit, confirmCallBackListener);
            Long objId = view.getModel().getDataEntity().getLong("objId");
            logger.info("RsmInviteUpdateHelper.submitAndSendEmail.objId:{}", (Object)objId);
            AppResumeBo appResumeBo = ResumeBoHelper.getAppResumeBo(objId);
            if (appResumeBo != null) {
                logger.info("RsmInviteUpdateHelper.submitAndSendEmail.appResumeBo is not null");
                long appFileId = appResumeBo.getRsm().getLong("appfile");
                if (appFileId != 0L) {
                    logger.info("RsmInviteUpdateHelper.submitAndSendEmail.addInviteRsmUpdateOpRecord");
                    AppFileMService.addInviteRsmUpdateOpRecord(Collections.singletonList(appFileId));
                }
            }
        } else {
            view.showSuccessNotification(operationResult.getMessage());
            operationResult.setShowMessage(false);
        }
        logger.info("RsmInviteUpdateHelper.submitAndSendEmail.end");
    }

    private static OperateOption buildOperateOption(IFormView view) {
        Long objId = view.getModel().getDataEntity().getLong("objId");
        String selectProp = "id,fullname,phone,email,appfile";
        DynamicObject[] rsmDyArr = RsmHelper.findRsmById(objId, selectProp);
        DynamicObject rsmDy = rsmDyArr[0];
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("fullname", rsmDy.getString("fullname"));
        operateOption.setVariableValue("phone", RsmInviteUpdateService.formatPhone(rsmDy.getString("phone")));
        operateOption.setVariableValue("email", rsmDy.getString("email"));
        return operateOption;
    }

    public static Map<String, Object> initOpenMsgTempFormParams(DynamicObject rsmDy, String linkUrl) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)0);
        params.put("msgSceneType", CfgMsgScenes.RSM_UPDATE_RESUME.getBaseDataId());
        params.put("msgReceiverType", CfgMsgRecvType.CANDIDATE.getBaseDataId());
        String name = rsmDy.getString("fullname");
        params.put("candidatename", name);
        long appFileId = rsmDy.getLong("appfile");
        DynamicObject appFileDy = RsmAppFileHelper.queryOneById(appFileId, "position.adminorg");
        DynamicObject positionDy = appFileDy.getDynamicObject("position");
        String companyName = positionDy.getDynamicObject("adminorg").getString("name");
        params.put("companyname", companyName);
        params.put("departmentname", "");
        String positionName = positionDy.getString("name");
        params.put("positionname", positionName);
        params.put("resumeurl", linkUrl);
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date validTime = HRDateTimeUtils.addDay((Date)nowTime, (long)7L);
        String validTimeStr = HRDateTimeUtils.format((Date)validTime);
        params.put("resumevalidtime", validTimeStr);
        RequestContext requestContext = RequestContext.get();
        String operatorName = requestContext.getUserName();
        params.put("operatorname", operatorName);
        Map userInfoMap = UserServiceHelper.getUserInfoByID((long)requestContext.getCurrUserId());
        String email = (String)userInfoMap.get("email");
        params.put("operatoremail", email);
        String phone = rsmDy.getString("phone");
        params.put("phone", RsmInviteUpdateService.formatPhone(phone));
        params.put("email", rsmDy.getString("email"));
        params.put("yunzhijia", requestContext.getCurrUserId());
        params.put("channelchangeaction", "channelchange");
        params.put("resumeurlname", SrRsmKDString.updateRsm());
        return params;
    }

    private static String formatPhone(String phone) {
        int index;
        if (HRStringUtils.isNotEmpty((String)phone) && (index = phone.indexOf(45)) >= 0) {
            phone = phone.substring(index + 1);
        }
        return phone;
    }
}

