/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.rsmupdate.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;
import kd.tsc.tstpm.business.domain.rsm.rsmupdate.service.InviteUpdateService;
import kd.tsc.tstpm.business.domain.rsm.rsmupdate.service.RsmUpdateService;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;

public class RsmUpdateMainService {
    private static final Log LOG = LogFactory.getLog(RsmUpdateMainService.class);

    private RsmUpdateMainService() {
    }

    public static void validToken(IFormView view) {
        LOG.info("RsmUpdateMainHelper.afterBindData.validToken");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String token = (String)formShowParameter.getCustomParam("id");
        String formId = "tstpm_srrsmupdate";
        Map paramMap = null;
        OperationStatus operationStatus = OperationStatus.ADDNEW;
        if (HRStringUtils.isNotEmpty((String)token)) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            String key = InviteUpdateService.getTokenCacheKey(token);
            String cacheStr = (String)cache.get(key);
            LOG.info("RsmUpdateMainHelper.afterBindData.cacheStr{}", (Object)cacheStr);
            if (HRStringUtils.isNotEmpty((String)cacheStr)) {
                JSONObject cacheJson = JSON.parseObject((String)cacheStr);
                String updateStatus = cacheJson.getString("updatestatus");
                if (updateStatus.equals("1")) {
                    LOG.info("RsmUpdateMainHelper.afterBindData.updateStatus=1");
                    operationStatus = OperationStatus.VIEW;
                }
                long validTime = RsmUpdateService.getUrlValidTime(cacheJson);
                LOG.info("RsmUpdateMainHelper.afterBindData.validTime{}", (Object)validTime);
                if (validTime <= 0L) {
                    formId = "tstpm_srlinkinvalid";
                    cache.remove(key);
                    cache.remove(InviteUpdateService.getObjCacheKey(token));
                }
                paramMap = cacheJson.getInnerMap();
                paramMap.put("id", token);
                String positionId = (String)formShowParameter.getCustomParam("positionid");
                paramMap.put("positionid", positionId);
                RsmUpdateMainService.changeTitleDesc(cacheJson, view);
            } else {
                formId = "tstpm_srlinkinvalid";
            }
        } else {
            formId = "tstpm_srlinkinvalid";
        }
        FormShowParameter showParameter = FormShowHelper.createFormShowParameter((String)formId, (String)"panelmaincontent", (ShowType)ShowType.InContainer, paramMap);
        showParameter.setStatus(operationStatus);
        view.showForm(showParameter);
    }

    private static void changeTitleDesc(JSONObject cacheJson, IFormView view) {
        String objType = cacheJson.getString("objtype");
        if ("stdrsmdeliver".equals(objType)) {
            Label label = (Label)view.getControl("labelap");
            label.setText(SrRsmKDString.inviteDeliverDesc());
        }
    }
}

