/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.rsmupdate.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.common.constants.rsm.ResumeConstants;
import kd.tsc.tsrbs.business.domain.common.service.FormShowHelper;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInfo;
import kd.tsc.tsrbs.business.domain.rsm.service.AddResumeBizServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeExpSortHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.rsmupdate.service.InviteUpdateService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;

public class RsmUpdateService {
    private static final Log LOG = LogFactory.getLog(RsmUpdateService.class);
    private static final String[] KEY_PREINFO_FIELDS = new String[]{"fullname", "gender", "natreg", "birthday", "partwt", "jobstatus", "isrelationwork", "nation", "rgstprmtrsd", "politicsstatus", "nativeplace", "phone", "email", "isrelationwork"};
    private static final String[] KEY_JOBINTENTIONINFO_FIELDS = new String[]{"expccity", "expcfunction", "iscompemp", "accplacechange"};
    private static AddResumeBizServiceHelper addResumeBizServiceHelper = AddResumeBizServiceHelper.getInstance();

    private RsmUpdateService() {
    }

    public static void initRsmData(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        IDataModel model = view.getModel();
        long objId = (Long)parameter.getCustomParam("objId");
        String token = (String)parameter.getCustomParam("id");
        if (view.getFormShowParameter().getStatusValue() == OperationStatus.VIEW.getValue()) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            String appResumeBoStr = (String)cache.get(InviteUpdateService.getObjCacheKey(token));
            AppResumeBo appResumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)appResumeBoStr);
            appResumeBo = ResumeUtilsHelper.copyResumeBo((AppResumeBo)appResumeBo);
            DynamicObject rsmDy = appResumeBo.getRsm();
            ResumeUtilsHelper.copyObj((DynamicObject)rsmDy, (DynamicObject)model.getDataEntity(), (Set)Sets.newHashSet((Object[])new String[]{"number"}));
            RsmUpdateService.handleWorkyearShow(rsmDy, view);
            IPageCache pageCache = view.getPageCache();
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srrsmeduexp", (List)appResumeBo.getEntryList("tstpm_srrsmeduexp"));
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srrsmworkexp", (List)appResumeBo.getEntryList("tstpm_srrsmworkexp"));
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srrsmprjexp", (List)appResumeBo.getEntryList("tstpm_srrsmprjexp"));
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srrsmworkrela", (List)appResumeBo.getEntryList("tstpm_srrsmworkrela"));
            ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)"tstpm_srrsmlangabl", (List)appResumeBo.getEntryList("tstpm_srrsmlangabl"));
        }
        model.getDataEntity().set("id", (Object)objId);
    }

    private static void handleWorkyearShow(DynamicObject objDy, IFormView view) {
        int workMonths = objDy.getInt("workingyears");
        RsmCommonHelper.setShowWorkYears(workMonths, view);
    }

    public static void loadChildPage(IFormView view) {
        RsmUpdateService.loadRsmUpdateHeadPage(view);
        RsmUpdateService.reloadExpList(view);
    }

    private static void reloadExpList(IFormView view) {
        RsmUpdateService.reloadRsmExpView("tstpm_srrsmupdateworkrela", "flexpanelcontent_workrela", view);
        RsmUpdateService.reloadRsmExpView("tstpm_srrsmupdateeduexp", "flexpanelcontent_eduexp", view);
        RsmUpdateService.reloadRsmExpView("tstpm_srrsmupdatelangabl", "flexpanelcontent_langexp", view);
        RsmUpdateService.reloadRsmExpView("tstpm_srrsmupdateworkexp", "flexpanelcontent_workexp", view);
        RsmUpdateService.reloadRsmExpView("tstpm_srrsmupdateprjexp", "flexpanelcontent_prjexp", view);
    }

    public static void loadAnchor(IFormView view, String preInfoPanelKey) {
        AnchorControl anchorControl = (AnchorControl)view.getControl("anchorrsmupdate");
        anchorControl.setHighlight(true);
        anchorControl.addItems((List)Lists.newArrayList((Object[])new AnchorItems[]{new AnchorItems(preInfoPanelKey, SrRsmKDString.baseInfo(), null), new AnchorItems("anchor_jobintention", SrRsmKDString.jobIntentionExp(), null), new AnchorItems("anchor_workrelaexp", SrRsmKDString.workRelaExp(), null), new AnchorItems("anchor_eduexp", SrRsmKDString.eduExp(), null), new AnchorItems("anchor_langexp", SrRsmKDString.langAblExp(), null), new AnchorItems("anchor_workexp", SrRsmKDString.workExp(), null), new AnchorItems("anchor_prjexp", SrRsmKDString.prjExp(), null), new AnchorItems("anchor_self", SrRsmKDString.selfDesc(), null)}));
    }

    public static void reloadRsmExpView(String pageKey, String containerKey, IFormView view) {
        ListShowParameter expShowParameter = FormShowHelper.createListFormShowParameter((String)"tstpm_list_rsm", (String)containerKey, (String)pageKey, (ShowType)ShowType.InContainer, null);
        expShowParameter.setStatus(view.getFormShowParameter().getStatus());
        view.showForm((FormShowParameter)expShowParameter);
    }

    private static void loadRsmUpdateHeadPage(IFormView view) {
        FormShowParameter showParameter = FormShowHelper.createFormShowParameter((String)"tstpm_srrsmupdatehead", (String)"panel_rsmupdatehead", (ShowType)ShowType.InContainer, null);
        showParameter.setStatus(view.getFormShowParameter().getStatus());
        view.showForm(showParameter);
        IPageCache pageCache = view.getPageCache();
        pageCache.put("panel_rsmupdatehead", showParameter.getPageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleAfterUpload(UploadEvent evt, IFormView view, ConfirmCallBackListener confirmCallBackListener) {
        view.showLoading(new LocaleString(SrRsmKDString.pleaseWait()));
        try {
            Object[] urls = evt.getUrls();
            String resumeUrl = urls[0].toString();
            view.getPageCache().put("cache_resume_url", resumeUrl);
            view.showConfirm(SrRsmKDString.coverResumeConfirm(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
            LOG.info("RsmUpdateHelper.handleAfterUpload,resumeUrl{}", (Object)resumeUrl);
        }
        finally {
            view.hideLoading();
        }
    }

    public static void confirmUploadResume(IFormView view) {
        String resumeUrl = view.getPageCache().get("cache_resume_url");
        ResumeInfo resumeInfo = addResumeBizServiceHelper.getInputStreamByResumeUrl(resumeUrl);
        if (resumeInfo.getResultStatus() != 200) {
            view.showTipNotification(resumeInfo.getResult());
        } else {
            RsmUpdateService.refreshModelData(view, resumeInfo);
        }
    }

    private static void refreshModelData(IFormView view, ResumeInfo resumeInfo) {
        if (resumeInfo.getResultStatus() == 200) {
            DynamicObject rsm = addResumeBizServiceHelper.generateResumeInfo(resumeInfo);
            AppResumeBo resumeBo = new AppResumeBo(rsm);
            addResumeBizServiceHelper.loadExpEntity(resumeInfo, resumeBo);
            DynamicObject modelDy = view.getModel().getDataEntity();
            ResumeUtilsHelper.copyObj((DynamicObject)rsm, (DynamicObject)modelDy, (Set)Sets.newHashSet((Object[])new String[]{"id", "number", "appfile", "delivery", "stdrsm", "rsmsource", "createtime", "creator"}));
            RsmUpdateService.handleWorkyearShow(rsm, view);
            IPageCache pageCache = view.getPageCache();
            for (String subPage : ResumeConstants.SUBPAGES) {
                pageCache.remove(subPage);
                ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)subPage, (List)resumeBo.getEntryList(subPage));
            }
            view.updateView();
        } else {
            view.showTipNotification(SrRsmKDString.resultAnaFail());
        }
    }

    public static void loadLocalRsmFile(IFormView view, ConfirmCallBackListener confirmCallBackListener) {
        view.showConfirm(SrRsmKDString.coverResumeConfirm(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
    }

    public static void confirmUploadLocalResume(IFormView view) {
        view.showLoading(new LocaleString(SrRsmKDString.pleaseWait()));
        try {
            ResumeInfo resumeInfo = addResumeBizServiceHelper.getLocalJsonResume();
            if (resumeInfo.getResultStatus() != 200) {
                view.showTipNotification(resumeInfo.getResult());
            } else {
                RsmUpdateService.refreshModelData(view, resumeInfo);
            }
        }
        finally {
            view.hideLoading();
        }
    }

    public static void setRsmUpdateHeadDisplay(IFormView view, boolean show) {
        view.setVisible(Boolean.valueOf(show), new String[]{"panel_rsmupdatehead"});
        view.setVisible(Boolean.valueOf(!show), new String[]{"panel_perinfo", "panel_contactinfo"});
    }

    public static void cacheDataModel(IPageCache pageCache, String cacheKey, DynamicObject dy) {
        String cacheStr = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{dy}, (DynamicObjectType)dy.getDynamicObjectType());
        pageCache.put(cacheKey, cacheStr);
    }

    public static DynamicObject getCacheDataModel(IPageCache pageCache, String cacheKey, DynamicObjectType type) {
        ArrayList dyList;
        String cacheStr = pageCache.get(cacheKey);
        if (HRStringUtils.isNotEmpty((String)cacheStr) && (dyList = Lists.newArrayList((Object[])DynamicObjectSerializeUtil.deserialize((String)cacheStr, (DynamicObjectType)type))) != null && !dyList.isEmpty()) {
            return (DynamicObject)dyList.get(0);
        }
        return null;
    }

    public static void showBaseForm(String pageKey, Long pkId, String caption, CloseCallBack closeCallBack, IFormView view) {
        BaseShowParameter showParameter = FormShowHelper.createBaseFormShowParameter((String)pageKey, null, (ShowType)ShowType.Modal, null);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setStatus(OperationStatus.ADDNEW);
        if (HRStringUtils.isNotEmpty((String)caption)) {
            showParameter.setCaption(caption);
        }
        if (pkId != null) {
            showParameter.setPkId((Object)pkId);
        }
        view.showForm((FormShowParameter)showParameter);
    }

    public static void refreshHeadPage(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String headPageId = pageCache.get("panel_rsmupdatehead");
        IFormView headPageView = view.getView(headPageId);
        headPageView.invokeOperation("refresh");
        view.sendFormAction(headPageView);
    }

    public static boolean validData(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String tips = RsmCommonHelper.checkMustInput(dataEntity, view);
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = RsmCommonHelper.checkAdminDivision(dataEntity, view);
        }
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = RsmCommonHelper.checkPhoneEmail(dataEntity, view, "phone", "email");
        }
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = RsmCommonHelper.validPhoneEmail(dataEntity, view);
        }
        if (HRStringUtils.isNotEmpty((String)tips)) {
            view.showTipNotification(tips);
            return false;
        }
        return true;
    }

    public static void submitData(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        DynamicObject dataEntity = view.getModel().getDataEntity();
        LOG.info("RsmUpdateService.submitData.dataEntityPhoto={}", (Object)dataEntity.getString("photo"));
        AppResumeBo resumeBo = new AppResumeBo(dataEntity);
        RsmService.handlerRsmExpInfo(resumeBo, view.getPageCache());
        RsmUpdateService.submitData(resumeBo, parameter);
        RsmUpdateService.setUpdateStatus(view, "1");
        LOG.info("RsmUpdateService.submitData.setUpdateStatus Success");
        String token = (String)parameter.getCustomParam("id");
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        cache.put(InviteUpdateService.getObjCacheKey(token), (Object)SerializationUtils.serializeToBase64((Object)resumeBo), 604800);
    }

    private static void submitData(AppResumeBo resumeBo, FormShowParameter parameter) {
        String objType = (String)parameter.getCustomParam("objtype");
        if ("rsm".equals(objType)) {
            AddResumeHandleService.rsmUpdate(resumeBo);
        } else if ("stdrsm".equals(objType)) {
            AddResumeHandleService.stdRsmUpdate(resumeBo);
        } else if ("stdrsmdeliver".equals(objType)) {
            Long positionId = Long.parseLong((String)parameter.getCustomParam("positionid"));
            AddResumeHandleService.stdRsmDeliver(resumeBo, positionId);
        }
    }

    public static void handlerBirthdayChange(Date birthday, IFormView view) {
        IDataModel model = view.getModel();
        model.beginInit();
        if (birthday != null) {
            model.setValue("age", (Object)ResumeAnalysisHelper.calculateAge((Date)birthday));
        } else {
            model.setValue("age", null);
        }
        model.setValue("propbirthday", (Object)birthday);
        model.endInit();
        view.updateView("age");
    }

    public static void setUpdateStatus(IFormView view, String status) {
        String token = (String)view.getFormShowParameter().getCustomParam("id");
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String key = InviteUpdateService.getTokenCacheKey(token);
        String cacheStr = (String)cache.get(key);
        LOG.info("RsmUpdateService.submitData.setUpdateStatus.cacheStr{}", (Object)cacheStr);
        if (HRStringUtils.isNotEmpty((String)cacheStr)) {
            JSONObject cacheJson = JSON.parseObject((String)cacheStr);
            cacheJson.put("updatestatus", (Object)status);
            cache.put(key, (Object)cacheJson.toJSONString(), 604800);
        }
    }

    public static long getUrlValidTime(JSONObject cacheJson) {
        LOG.info("RsmUpdateService.getUrlValidTime.cacheJson:{}", (Object)cacheJson);
        Date sendTime = cacheJson.getDate("sendtime");
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        long dateDiff = HRDateTimeUtils.dateDiff((Date)sendTime, (Date)now);
        LOG.info("RsmUpdateService.getUrlValidTime.times:{}", (Object)dateDiff);
        long validTime = (long)InviteUpdateService.getValidityTime(7) - dateDiff / 1000L;
        LOG.info("RsmUpdateService.getUrlValidTime.validTimeTimes:{}", (Object)validTime);
        return validTime;
    }

    public static void removePageCache(IFormView view, String cacheKey) {
        IPageCache pageCache = view.getPageCache();
        pageCache.remove(cacheKey + view.getEntityId());
        pageCache.remove(cacheKey);
    }

    public static void editSelfButtonClick(IFormView view, Boolean aTrue) {
        view.setEnable(aTrue, new String[]{"selfevaluation"});
        view.setVisible(Boolean.valueOf(aTrue == false), new String[]{"bar_selfedit"});
        view.setVisible(aTrue, new String[]{"bar_selfcancel", "bar_selfsave"});
    }

    public static void editPreInfoButtonClick(IFormView view, Boolean enable) {
        view.setEnable(enable, KEY_PREINFO_FIELDS);
        view.setVisible(Boolean.valueOf(enable == false), new String[]{"bar_peredit"});
        view.setVisible(enable, new String[]{"bar_percancel", "bar_persave"});
    }

    public static void editJobIntentionInfoButtonClick(IFormView view, Boolean enable) {
        view.setEnable(enable, KEY_JOBINTENTIONINFO_FIELDS);
        view.setVisible(Boolean.valueOf(enable == false), new String[]{"bar_jobintentionedit"});
        view.setVisible(enable, new String[]{"bar_jobintentioncancel", "bar_jobintentionsave"});
    }

    public static void setParentModelData(List<DynamicObject> expSorts, DynamicObject rsmDy, String entityName) {
        switch (entityName) {
            case "tstpm_srrsmeduexp": {
                RsmUpdateService.setHighestEduInfo(expSorts, rsmDy);
                break;
            }
            case "tstpm_srrsmworkexp": {
                RsmUpdateService.setRecentWorkInfo(expSorts, rsmDy);
                break;
            }
        }
    }

    private static void setRecentWorkInfo(List<DynamicObject> expSorts, DynamicObject rsmDy) {
        DynamicObject workExpDy = null;
        for (int i = 0; i < expSorts.size(); ++i) {
            if (!expSorts.get(i).getBoolean("isrecwork")) continue;
            workExpDy = expSorts.get(i);
            break;
        }
        ResumeExpSortHelper.setRecentWorkInfo(workExpDy, (DynamicObject)rsmDy);
    }

    private static void setHighestEduInfo(List<DynamicObject> expSorts, DynamicObject rsmDy) {
        DynamicObject eduExp = null;
        for (int i = 0; i < expSorts.size(); ++i) {
            if (!expSorts.get(i).getBoolean("ishighestedu")) continue;
            eduExp = expSorts.get(i);
            break;
        }
        ResumeExpSortHelper.setHighestEduInfo(eduExp, (DynamicObject)rsmDy);
    }

    public static void resetPreInfo(IFormView view) {
        DynamicObject newDy = view.getModel().getDataEntity();
        DynamicObject oldDy = RsmUpdateService.getCacheDataModel(view.getPageCache(), "panel_perinfo", newDy.getDynamicObjectType());
        if (null != oldDy) {
            HashSet<String> jobIntentionSet = new HashSet<String>(Arrays.asList(KEY_JOBINTENTIONINFO_FIELDS));
            jobIntentionSet.add("selfevaluation");
            ResumeUtilsHelper.copyObj((DynamicObject)oldDy, (DynamicObject)newDy, jobIntentionSet);
            Object nativePlace = oldDy.get("nativeplace");
            Object rgstprmtrsd = oldDy.get("rgstprmtrsd");
            newDy.set("nativeplace", (Object)Objects.toString(nativePlace, null));
            newDy.set("rgstprmtrsd", (Object)Objects.toString(rgstprmtrsd, null));
            view.updateView("panel_perinfo");
            RsmUpdateService.refreshHeadPage(view);
            RsmUpdateService.editPreInfoButtonClick(view, Boolean.FALSE);
            RsmUpdateService.removePageCache(view, "panel_perinfo");
        }
    }

    public static void resetJobIntentionInfo(IFormView view) {
        DynamicObject newDy = view.getModel().getDataEntity();
        DynamicObject oldDy = RsmUpdateService.getCacheDataModel(view.getPageCache(), "panel_jobintention", newDy.getDynamicObjectType());
        if (null != oldDy) {
            HashSet<String> perInfoSet = new HashSet<String>(Arrays.asList(KEY_PREINFO_FIELDS));
            perInfoSet.add("selfevaluation");
            ResumeUtilsHelper.copyObj((DynamicObject)oldDy, (DynamicObject)newDy, perInfoSet);
            RsmUpdateService.editJobIntentionInfoButtonClick(view, Boolean.FALSE);
            RsmUpdateService.removePageCache(view, "panel_jobintention");
        }
    }

    public static void resetSelfDesc(IFormView view) {
        DynamicObject newDy = view.getModel().getDataEntity();
        DynamicObject oldDy = RsmUpdateService.getCacheDataModel(view.getPageCache(), "panel_selfdesc", newDy.getDynamicObjectType());
        if (null != oldDy) {
            view.getModel().setValue("selfevaluation", oldDy.get("selfevaluation"));
        }
        RsmUpdateService.editSelfButtonClick(view, Boolean.FALSE);
        RsmUpdateService.removePageCache(view, "panel_selfdesc");
    }

    public static boolean checkUpdateStatus(IFormView view) {
        JSONObject cacheJson;
        String status;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String token = (String)view.getFormShowParameter().getCustomParam("id");
        String key = InviteUpdateService.getTokenCacheKey(token);
        String cacheStr = (String)cache.get(key);
        boolean checkResult = false;
        if (HRStringUtils.isNotEmpty((String)cacheStr) && "0".equals(status = (cacheJson = JSON.parseObject((String)cacheStr)).getString("updatestatus"))) {
            checkResult = true;
        }
        if (!checkResult) {
            view.showTipNotification(SrRsmKDString.rsmUpdateOnce());
        }
        return checkResult;
    }

    public static boolean checkDeliverStatus(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        long objId = (Long)parameter.getCustomParam("objId");
        LOG.info("RsmUpdateService.checkDeliverStatus.objId:{}", (Object)objId);
        long positionId = Long.parseLong((String)parameter.getCustomParam("positionid"));
        LOG.info("RsmUpdateService.checkDeliverStatus.positionId:{}", (Object)positionId);
        if (!StdRsmBusiAppHelper.queryCandidateDeliveryStatus(objId, positionId)) {
            view.showTipNotification(SrRsmKDString.notRepeatDeliver());
            LOG.info("RsmUpdateService.checkDeliverStatus.notRepeatDeliver");
            return false;
        }
        DynamicObject positionDy = RsmPositionHelper.queryOneById(positionId);
        if (positionDy == null || positionDy.getString("positionstatus").equals("D")) {
            view.showTipNotification(SrRsmKDString.positionClosed());
            LOG.info("RsmUpdateService.checkDeliverStatus.positionClosed");
            return false;
        }
        return true;
    }
}

