/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.sr.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.enums.rsm.RsmAssignTypeEnum;
import kd.tsc.tsrbs.common.utils.EnumUtils;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.PositionResumeRuleMService;
import kd.tsc.tstpm.business.domain.rsm.sr.entity.PositionAndAddressDto;
import kd.tsc.tstpm.business.domain.rsm.sr.entity.RsmAssignRuleDto;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeHandleService;
import org.jetbrains.annotations.Nullable;

public class AssignPositionHelper {
    private static final Log LOG = LogFactory.getLog(AssignPositionHelper.class);
    private static AssignPositionHelper assignPositionHelper = null;
    private static String COMMA = "\u3001";
    public static final String ASSIGN_POSITION = "2/52S4X1O0ZK";
    private HRBaseServiceHelper rsmHelper = new HRBaseServiceHelper("tstpm_srrsm");

    private AssignPositionHelper() {
    }

    public static AssignPositionHelper getInstance() {
        if (HRObjectUtils.isEmpty((Object)assignPositionHelper)) {
            return new AssignPositionHelper();
        }
        return assignPositionHelper;
    }

    public DynamicObject[] getPositionNameAndAddress(List<Long> rsmList) {
        String selectProperties = String.join((CharSequence)",", "delivery", "number", "id");
        QFilter qFilter = new QFilter("id", "in", rsmList);
        return this.rsmHelper.query(selectProperties, qFilter.toArray(), "CHARINDEX(',' || CONVERT(VARCHAR(19),id) || ',' ,'" + rsmList + "')");
    }

    public List<PositionAndAddressDto> assignPosition(DynamicObject[] entities) {
        ArrayList<PositionAndAddressDto> rsmList = new ArrayList<PositionAndAddressDto>(entities.length);
        for (DynamicObject dynamicObject : entities) {
            PositionAndAddressDto assignRuleEmailAndAttachmentDto = new PositionAndAddressDto();
            DynamicObject delivery = dynamicObject.getDynamicObject("delivery");
            assignRuleEmailAndAttachmentDto.setTitlePosition(delivery.getString("titleposition"));
            assignRuleEmailAndAttachmentDto.setTitleCity(delivery.getString("titlecity"));
            assignRuleEmailAndAttachmentDto.setAttachPosition(delivery.getString("attachposition"));
            assignRuleEmailAndAttachmentDto.setAttachCity(delivery.getString("attachcity"));
            assignRuleEmailAndAttachmentDto.setRsmID(dynamicObject.getLong("id"));
            assignRuleEmailAndAttachmentDto.setRsmNumber(dynamicObject.getString("number"));
            rsmList.add(assignRuleEmailAndAttachmentDto);
        }
        return rsmList;
    }

    public RsmAssignRuleDto getRsmAssignRule(List<PositionAndAddressDto> emailAndAttachmentDtoList) {
        RsmAssignRuleDto emailTopicRsmAssignRule = this.getEmailRsmAssignRuleDto(emailAndAttachmentDtoList);
        if (emailTopicRsmAssignRule != null && emailTopicRsmAssignRule.getKeyword().contains(COMMA)) {
            return emailTopicRsmAssignRule;
        }
        RsmAssignRuleDto attachmentNameRsmAssignRule = this.getAttachmentRsmAssignRuleDto(emailAndAttachmentDtoList);
        if (attachmentNameRsmAssignRule != null && attachmentNameRsmAssignRule.getKeyword().contains(COMMA)) {
            return attachmentNameRsmAssignRule;
        }
        return emailTopicRsmAssignRule != null ? emailTopicRsmAssignRule : attachmentNameRsmAssignRule;
    }

    @Nullable
    private RsmAssignRuleDto getEmailRsmAssignRuleDto(List<PositionAndAddressDto> emailAndAttachmentDtoList) {
        RsmAssignRuleDto rsmAssignRuleDto = new RsmAssignRuleDto();
        rsmAssignRuleDto.setDistributedMode(RsmAssignTypeEnum.EMAIL.getCode());
        for (PositionAndAddressDto emailAndAttachment : emailAndAttachmentDtoList) {
            if (HRStringUtils.isNotEmpty((String)emailAndAttachment.getTitlePosition()) && HRStringUtils.isNotEmpty((String)emailAndAttachment.getTitleCity())) {
                String keyWord = emailAndAttachment.getTitlePosition() + COMMA + emailAndAttachment.getTitleCity();
                rsmAssignRuleDto.setKeyword(keyWord);
                return rsmAssignRuleDto;
            }
            if (!HRStringUtils.isNotEmpty((String)emailAndAttachment.getTitlePosition())) continue;
            String keyWord = emailAndAttachment.getTitlePosition();
            rsmAssignRuleDto.setKeyword(keyWord);
            return rsmAssignRuleDto;
        }
        return null;
    }

    @Nullable
    private RsmAssignRuleDto getAttachmentRsmAssignRuleDto(List<PositionAndAddressDto> emailAndAttachmentDtoList) {
        RsmAssignRuleDto rsmAssignRuleDto = new RsmAssignRuleDto();
        rsmAssignRuleDto.setDistributedMode(RsmAssignTypeEnum.Attachment.getCode());
        for (PositionAndAddressDto emailAndAttachment : emailAndAttachmentDtoList) {
            if (HRStringUtils.isNotEmpty((String)emailAndAttachment.getAttachPosition()) && HRStringUtils.isNotEmpty((String)emailAndAttachment.getAttachCity())) {
                String keyWord = emailAndAttachment.getAttachPosition() + COMMA + emailAndAttachment.getAttachCity();
                rsmAssignRuleDto.setKeyword(keyWord);
                return rsmAssignRuleDto;
            }
            if (!HRStringUtils.isNotEmpty((String)emailAndAttachment.getAttachPosition())) continue;
            String keyWord = emailAndAttachment.getAttachPosition();
            rsmAssignRuleDto.setKeyword(keyWord);
            return rsmAssignRuleDto;
        }
        return null;
    }

    public List<SaveCandidateResult> appFileJudgmentRepetition(Long rsmId, Long positionId) {
        AddResumeHandleService addCandidateService = new AddResumeHandleService();
        return addCandidateService.handleUnAllocatedRsm(rsmId, Collections.singletonList(positionId));
    }

    public BizResult insertRsmAssignRule(RsmAssignRuleDto rsmAssignRuleDto) {
        return PositionResumeRuleMService.addOneAfterPositionExist(rsmAssignRuleDto.getPositionId(), (RsmAssignTypeEnum)EnumUtils.getEnumByCode((String)rsmAssignRuleDto.getDistributedMode(), RsmAssignTypeEnum.class), rsmAssignRuleDto.getKeyword());
    }

    public static boolean checkPermission(String appId, String pageForm, String permissionItem) {
        LOG.info("AssignPositionHelper.checkPermission.appId:{}, pageForm:{},permissionItem:{}", new Object[]{appId, pageForm, permissionItem});
        int hasPerm = PermissionServiceHelper.checkPermission((Long)TSCRequestContext.getUserId(), (Long)TSCRequestContext.getOrgId(), (String)AppMetadataCache.getAppInfo((String)appId).getId(), (String)pageForm, (String)permissionItem);
        return hasPerm == 1;
    }
}

