/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.sr.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.utils.BizAttachmentUtil;
import kd.tsc.tsrbd.common.constants.rsm.ResumeConstants;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveAppFileResult;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;
import kd.tsc.tsrbs.common.exception.TSCBizException;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RDeliveryHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AfterTransHandlerService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.ResumeLockService;
import kd.tsc.tstpm.business.domain.stdrsm.handler.adapt.StdRsmAdapt;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tstpm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tstpm.common.utils.AttachmentUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AddResumeHandleService {
    private static final Log logger = LogFactory.getLog(AddResumeHandleService.class);
    private static AddResumeHandleService addResumeHandleService = new AddResumeHandleService();
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"saveFile_pool", (int)10, (int)200);
    private static final Set<String> RSM_SOURCE_NOT_UPDATE_STD = Sets.newHashSet((Object[])new String[]{RsmSourceEnum.TP.getCode(), RsmSourceEnum.RP.getCode()});

    public static AddResumeHandleService getInstance() {
        return addResumeHandleService;
    }

    public SaveCandidateResult handle(AppResumeBo resumeBo, DynamicObject positionDt, Boolean isLock) {
        return this.handle(resumeBo, positionDt, isLock, null);
    }

    public SaveCandidateResult handle(AppResumeBo resumeBo, DynamicObject positionDt, Boolean isLock, ResumeTypeEnum resumeTypeEnum) {
        SaveCandidateResult result;
        boolean isExist;
        DynamicObject rsm = resumeBo.getRsm();
        List<String> lockKeyList = null;
        TXHandle txHandle = TX.requiresNew();
        try {
            if (Boolean.TRUE.equals(isLock)) {
                lockKeyList = ResumeLockService.getLockKey(rsm);
                ResumeLockService.lock(lockKeyList);
            }
            rsm.getDataEntityState().setFromDatabase(false);
            ResumeUtilsHelper.log((AppResumeBo)resumeBo, (String)"AddResumeHandleService.handle");
            logger.info("AddResumeHandleService.handle.begin");
            DynamicObject stdRsmDy = AddResumeService.isExistStandResume(resumeBo);
            resumeBo.setPosition(positionDt);
            boolean bl = isExist = stdRsmDy != null;
            if (isExist) {
                logger.info("AddResumeHandleService.handle candidate is exist");
                Long candidateId = ResumeUtilsHelper.getId((Object)stdRsmDy);
                resumeBo.getRsm().set("stdrsm", (Object)candidateId);
                result = this.handleHaveCandidate(resumeBo, positionDt, candidateId);
                if (!RSM_SOURCE_NOT_UPDATE_STD.contains(resumeBo.getRsm().getString("rsmsource")) && result.isSuccess()) {
                    logger.info("AddResumeHandleService.handle diffUpdateStandResume");
                    AddResumeService.diffUpdateStandResume(candidateId, resumeBo, resumeTypeEnum);
                }
            } else {
                logger.info("AddResumeHandleService.handle candidate NOT exist");
                Map<String, Long> saveResult = AddResumeService.addStandResume(resumeBo, resumeTypeEnum);
                Long candidateId = saveResult.get("id");
                resumeBo.getRsm().set("stdrsm", (Object)candidateId);
                result = this.handleNotHaveCandidate(resumeBo, positionDt, candidateId);
            }
            logger.info("AddResumeHandleService.handle.end");
        }
        catch (Exception e) {
            logger.error("AddResumeHandleService.handle.error", (Throwable)e);
            txHandle.markRollback();
            throw new TSCBizException((Throwable)e);
        }
        finally {
            txHandle.close();
            if (null != lockKeyList) {
                ResumeLockService.unLock(lockKeyList);
            }
        }
        AfterTransHandlerService handlerAfterAddRsm = new AfterTransHandlerService(result, positionDt, resumeBo, isExist);
        ResumeConstants.threadPool.execute((Runnable)handlerAfterAddRsm);
        return result;
    }

    public SaveCandidateResult handleNoUpdateStdRsm(AppResumeBo resumeBo, DynamicObject positionDt, Boolean isLock) {
        SaveCandidateResult saveCandidateResult;
        block8: {
            logger.info("AddResumeHandleService.handleNoUpdateStdRsm RP");
            Long candidateId = resumeBo.getRsm().getLong("stdrsm");
            saveCandidateResult = null;
            List<String> lockKeyList = null;
            TXHandle tx = TX.required();
            try {
                SaveAppFileResult saveAppFileRes;
                if (Boolean.TRUE.equals(isLock)) {
                    lockKeyList = ResumeLockService.getLockKey(resumeBo.getRsm());
                    ResumeLockService.lock(lockKeyList);
                }
                if ((saveAppFileRes = AddResumeService.manualSaveAppFile(candidateId, resumeBo, positionDt)).isSuccess()) {
                    logger.info("AddResumeHandleService.handleNoUpdateStdRsm SUCCESS,stdRsmId{}", (Object)candidateId);
                    resumeBo.getRsm().set("appfile", (Object)saveAppFileRes.getAppFileId());
                    AddResumeService.saveAppRsm(resumeBo);
                    saveCandidateResult = this.initSaveCandidateResult(true, saveAppFileRes.getAppFileId(), resumeBo.getRsm().getLong("id"), candidateId);
                    break block8;
                }
                logger.info("AddResumeHandleService.handleNoUpdateStdRsm FAIL,stdRsmId{}", (Object)candidateId);
                SaveCandidateResult saveCandidateResult2 = saveCandidateResult = this.initSaveCandidateResult(false, saveAppFileRes.getAppFileId(), resumeBo.getRsm().getLong("id"), candidateId);
                return saveCandidateResult2;
            }
            catch (Exception ex) {
                logger.error("AddResumeHandleService.handleNoUpdateStdRsm.error", (Throwable)ex);
                tx.markRollback();
                throw new TSCBizException((Throwable)ex);
            }
            finally {
                tx.close();
                if (null != lockKeyList) {
                    ResumeLockService.unLock(lockKeyList);
                }
            }
        }
        AfterTransHandlerService handlerAfterAddRsm = new AfterTransHandlerService(saveCandidateResult, positionDt, resumeBo, true);
        ResumeConstants.threadPool.execute((Runnable)handlerAfterAddRsm);
        return saveCandidateResult;
    }

    private SaveCandidateResult handleHaveCandidate(AppResumeBo resumeBo, DynamicObject positionDt, Long candidateId) {
        SaveCandidateResult result;
        String rsmSource = resumeBo.getRsm().getString("rsmsource");
        long rsmId = resumeBo.getRsm().getLong("id");
        if (positionDt != null) {
            logger.info("AddResumeHandleService.handleHaveCandidate have position");
            SaveAppFileResult saveAppFileRes = AddResumeService.manualSaveAppFile(candidateId, resumeBo, positionDt);
            logger.info("AddResumeHandleService.handleHaveCandidate saveAppFileRes.isSuccess():{},rsmSource:{}", (Object)saveAppFileRes.isSuccess(), (Object)rsmSource);
            long appFileId = saveAppFileRes.getAppFileId();
            ResumeBoHelper.setDeliveryIsDisplayNew(appFileId, resumeBo);
            if (saveAppFileRes.isSuccess()) {
                logger.info("AddResumeHandleService.handleHaveCandidate add appfile success");
                resumeBo.getRsm().set("appfile", (Object)appFileId);
                AddResumeService.saveAppRsm(resumeBo);
                result = this.initSaveCandidateResult(true, appFileId, rsmId, candidateId);
            } else if (RsmSourceEnum.EMAIL.getCode().equals(rsmSource)) {
                logger.info("AddResumeHandleService.handleHaveCandidate appfile repeat,Rsm Source Email");
                AddResumeService.saveAppRsm(resumeBo);
                result = this.initSaveCandidateResult(true, appFileId, rsmId, candidateId);
                logger.info("AddResumeHandleService.handleHaveCandidate appfile repeat,Rsm Source Email handler Success");
            } else {
                logger.info("AddResumeHandleService.handleHaveCandidate add appfile fail");
                result = this.initSaveCandidateResult(false, appFileId, rsmId, candidateId);
            }
        } else {
            logger.info("AddResumeHandleService.handleHaveCandidate have no position");
            if (RsmSourceEnum.EMAIL.getCode().equals(rsmSource)) {
                logger.info("AddResumeHandleService.handleHaveCandidate have no position,Rsm Source Email");
                ResumeBoHelper.setDeliveryIsDisplayNew(0L, resumeBo);
                AddResumeService.saveAppRsm(resumeBo);
                logger.info("AddResumeHandleService.handleHaveCandidate have no position,Rsm Source Email handler Success");
            } else {
                resumeBo.getRsm().set("appfile", null);
                AddResumeService.saveAppRsm(resumeBo);
            }
            result = this.initSaveCandidateResult(true, null, rsmId, candidateId);
        }
        return result;
    }

    private SaveCandidateResult handleNotHaveCandidate(AppResumeBo resumeBo, DynamicObject positionDt, Long candidateId) {
        logger.info("AddResumeHandleService.handleNotHaveCandidate");
        Long appFileId = null;
        if (positionDt != null) {
            logger.info("AddResumeHandleService.handleNotHaveCandidate have position");
            SaveAppFileResult saveAppFileRes = AddResumeService.manualSaveAppFile(candidateId, resumeBo, positionDt);
            appFileId = saveAppFileRes.getAppFileId();
            resumeBo.getRsm().set("appfile", (Object)saveAppFileRes.getAppFileId());
        } else {
            ResumeBoHelper.setDeliveryDisplayFalse(resumeBo);
        }
        AddResumeService.saveAppRsm(resumeBo);
        SaveCandidateResult result = this.initSaveCandidateResult(true, appFileId, resumeBo.getRsm().getLong("id"), candidateId);
        return result;
    }

    private SaveCandidateResult initSaveCandidateResult(boolean isSuccess, Long appFileId, Long rsmId, Long stdRsmId) {
        SaveCandidateResult result = new SaveCandidateResult();
        if (isSuccess) {
            result.setMessage(SrRsmKDString.submitSuccess());
        } else {
            result.setMessage(SrRsmKDString.submitFailRepeat());
        }
        result.setSuccess(isSuccess);
        result.setAppFileId(appFileId);
        result.setRsmId(rsmId);
        result.setStdRsmId(stdRsmId);
        return result;
    }

    public List<SaveCandidateResult> handleUnAllocatedRsm(Long rsmId, List<Long> positionIds) {
        logger.info("AddResumeHandleService.handleUnAllocatedRsm.params:{},{}", (Object)rsmId, positionIds);
        AppResumeBo appResumeBo = ResumeBoHelper.getAppResumeBo(rsmId);
        if (appResumeBo == null) {
            return Lists.newArrayList();
        }
        ResumeBoHelper.loadAllListData(appResumeBo);
        for (String pageKey : ResumeConstants.SUBPAGES) {
            List rsmExps = appResumeBo.getEntryList(pageKey);
            rsmExps = ResumeUtilsHelper.copyDynamicObject((List)rsmExps);
            appResumeBo.setEntry(pageKey, rsmExps);
        }
        Long stdRsmId = appResumeBo.getRsm().getLong("stdrsm");
        DynamicObject[] positions = RsmPositionHelper.getPositionObjByPositionIds(positionIds);
        List positionList = positionIds.stream().map(id -> Arrays.stream(positions).filter(pos -> id.equals(pos.getLong("id"))).findFirst().orElse(null)).collect(Collectors.toList());
        appResumeBo.getDelivery().set("isfiledisplay", (Object)Boolean.TRUE);
        ArrayList appResumeBoList = Lists.newArrayList((Object[])new AppResumeBo[]{appResumeBo});
        for (int i = 1; i < positionList.size() - 1; ++i) {
            AppResumeBo copyResumeBo = ResumeBoHelper.copy(appResumeBo);
            copyResumeBo.getDelivery().set("applytime", appResumeBo.getDelivery().get("applytime"));
            appResumeBoList.add(copyResumeBo);
        }
        ArrayList<SaveCandidateResult> results = new ArrayList<SaveCandidateResult>(appResumeBoList.size());
        try (TXHandle tx = TX.required();){
            try {
                int index = 0;
                for (AppResumeBo resumeBo : appResumeBoList) {
                    resumeBo.getDelivery().set("assignstatus", (Object)"1");
                    SaveCandidateResult saveCandidateResult = this.handleHaveCandidate(resumeBo, (DynamicObject)positionList.get(index), stdRsmId);
                    results.add(saveCandidateResult);
                    AppFileMService.afterAppFileSaveHandle(saveCandidateResult, (DynamicObject)positionList.get(index), resumeBo);
                    ++index;
                }
            }
            catch (RuntimeException ex) {
                logger.error("handleUnAllocatedRsm.error", (Throwable)ex);
                tx.markRollback();
                throw ex;
            }
        }
        logger.info("AddResumeHandleService.handleUnAllocatedRsm.end.result:{}", results);
        return results;
    }

    public static void rsmUpdate(AppResumeBo resumeBo) {
        DynamicObject rsmDy = resumeBo.getRsm();
        long rsmId = rsmDy.getLong("id");
        logger.info("rsmUpdate.rsmId:{}", (Object)rsmId);
        DynamicObject oldRsmDy = RsmHelper.findOne(rsmId);
        ResumeUtilsHelper.copyObj((DynamicObject)rsmDy, (DynamicObject)oldRsmDy, (Set)Sets.newHashSet((Object[])new String[]{"id", "number", "createtime", "creator", "appfile", "delivery", "stdrsm", "rsmsource"}));
        logger.info("rsmUpdate.ResumeUtilsHelper.copyObj");
        resumeBo.setRsm(oldRsmDy);
        DynamicObject appFileDy = RsmAppFileHelper.findAppFileByRsmId(rsmId);
        logger.info("rsmUpdate.findAppFileByRsmId,appFileId:{}", appFileDy.get("id"));
        RsmCommonService.updateAppFileByAppResume((DynamicObject)appFileDy, (AppResumeBo)resumeBo);
        ResumeUtilsHelper.setExpInfoRsmId((AppResumeBo)resumeBo);
        long stdRsmId = oldRsmDy.getLong("stdrsm");
        logger.info("rsmUpdate.stadRsmId:{}", (Object)stdRsmId);
        ResumeUtilsHelper.setModifyTime((DynamicObject)rsmDy);
        AddResumeHandleService.rsmUpdateTx(appFileDy, resumeBo, stdRsmId, ResumeTypeEnum.INVITE_UPDATE, true);
        RsmCommonHelper.outTransaction(rsmId, Boolean.TRUE);
    }

    public static void stdRsmUpdate(AppResumeBo resumeBo) {
        DynamicObject rsmDy = resumeBo.getRsm();
        long stdRsmId = rsmDy.getLong("id");
        logger.info("stdRsmUpdate.stadRsmId:{}", (Object)stdRsmId);
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
        if (null != stdRsmDy) {
            stdRsmId = stdRsmDy.getLong("mid");
            logger.info("stdRsmUpdate.stadRsmId.MainId:{}", (Object)stdRsmId);
            DynamicObject deliveryDy = RDeliveryHelper.getLastDeliveryByStdRsmId(stdRsmId);
            resumeBo.setDelivery(deliveryDy);
            long rsmId = ID.genLongId();
            rsmDy.set("id", (Object)rsmId);
            rsmDy.set("delivery", (Object)deliveryDy);
            rsmDy.set("stdrsm", (Object)stdRsmId);
            ResumeUtilsHelper.setExpInfoRsmId((AppResumeBo)resumeBo);
            ResumeUtilsHelper.setCreateTime((DynamicObject)rsmDy);
            logger.info("stdRsmUpdate.rsmId:{},newDeliveryId:{}", (Object)rsmId, deliveryDy.get("id"));
            AddResumeHandleService.rsmUpdateTx(null, resumeBo, stdRsmId, ResumeTypeEnum.INVITE_UPDATE, true);
            RsmCommonHelper.outTransaction(rsmId, Boolean.TRUE);
        }
    }

    public static void stdRsmDeliver(AppResumeBo resumeBo, Long positionId) {
        Long appFileId;
        DynamicObject rsmDy = resumeBo.getRsm();
        Long stdRsmId = resumeBo.getRsm().getLong("id");
        logger.info("stdRsmDeliver.stdrsmId:{}", (Object)stdRsmId);
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
        stdRsmId = stdRsmDy.getLong("mid");
        logger.info("stdRsmDeliver.stdrsmId.MainResumeId:{}", (Object)stdRsmId);
        DynamicObject deliveryDy = RDeliveryHelper.getStdRsmDeliverDelivery();
        long rsmId = ID.genLongId();
        logger.info("stdRsmDeliver.rsmid:{}\uff0cpositionId:{}", (Object)rsmId, (Object)positionId);
        rsmDy.set("id", (Object)rsmId);
        rsmDy.set("delivery", (Object)deliveryDy);
        ResumeUtilsHelper.setExpInfoRsmId((AppResumeBo)resumeBo);
        ResumeUtilsHelper.setCreateTime((DynamicObject)rsmDy);
        resumeBo.setDelivery(deliveryDy);
        DynamicObject positionDy = RsmPositionHelper.queryOneById(positionId);
        resumeBo.setPosition(positionDy);
        boolean isUpdate = true;
        try (TXHandle tx = TX.required();){
            String dataStatus = stdRsmDy.getString("datastatus");
            if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
                Map<String, Long> saveResult = AddResumeService.addStandResume(resumeBo, ResumeTypeEnum.INVITE);
                stdRsmId = saveResult.get("id");
                logger.info("stdRsmDeliver.addStandResume newStdRsmId={}", (Object)stdRsmId);
                isUpdate = false;
            }
            rsmDy.set("stdrsm", (Object)stdRsmId);
            SaveAppFileResult saveAppFileResult = AddResumeService.saveNewAppFile(stdRsmId, resumeBo, positionDy, "tssrm_appfile_view");
            appFileId = saveAppFileResult.getAppFileId();
            rsmDy.set("appfile", (Object)appFileId);
            logger.info("stdRsmDeliver.AddResumeService.saveNewAppFile\uff1a{}\uff0cappfileId:{}", (Object)saveAppFileResult.isSuccess(), (Object)saveAppFileResult.getAppFileId());
            AddResumeHandleService.rsmUpdateTx(null, resumeBo, stdRsmId, ResumeTypeEnum.INVITE, isUpdate);
        }
        if (!isUpdate) {
            ArrayList<Long> stdRsmIds = new ArrayList<Long>(1);
            stdRsmIds.add(stdRsmId);
            TalentListFunService.saveCandidate2UnClassFy(stdRsmIds);
        }
        RsmCommonHelper.outTransaction(rsmId, Boolean.TRUE);
        if (appFileId != null) {
            logger.info("stdRsmDeliver.stdRsmDeliver AppFileMService.afterAppFileSaveHandle");
            AppFileMService.afterAppFileSaveHandle(appFileId, rsmId, positionDy, resumeBo);
        }
    }

    public SaveCandidateResult newCandidate(AppResumeBo resumeBo, DynamicObject positionDt, Boolean isLock, ResumeTypeEnum resumeTypeEnum, Map<String, Object> otherInfoMap) {
        SaveCandidateResult result;
        boolean isExist;
        logger.info("AddResumeHandleService.newCandidate.otherInfoMap->{}", otherInfoMap);
        DynamicObject rsm = resumeBo.getRsm();
        List<String> lockKeyList = null;
        TXHandle txHandle = TX.requiresNew();
        String tpAppfileId = resumeBo.getTpAppfileId();
        logger.info("AddResumeHandleService.newCandidate.getTpAppfileId->{}", (Object)tpAppfileId);
        DLock dLock = DLock.create((String)tpAppfileId);
        dLock.lock();
        try {
            logger.info("AddResumeHandleService.newCandidate.lockinfo->{}", (Object)DLock.getLockInfo((String)tpAppfileId));
            if (Boolean.TRUE.equals(isLock)) {
                lockKeyList = ResumeLockService.getLockKey(rsm);
                ResumeLockService.lock(lockKeyList);
            }
            rsm.getDataEntityState().setFromDatabase(false);
            ResumeUtilsHelper.log((AppResumeBo)resumeBo, (String)"AddResumeHandleService.handle");
            logger.info("AddResumeHandleService.handle.begin");
            DynamicObject stdRsmDy = StdRsmAdapt.isExistStandResume(resumeBo.getTpStdRsmId());
            resumeBo.setPosition(positionDt);
            isExist = stdRsmDy != null;
            Long candidateId = null;
            if (isExist) {
                logger.info("AddResumeHandleService.handle candidate is exist");
                candidateId = ResumeUtilsHelper.getId((Object)stdRsmDy);
                logger.info("AddResumeHandleService.handle diffUpdateStandResume");
                AddResumeService.diffUpdateStandResume(candidateId, resumeBo, resumeTypeEnum);
            } else {
                logger.info("AddResumeHandleService.handle candidate NOT exist");
                Map<String, Long> saveResult = AddResumeService.addStandResume(resumeBo, resumeTypeEnum);
                candidateId = saveResult.get("id");
            }
            resumeBo.getRsm().set("stdrsm", (Object)candidateId);
            logger.info("AddResumeHandleService.handleNotHaveCandidate");
            this.handleRepeatAppfilePindex(resumeBo);
            logger.info("AddResumeHandleService.handleNotHaveCandidate handleRepeatAppfilePindex");
            SaveAppFileResult saveAppFileRes = AddResumeService.saveNewAppFile(candidateId, resumeBo, positionDt, "tsrsc_appfile_view");
            logger.info("AddResumeHandleService.handleNotHaveCandidate saveNewAppFile");
            Long appFileId = saveAppFileRes.getAppFileId();
            resumeBo.getRsm().set("appfile", (Object)saveAppFileRes.getAppFileId());
            AddResumeService.saveAppRsm(resumeBo);
            THREAD_POOL.execute(() -> this.saveFile(resumeBo, otherInfoMap));
            logger.info("AddResumeHandleService.handleNotHaveCandidate saveAppRsm");
            result = this.initSaveCandidateResult(true, appFileId, resumeBo.getRsm().getLong("id"), candidateId);
            logger.info("AddResumeHandleService.handleNotHaveCandidate initSaveCandidateResult");
            this.setAppfileAdminOrg(appFileId, otherInfoMap);
        }
        catch (Exception e) {
            logger.error("AddResumeHandleService.handle.error", (Throwable)e);
            txHandle.markRollback();
            throw e;
        }
        finally {
            txHandle.close();
            if (null != lockKeyList) {
                ResumeLockService.unLock(lockKeyList);
            }
            dLock.unlock();
            logger.info("AddResumeHandleService.handleNotHaveCandidate unlock");
        }
        AfterTransHandlerService handlerAfterAddRsm = new AfterTransHandlerService(result, positionDt, resumeBo, isExist);
        ResumeConstants.threadPool.execute((Runnable)handlerAfterAddRsm);
        logger.info("AddResumeHandleService.handle.end");
        return result;
    }

    private void uploadAttachments(AppResumeBo resumeBo, Map<String, Object> otherInfoMap) {
        Map attachmentResumeMap = BizAttachmentUtil.buildAttachment((String)"tstpm_rsm", (String)resumeBo.getRsm().getString("resumestoadd"), (String)resumeBo.getRsm().getString("fullname"), (Long)0L, null);
        ArrayList<Map> attachmentMapResumeList = new ArrayList<Map>(1);
        attachmentMapResumeList.add(attachmentResumeMap);
        BizAttachmentUtil.uploadAttachments((String)"tstpm_rsm", (Object)resumeBo.getRsm().getLong("id"), (String)"attachmentpanelap", attachmentMapResumeList);
        List interviewInfoMapList = (List)otherInfoMap.get("interviewInfo");
        if (CollectionUtils.isEmpty((Collection)interviewInfoMapList)) {
            logger.info("AddResumeHandleService-uploadAttachments-interviewInfoMapList-isempty...");
            return;
        }
        String interviewFeedbackUrl = (String)((Map)interviewInfoMapList.get(0)).get("interviewFeedbackUrl");
        if (HRStringUtils.isEmpty((String)interviewFeedbackUrl)) {
            logger.info("AddResumeHandleService-uploadAttachments-interviewFeedbackUrl-isempty...");
            return;
        }
        logger.info("AddResumeHandleService-uploadAttachments-interviewFeedbackUrl:{}", (Object)interviewFeedbackUrl);
        HRBaseServiceHelper interviewAssHelper = new HRBaseServiceHelper("tspr_intveval");
        DynamicObject interviewAssDy = interviewAssHelper.generateEmptyDynamicObject();
        interviewAssDy.set("id", (Object)ORM.create().genLongId("tspr_intveval"));
        interviewAssDy.set("appfile", resumeBo.getRsm().get("appfile"));
        interviewAssHelper.saveOne(interviewAssDy);
        String fileName = ResManager.loadKDString((String)"{0}_\u9762\u8bd5\u8bc4\u4ef7", (String)"AddResumeHandleService_0", (String)"tsc-tstpm-business", (Object[])new Object[]{resumeBo.getRsm().getString("fullname")});
        String firstInterviewFeedbackUrl = interviewFeedbackUrl.substring(0, interviewFeedbackUrl.indexOf("?"));
        String twoInterviewFeedbackUrl = interviewFeedbackUrl.substring(interviewFeedbackUrl.indexOf("?") + 1);
        String[] splitInterviewFeedbackUrl = twoInterviewFeedbackUrl.split("tamp");
        String finalInterviewFeedbackUrl = firstInterviewFeedbackUrl + "?timestamp" + splitInterviewFeedbackUrl[1] + "&" + splitInterviewFeedbackUrl[0].substring(0, splitInterviewFeedbackUrl[0].length() - 1);
        logger.info("AddResumeHandleService-uploadAttachments-finalInterviewFeedbackUrl:{}", (Object)finalInterviewFeedbackUrl);
        String newAssUrl = this.setConversionUrl(finalInterviewFeedbackUrl, fileName, interviewAssDy.getLong("id"), "tspr", "tspr_intveval", ".pdf");
        logger.info("AddResumeHandleService-uploadAttachments-newAssUrl:{}", (Object)newAssUrl);
        Map attachmentAssMap = BizAttachmentUtil.buildAttachment((String)"tspr_intveval", (String)newAssUrl, (String)fileName, (Long)0L, null);
        ArrayList<Map> attachmentAssMapList = new ArrayList<Map>(1);
        attachmentAssMapList.add(attachmentAssMap);
        BizAttachmentUtil.uploadAttachments((String)"tspr_intveval", (Object)interviewAssDy.getLong("id"), (String)"attachmentpanelap", attachmentAssMapList);
    }

    private void handleRepeatAppfilePindex(AppResumeBo resumeBo) {
        QFilter qFilter;
        DynamicObject[] appFiles;
        String tpAppFileId = resumeBo.getTpAppfileId();
        Map<String, Long> appFileByTpDataIdMap = AppFileMService.getAppFileByTpDataId((List<String>)ImmutableList.of((Object)tpAppFileId));
        Long appFileIdRepeat = appFileByTpDataIdMap.get(tpAppFileId);
        if (ObjectUtils.isEmpty((Object)appFileIdRepeat) && ObjectUtils.isNotEmpty((Object)(appFiles = AppFileMService.queryAppFileByFilter(qFilter = new QFilter("tpdataid", "=", (Object)tpAppFileId), "pindex")))) {
            for (DynamicObject appFile : appFiles) {
                appFile.set("pindex", (Object)appFile.getLong("id"));
            }
            AppFileMService.save(appFiles);
        }
    }

    public SaveCandidateResult updateCandidate(AppResumeBo resumeBo, DynamicObject positionDt, Boolean isLock, ResumeTypeEnum resumeTypeEnum, Map<String, Object> otherInfoMap) {
        SaveCandidateResult result;
        DynamicObject rsm = resumeBo.getRsm();
        List<String> lockKeyList = null;
        TXHandle txHandle = TX.requiresNew();
        Long candidateId = resumeBo.getRsm().getLong("stdrsm");
        Long appfileId = resumeBo.getRsm().getLong("appfile");
        try {
            if (Boolean.TRUE.equals(isLock)) {
                lockKeyList = ResumeLockService.getLockKey(rsm);
                ResumeLockService.lock(lockKeyList);
            }
            logger.info("AddResumeHandleService.handle diffUpdateStandResume");
            AddResumeService.diffUpdateStandResume(candidateId, resumeBo, resumeTypeEnum);
            rsm.getDataEntityState().setFromDatabase(false);
            ResumeUtilsHelper.log((AppResumeBo)resumeBo, (String)"AddResumeHandleService.handle");
            logger.info("AddResumeHandleService.handle.begin");
            resumeBo.setPosition(positionDt);
            logger.info("AddResumeHandleService.handle candidate is exist");
            ResumeBoHelper.setDeliveryIsDisplayNew(appfileId, resumeBo);
            AddResumeService.saveAppRsm(resumeBo);
            long rsmId = resumeBo.getRsm().getLong("id");
            result = this.initSaveCandidateResult(true, appfileId, rsmId, candidateId);
            logger.info("AddResumeHandleService.handle.end");
        }
        catch (Exception e) {
            logger.error("AddResumeHandleService.handle.error", (Throwable)e);
            txHandle.markRollback();
            throw new TSCBizException((Throwable)e);
        }
        finally {
            txHandle.close();
            if (null != lockKeyList) {
                ResumeLockService.unLock(lockKeyList);
            }
        }
        AddResumeService.saveAppRsm(resumeBo);
        THREAD_POOL.execute(() -> this.saveFile(resumeBo, otherInfoMap));
        AfterTransHandlerService handlerAfterAddRsm = new AfterTransHandlerService(result, positionDt, resumeBo, Boolean.TRUE);
        ResumeConstants.threadPool.execute((Runnable)handlerAfterAddRsm);
        this.updateAppfileAdminOrg(result.getAppFileId(), otherInfoMap);
        return result;
    }

    private void updateAppfileAdminOrg(Long appFileId, Map<String, Object> otherInfoMap) {
        if (appFileId == null || appFileId == 0L) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject appfileDy = serviceHelper.queryOne((Object)appFileId);
        appfileDy.set("adminorg", otherInfoMap.get("orgId"));
        serviceHelper.updateOne(appfileDy);
    }

    private void saveFile(AppResumeBo resumeBo, Map<String, Object> otherInfoMap) {
        String fileName = ResManager.loadKDString((String)"{0}_\u539f\u59cb\u7b80\u5386", (String)"AddResumeHandleService_1", (String)"tsc-tstpm-business", (Object[])new Object[]{resumeBo.getRsm().getString("fullname")});
        String newUrl = this.setConversionUrl(resumeBo.getRsm().getString("resumestoadd"), fileName, resumeBo.getRsm().getLong("id"), "tstpm", "tstpm_rsm", null);
        resumeBo.getRsm().set("resumestoadd", (Object)newUrl);
        logger.info("AddResumeHandleService.handleHaveCandidate add appfile success");
        AddResumeService.saveAppRsm(resumeBo);
        this.uploadAttachments(resumeBo, otherInfoMap);
    }

    private void setAppfileAdminOrg(Long appFileId, Map<String, Object> otherInfoMap) {
        HRBaseServiceHelper atsServiceHelper;
        DynamicObject atsMsgRecordDy;
        if (appFileId == null || appFileId == 0L) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tspr_appfile");
        DynamicObject appfileDy = serviceHelper.queryOne((Object)appFileId);
        appfileDy.set("adminorg", otherInfoMap.get("orgId"));
        String tpdataId = appfileDy.getString("tpdataid");
        if (HRStringUtils.isNotEmpty((String)tpdataId) && !HRObjectUtils.isEmpty((Object)(atsMsgRecordDy = (atsServiceHelper = new HRBaseServiceHelper("tsrsc_atsmsgrecord")).queryOne("id,tpdataid,operatormail", new QFilter("tpdataid", "=", (Object)tpdataId))))) {
            String operatormail = atsMsgRecordDy.getString("operatormail");
            if (HRStringUtils.isEmpty((String)operatormail)) {
                appfileDy.set("creator", null);
            } else {
                HRBaseServiceHelper userHelper = new HRBaseServiceHelper("bos_user");
                QFilter userQfilter = new QFilter("email", "=", (Object)operatormail);
                DynamicObject bosUserDy = userHelper.loadDynamicObject(userQfilter);
                if (HRObjectUtils.isEmpty((Object)bosUserDy)) {
                    appfileDy.set("creator", null);
                } else {
                    appfileDy.set("creator", bosUserDy.get("id"));
                }
            }
        }
        serviceHelper.updateOne(appfileDy);
    }

    private static void rsmUpdateTx(DynamicObject appFileDy, AppResumeBo resumeBo, long stdRsmId, ResumeTypeEnum resumeTypeEnum, boolean isUpdate) {
        try (TXHandle tx = TX.required();){
            RDeliveryHelper.saveDelivery(resumeBo.getDelivery());
            logger.info("rsmUpdateTx.RDeliveryHelper.saveDelivery");
            ResumeBoHelper.saveOneRsm(resumeBo.getRsm());
            logger.info("rsmUpdateTx.ResumeBoHelper.saveOneRsm");
            ResumeBoHelper.handlerSubForm(resumeBo);
            logger.info("rsmUpdateTx.ResumeBoHelper.handlerSubForm");
            if (null != appFileDy) {
                AppFileMService.save(new DynamicObject[]{appFileDy});
                logger.info("rsmUpdateTx.AppFileMService.save");
            }
            if (isUpdate) {
                resumeBo.getRsm().getDataEntityState().setFromDatabase(true);
                AddResumeService.diffUpdateStandResume(stdRsmId, resumeBo, resumeTypeEnum);
                logger.info("rsmUpdateTx.diffUpdateStandResume.stadRsmId:{}", (Object)stdRsmId);
            }
        }
    }

    private String setConversionUrl(String tpUrl, String fileName, long id, String appId, String formId, String filenameExtension) {
        try {
            logger.info("upload-url:{}", (Object)tpUrl);
            if (HRStringUtils.isNotEmpty((String)tpUrl)) {
                String fullFileName;
                if (HRStringUtils.isNotEmpty((String)filenameExtension)) {
                    fullFileName = fileName + filenameExtension;
                } else {
                    String filenameExten = tpUrl.substring(tpUrl.lastIndexOf("."));
                    fullFileName = fileName + filenameExten;
                }
                logger.info("fullFileName:{}", (Object)fullFileName);
                String newUrl = AttachmentUtil.upLoadFile((String)tpUrl, (Long)id, (String)fullFileName, (String)appId, (String)formId, (int)0);
                logger.info("upload-newUrl:{}", (Object)newUrl);
                return newUrl;
            }
        }
        catch (Exception exception) {
            logger.error("AddResumeHandleService.setConversionUrl.uploadFile error:", (Throwable)exception);
        }
        return null;
    }
}

