/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.sr.service;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tsc.tsrbd.business.domain.cfgresurule.service.CfgResumeRuleHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.common.RsmCommonService;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveAppFileResult;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;
import kd.tsc.tsrbs.common.enums.rsm.YesOrNotEnum;
import kd.tsc.tstpm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.PositionMService;
import kd.tsc.tstpm.business.domain.stdrsm.handler.adapt.StdRsmAdapt;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import org.apache.commons.lang3.ObjectUtils;

public class AddResumeService {
    private static final Log logger = LogFactory.getLog(AddResumeService.class);
    public static final String PROP_QUERY_APPFILE = "id,isbinddelyrec,highesteduschool,highesteducation,appres,modifier,modifytime,birthday,jobstatus,phone,email";

    public static DynamicObject isExistStandResume(AppResumeBo appResumeBo) {
        long stdRsmId = appResumeBo.getRsm().getLong("stdrsm");
        if (stdRsmId > 0L) {
            return StdRsmServiceHelper.getStdRsmByMid("tstpm_stdrsm", stdRsmId);
        }
        return StdRsmAdapt.isExistStandResume(appResumeBo);
    }

    public static Map<String, Long> addStandResume(AppResumeBo appResumeBo, ResumeTypeEnum resumeTypeEnum) {
        logger.info("rsm_opRecord_to_stdrsm resumeTypeEnum:{}", (Object)resumeTypeEnum);
        return StdRsmAdapt.addStandResume(appResumeBo, resumeTypeEnum);
    }

    public static void diffUpdateStandResume(Long stdRsmId, AppResumeBo appResumeBo) {
        AddResumeService.diffUpdateStandResume(stdRsmId, appResumeBo, ResumeTypeEnum.APP_FILE_UPDATE);
    }

    public static void diffUpdateStandResume(Long stdRsmId, AppResumeBo appResumeBo, ResumeTypeEnum resumeTypeEnum) {
        DynamicObject deliveryDy;
        appResumeBo.getRsm().set("number", null);
        DynamicObject positionDy = appResumeBo.getPosition();
        if (HRObjectUtils.isEmpty((Object)positionDy)) {
            Long appFileId = appResumeBo.getRsm().getLong("appfile");
            DynamicObject appFileDy = RsmAppFileHelper.queryOneById(appFileId);
            if (!HRObjectUtils.isEmpty((Object)appFileDy)) {
                positionDy = appFileDy.getDynamicObject("position");
                appResumeBo.setPosition(positionDy);
            }
            logger.info("appFileId = {}", (Object)appFileId);
        }
        if (HRObjectUtils.isEmpty((Object)(deliveryDy = appResumeBo.getDelivery()))) {
            deliveryDy = RsmCommonService.getDelivery((DynamicObject)appResumeBo.getRsm());
            appResumeBo.setDelivery(deliveryDy);
        }
        logger.info("rsm_opRecord_to_stdrsm resumeTypeEnum:{}", (Object)resumeTypeEnum);
        StdRsmAdapt.diffUpdateStandResume(stdRsmId, appResumeBo, resumeTypeEnum);
    }

    public static void updatePositionCandidateNumber(DynamicObject positionDt) {
        try {
            Long candidateNum = RsmPositionHelper.getCountBySinglePositionId(positionDt.getLong("id"));
            PositionMService.updateCandidateNumByPositionId(positionDt.getLong("id"), candidateNum);
        }
        catch (Exception e) {
            logger.error("AddResumeBizServiceHelper.AddResumeSaveThreadPool.updateCandidateNumByPositionId.error", (Throwable)e);
        }
    }

    public static boolean isLockedAppFile(DynamicObject appFile) {
        return appFile.getBoolean("isbinddelyrec");
    }

    public static DynamicObject generateDeliveryDt(Object media, Object appmthd, Object resacqMthd, Object recruchnlnm) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tstpm_srrdelivery");
        DynamicObject deliveryDt = hrBaseServiceHelper.generateEmptyDynamicObject();
        Long userId = TSCRequestContext.getUserId();
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        deliveryDt.set("id", (Object)ID.genLongId());
        deliveryDt.set("applytime", (Object)nowTime);
        deliveryDt.set("recruchnlmedia", media);
        deliveryDt.set("appmthd", appmthd);
        deliveryDt.set("resacqmthd", resacqMthd);
        deliveryDt.set("recruchnlnm", recruchnlnm);
        deliveryDt.set("isfiledisplay", (Object)YesOrNotEnum.YES.toString());
        deliveryDt.set("deliveryper", (Object)userId);
        deliveryDt.set("creator", (Object)userId);
        deliveryDt.set("createtime", (Object)nowTime);
        deliveryDt.set("modifier", (Object)userId);
        deliveryDt.set("modifytime", (Object)nowTime);
        deliveryDt.set("assignstatus", (Object)"1");
        return deliveryDt;
    }

    public static SaveAppFileResult manualSaveAppFile(Long candidateId, AppResumeBo appResumeBo, DynamicObject positionDt) {
        DynamicObject appFileDt = RsmHelper.getAppFileByStdRsmMidAndPositionId(candidateId, positionDt.getLong("id"), ResumeBoHelper.getDelivery(appResumeBo).getDate("applytime"));
        if (null == appFileDt) {
            return AddResumeService.saveNewAppFile(candidateId, appResumeBo, positionDt, "tssrm_appfile_view");
        }
        SaveAppFileResult result = new SaveAppFileResult();
        result.setSuccess(false);
        result.setAppFileId(Long.valueOf(appFileDt.getLong("id")));
        result.setNewAppFile(false);
        return result;
    }

    public static SaveAppFileResult saveNewAppFile(Long candidateId, AppResumeBo appResumeBo, DynamicObject positionDt, String formId) {
        SaveAppFileResult result = new SaveAppFileResult();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        DynamicObject appFileDt = helper.generateEmptyDynamicObject();
        long appFileId = ORM.create().genLongId(helper.getEntityName());
        result.setAppFileId(Long.valueOf(appFileId));
        result.setSuccess(true);
        result.setNewAppFile(true);
        appFileDt.set("id", (Object)result.getAppFileId());
        appFileDt.set("stdrsm", (Object)candidateId);
        appFileDt.set("deliveryrec", (Object)ResumeBoHelper.getDelivery(appResumeBo));
        appFileDt.set("position", (Object)positionDt);
        appFileDt.set("appres", (Object)appResumeBo.getRsm().getLong("id"));
        if (ObjectUtils.isNotEmpty((Object)appResumeBo.getTpAppfileId())) {
            appFileDt.set("pindex", (Object)appResumeBo.getTpAppfileId());
        } else {
            appFileDt.set("pindex", (Object)appFileId);
        }
        AddResumeService.setTpInfo(appFileDt, appResumeBo);
        logger.info("AddResumeHandleService.handleNotHaveCandidate saveAppFileOperation begin");
        AppFileMService.saveAppFileOperation(appFileDt, positionDt, appResumeBo);
        logger.info("AddResumeHandleService.handleNotHaveCandidate saveAppFileOperation end");
        return result;
    }

    private static void setTpInfo(DynamicObject appFile, AppResumeBo appResumeBo) {
        String tpAppfileId = appResumeBo.getTpAppfileId();
        if (ObjectUtils.isNotEmpty((Object)tpAppfileId)) {
            appFile.set("tpdataid", (Object)tpAppfileId);
            appFile.set("tpsys", (Object)appResumeBo.getTpSys());
        }
    }

    public static void saveAppRsm(AppResumeBo appResumeBo) {
        ResumeBoHelper.save(appResumeBo);
    }

    public static void filterEliminateCandidate(Long appFileId, Long rsmId, Long positionId) {
        logger.info("filterEliminateCandidate.params:{},{},{}", new Object[]{appFileId, rsmId, positionId});
        DynamicObject appFile = RsmAppFileHelper.queryOneById(appFileId);
        if (positionId != null && CfgResumeRuleHelper.isCandidateEliminated((long)rsmId, (long)positionId)) {
            AppFileMService.eliminateAppFile(new DynamicObject[]{appFile}, "2", null, null);
        } else {
            DynamicObject rsm = RsmHelper.findOne(rsmId);
            String rsmSource = rsm.getString("rsmsource");
            logger.info("filterEliminateCandidate.validate:{}", (Object)rsmSource);
            if (RsmSourceEnum.EMAIL.getCode().equals(rsmSource) && "B".equals(appFile.getString("filestatus"))) {
                AppFileMService.eliminateAppFile(new DynamicObject[]{appFile}, "3", null, null);
            }
        }
    }

    private AddResumeService() {
    }
}

