/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.sr.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.exception.TSCBizException;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.AppFileMService;

public class AfterTransHandlerService
implements Runnable {
    private static final Log logger = LogFactory.getLog(AfterTransHandlerService.class);
    private SaveCandidateResult result;
    private DynamicObject positionDt;
    private AppResumeBo resumeBo;
    private boolean isExist;

    public AfterTransHandlerService(SaveCandidateResult result, DynamicObject positionDt, AppResumeBo resumeBo, boolean isExist) {
        this.setResult(result);
        this.setPositionDt(positionDt);
        this.setResumeBo(resumeBo);
        this.setExist(isExist);
    }

    @Override
    public void run() {
        try {
            this.afterHandlerOperation(this.getResult(), this.getPositionDt(), this.getResumeBo(), this.isExist());
        }
        catch (Exception ex) {
            throw new TSCBizException((Throwable)ex);
        }
    }

    private void afterHandlerOperation(SaveCandidateResult result, DynamicObject positionDt, AppResumeBo resumeBo, boolean isExist) {
        logger.info("AddCandidate afterHandlerOperation");
        if (result != null && result.isSuccess()) {
            try {
                RsmCommonHelper.outTransaction(result.getRsmId(), true);
                logger.info("AddCandidate afterHandlerOperation publishRsmMsgToAILabel");
                AppFileMService.afterAppFileSaveHandle(result, positionDt, resumeBo);
            }
            catch (Exception ex) {
                logger.error("afterHandlerOperation.error", (Throwable)ex);
                throw ex;
            }
        }
    }

    public SaveCandidateResult getResult() {
        return this.result;
    }

    public final void setResult(SaveCandidateResult result) {
        this.result = result;
    }

    public DynamicObject getPositionDt() {
        return this.positionDt;
    }

    public final void setPositionDt(DynamicObject positionDt) {
        this.positionDt = positionDt;
    }

    public AppResumeBo getResumeBo() {
        return this.resumeBo;
    }

    public final void setResumeBo(AppResumeBo resumeBo) {
        this.resumeBo = resumeBo;
    }

    public boolean isExist() {
        return this.isExist;
    }

    public final void setExist(boolean exist) {
        this.isExist = exist;
    }
}

