/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rsm.sr.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.constants.rsm.ResumeConstants;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.EveryRecruitAddRsmInVo;
import kd.tsc.tsrbs.business.domain.rsm.entity.MailRsmAnalysis;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.business.domain.rsm.service.AddResumeBizServiceHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;
import kd.tsc.tstpm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mservice.PositionResumeRuleMService;
import kd.tsc.tstpm.business.domain.rsm.common.service.AILabelMsgHelper;
import kd.tsc.tstpm.business.domain.rsm.sr.entity.RsmRecommend;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tstpm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tstpm.business.domain.stdrsm.handler.config.ResumeMapping;
import kd.tsc.tstpm.business.domain.stdrsm.helper.EventHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tstpm.business.domain.stdrsm.service.stdrsm.resume.IResumeService;
import org.apache.commons.lang3.time.StopWatch;

public class RsmApiService {
    private static final Log LOG = LogFactory.getLog(RsmApiService.class);
    private AddResumeBizServiceHelper addResumeBizServiceHelper = AddResumeBizServiceHelper.getInstance();
    private AddResumeHandleService addResumeHandleService = new AddResumeHandleService();
    private static final Set<String> RSM_EXP_NOT_COPY_PROP = Sets.newHashSet((Object[])new String[]{"showlengthofstudy", "showlengthofwork", "showprojectduration", "rsm", "operationstatus"});
    private static RsmApiService rsmApiService = new RsmApiService();

    public static RsmApiService getInstance() {
        return rsmApiService;
    }

    private RsmApiService() {
    }

    public void recommendPosition(RsmRecommend rsmRecommend) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("RsmService.recommendPosition start");
        List<Long> positionIds = rsmRecommend.getPositionIds();
        List<Long> stdRsmIds = rsmRecommend.getStdRsmIds();
        if (positionIds.isEmpty() || stdRsmIds.isEmpty()) {
            return;
        }
        DynamicObject[] positionArr = RsmPositionHelper.getPositionObjByPositionIds(positionIds);
        Map<Long, DynamicObject> positionMap = this.transArrayToMap(positionArr);
        DynamicObject[] stdRsmArr = StdRsmServiceHelper.getStdRsmDys(stdRsmIds);
        Map<Long, DynamicObject> stdRsmMap = this.transArrayToMap(stdRsmArr);
        Map<Long, Map<Long, Future<SaveCandidateResult>>> futureMapMap = this.recommendPositionHandle(rsmRecommend, positionMap, stdRsmMap);
        this.recommendPositionResultHandle(rsmRecommend, positionMap, stdRsmMap, futureMapMap);
        LOG.info("RsmService.recommendPosition end");
        stopWatch.stop();
        LOG.info("RsmService.recommendPosition,useTime:{}ms,positionIds:{},stdRsmIds:{}", new Object[]{stopWatch.getTime(), positionIds, stdRsmIds});
    }

    private Map<Long, Map<Long, Future<SaveCandidateResult>>> recommendPositionHandle(RsmRecommend rsmRecommend, Map<Long, DynamicObject> positionMap, Map<Long, DynamicObject> stdRsmMap) {
        List<Long> positionIds = rsmRecommend.getPositionIds();
        List<Long> stdRsmIds = rsmRecommend.getStdRsmIds();
        DynamicObject deliveryDy = rsmRecommend.getDeliveryDy();
        Map<Long, DynamicObject> rsmMap = this.getRsmMapByStdRsmIds(stdRsmIds);
        IResumeService resumeService = new IResumeService();
        resumeService.setMainEntryNumber("tstpm_stdrsm");
        Map<String, Map<Long, List<DynamicObject>>> stdRsmList = resumeService.getStdRsmList(stdRsmIds);
        HashMap futureMapMap = Maps.newHashMapWithExpectedSize((int)positionIds.size());
        String[] rsmEntryName = ResumeConstants.SUBPAGES;
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping();
        for (Long positionId : positionIds) {
            DynamicObject positionDy = positionMap.get(positionId);
            HashMap futureMap = Maps.newHashMapWithExpectedSize((int)stdRsmIds.size());
            for (Long stdRsmId : stdRsmIds) {
                LOG.info("RsmService.recommendPosition Params positionId{},stdRsmId{}", (Object)positionId, (Object)stdRsmId);
                DynamicObject stdRsmDy = stdRsmMap.get(stdRsmId);
                DynamicObject rsmDy = this.copyStdRsmToRsm(stdRsmDy);
                if (null == rsmDy) continue;
                DynamicObject deliveryDyCopy = this.getNewDelivery(deliveryDy, rsmMap.get(stdRsmId));
                AppResumeBo resumeBo = new AppResumeBo(rsmDy, deliveryDyCopy);
                this.deaiWithRsmExp(stdRsmList, rsmEntryName, resumeMapping, stdRsmId, rsmDy, resumeBo);
                Future future = ResumeConstants.threadPool.submit((Callable)new HandlerThread(resumeBo, positionDy));
                futureMap.put(stdRsmId, future);
            }
            if (positionDy != null) {
                AddResumeService.updatePositionCandidateNumber(positionDy);
            }
            futureMapMap.put(positionId, futureMap);
        }
        return futureMapMap;
    }

    private void deaiWithRsmExp(Map<String, Map<Long, List<DynamicObject>>> stdRsmList, String[] rsmEntryName, Map<String, String> resumeMapping, Long stdRsmId, DynamicObject rsmDy, AppResumeBo resumeBo) {
        for (String entryNumber : rsmEntryName) {
            String stdEntryNumber = resumeMapping.get(entryNumber);
            Map<Long, List<DynamicObject>> listMap = stdRsmList.get(stdEntryNumber);
            if (Objects.isNull(stdEntryNumber) || listMap.isEmpty()) continue;
            List<DynamicObject> rsmEntryDys = this.copyStdExpToRsmExp(listMap.get(stdRsmId), rsmDy.getLong("id"), entryNumber);
            resumeBo.setEntry(entryNumber, rsmEntryDys);
        }
    }

    private void recommendPositionResultHandle(RsmRecommend rsmRecommend, Map<Long, DynamicObject> positionMap, Map<Long, DynamicObject> stdRsmMap, Map<Long, Map<Long, Future<SaveCandidateResult>>> futureMapMap) {
        List<Long> positionIds = rsmRecommend.getPositionIds();
        List<Long> stdRsmIds = rsmRecommend.getStdRsmIds();
        ArrayList failPositions = Lists.newArrayListWithExpectedSize((int)positionIds.size());
        for (Long positionId : positionIds) {
            RsmRecommend.FailPosition failPosition = new RsmRecommend.FailPosition();
            DynamicObject positionDy = positionMap.get(positionId);
            failPosition.setPositionDy(positionDy);
            Map<Long, Future<SaveCandidateResult>> futureMap = futureMapMap.get(positionId);
            for (Long stdRsmId : stdRsmIds) {
                RsmApiService.getFutureResult(stdRsmMap, stdRsmId, futureMap, failPosition);
            }
            if (failPosition.getStdRsmDys().isEmpty()) continue;
            failPositions.add(failPosition);
        }
        rsmRecommend.setFailPositions(failPositions);
    }

    private static void getFutureResult(Map<Long, DynamicObject> stdRsmMap, Long stdRsmId, Map<Long, Future<SaveCandidateResult>> futureMap, RsmRecommend.FailPosition failPosition) {
        DynamicObject stdRsmDy = stdRsmMap.get(stdRsmId);
        Future<SaveCandidateResult> future = futureMap.get(stdRsmId);
        try {
            SaveCandidateResult saveResult = future.get(ResumeConstants.MAX_WAIT_TIME.intValue(), TimeUnit.MILLISECONDS);
            if (!saveResult.isSuccess()) {
                failPosition.addFailStdRsm(stdRsmDy);
            }
        }
        catch (InterruptedException ex) {
            LOG.error("recommendPosition error", (Throwable)ex);
            failPosition.addFailStdRsm(stdRsmDy);
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            LOG.error("recommendPosition error", (Throwable)ex);
            failPosition.addFailStdRsm(stdRsmDy);
        }
    }

    public void mailAddRsm(List<MailRsmAnalysis> mailList) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOG.info("RsmService.mailAddRsm BEGIN:");
        if (mailList == null || mailList.isEmpty()) {
            LOG.info("RsmService.mailAddRsm mailList.size() == 0 END");
            return;
        }
        String fullName = "";
        long rsmId = 0L;
        for (MailRsmAnalysis mailRsm : mailList) {
            String mailRsmUrl = mailRsm.getUrl();
            LOG.info("RsmService.mailAddRsm.resumeUrl:{}", (Object)mailRsmUrl);
            ResumeInfo resumeInfo = this.addResumeBizServiceHelper.getInputStreamByResumeUrl(mailRsmUrl);
            if (resumeInfo != null) {
                if (resumeInfo.getResultStatus() == 200) {
                    DynamicObject rsm = this.addResumeBizServiceHelper.generateResumeInfo(resumeInfo);
                    fullName = rsm.getString("fullname");
                    rsmId = rsm.getLong("id");
                    rsm.set("rsmsource", (Object)RsmSourceEnum.EMAIL.getCode());
                    DynamicObject deliveryDt = this.handlerDelivery(mailRsm);
                    LOG.info("RsmService.mailAddRsm.deliveryDt={}", (Object)deliveryDt.toString());
                    AppResumeBo resumeBo = new AppResumeBo(rsm, deliveryDt);
                    this.addResumeBizServiceHelper.loadExpEntity(resumeInfo, resumeBo);
                    this.mailAddRsmHandle(resumeBo, mailRsm);
                    continue;
                }
                LOG.info("RsmService.mailAddRsm ANALYSIS FAIL");
                mailRsm.setErrorCode("101");
                continue;
            }
            LOG.info("RsmService.mailAddRsm ANALYSIS FAIL");
            mailRsm.setErrorCode("101");
        }
        stopWatch.stop();
        LOG.info("RsmService.mailAddRsm,fullName:{},RsmId:{},useTime:{}ms", new Object[]{fullName, rsmId, stopWatch.getTime()});
    }

    private void mailAddRsmHandle(AppResumeBo resumeBo, MailRsmAnalysis mailRsm) {
        List<Long> positionIdList = PositionResumeRuleMService.rsmAssignPositionAuto(resumeBo);
        LOG.info("RsmService.mailAddRsm.rsmAssignPositionAuto,positionIdList={}", positionIdList);
        ArrayList rsmIdList = Lists.newArrayList();
        mailRsm.setErrorCode("102");
        if (positionIdList == null || positionIdList.isEmpty()) {
            LOG.info("RsmService.mailAddRsm,positionIdList == null || positionIdList.size()==0");
            SaveCandidateResult saveCandidateResult = this.addResumeHandleService.handle(resumeBo, null, Boolean.FALSE, ResumeTypeEnum.EMAIL);
            this.handlerMailAddRsmResult(saveCandidateResult, rsmIdList, null, mailRsm);
        } else {
            LOG.info("RsmService.mailAddRsm,positionIdList.else");
            resumeBo.getDelivery().set("assignstatus", (Object)"1");
            DynamicObject[] positionDys = RsmPositionHelper.getPositionObjByPositionIds(positionIdList);
            HashMap positionIdMap = Maps.newHashMapWithExpectedSize((int)positionDys.length);
            for (DynamicObject position : positionDys) {
                positionIdMap.put(position.getLong("id"), position);
            }
            for (int i = 0; i < positionIdList.size(); ++i) {
                DynamicObject position;
                AppResumeBo resumeBoSave = new AppResumeBo(resumeBo);
                this.resetRsmId(resumeBoSave);
                LOG.info("RsmService.mailAddRsm.resetRsmId is success");
                Long positionId = positionIdList.get(i);
                position = (DynamicObject)positionIdMap.get(positionId);
                SaveCandidateResult saveCandidateResult = this.addResumeHandleService.handle(resumeBoSave, position, Boolean.TRUE, ResumeTypeEnum.EMAIL);
                LOG.info("RsmService.mailAddRsm,positionIdList.positionname:{},deliveryId:{},rsmId:{}", new Object[]{position.getString("name"), resumeBoSave.getDelivery().get("id"), resumeBoSave.getRsm().get("id")});
                this.handlerMailAddRsmResult(saveCandidateResult, rsmIdList, position, mailRsm);
            }
        }
        mailRsm.setRmsIdList((List)rsmIdList);
    }

    public SaveCandidateResult everyRecruitAddRsm(EveryRecruitAddRsmInVo everyRecruitAddRsmInVo) {
        AppResumeBo resumeBo = everyRecruitAddRsmInVo.getResumeBo();
        DynamicObject deliveryDt = AddResumeService.generateDeliveryDt(1050L, 1040L, 1030L, 1170L);
        deliveryDt.set("assignstatus", (Object)"1");
        resumeBo.setDelivery(deliveryDt);
        resumeBo.getRsm().set("rsmsource", (Object)RsmSourceEnum.INTRECO.getCode());
        Long positionId = everyRecruitAddRsmInVo.getPositionId();
        DynamicObject positionDy = RsmPositionHelper.queryOneById(positionId);
        return this.addResumeHandleService.handle(resumeBo, positionDy, Boolean.TRUE, ResumeTypeEnum.REFEREE);
    }

    private void resetRsmId(AppResumeBo resumeBo) {
        long rsmId = ID.genLongId();
        long deliveryId = ID.genLongId();
        resumeBo.getRsm().set("id", (Object)rsmId);
        resumeBo.getDelivery().set("id", (Object)deliveryId);
        resumeBo.getDyoCollMap().forEach((key, list) -> {
            if (list != null && !list.isEmpty()) {
                list.forEach(dy -> dy.set("rsm", (Object)rsmId));
            }
        });
    }

    private void handlerMailAddRsmResult(SaveCandidateResult saveCandidateResult, List<Long> rsmIdList, DynamicObject position, MailRsmAnalysis mailRsm) {
        if (saveCandidateResult.isSuccess()) {
            LOG.info("RsmService.mailAddRsm SUCCESS");
            rsmIdList.add(saveCandidateResult.getRsmId());
            if (position != null) {
                AddResumeService.updatePositionCandidateNumber(position);
            }
            mailRsm.setErrorCode("100");
        }
    }

    private DynamicObject handlerDelivery(MailRsmAnalysis mailInfo) {
        Long recruchnlnmId = mailInfo.getRecruchnlnmId();
        if (recruchnlnmId == null) {
            recruchnlnmId = ResumeConstants.recruchnlnmId;
        }
        DynamicObject deliveryDt = AddResumeService.generateDeliveryDt(ResumeConstants.recruchnlMediaId, 1010L, ResumeConstants.resacqmthdId, recruchnlnmId);
        deliveryDt.set("assignstatus", (Object)"0");
        deliveryDt.set("emailsource", (Object)mailInfo.getEmailId());
        deliveryDt.set("emailtitle", (Object)mailInfo.getEmailTitle());
        deliveryDt.set("attachname", (Object)mailInfo.getAttachName());
        String titlePosition = mailInfo.getTitlePosition();
        String attachPosition = mailInfo.getAttachPosition();
        if (HRStringUtils.isNotEmpty((String)titlePosition)) {
            deliveryDt.set("postposition", (Object)titlePosition);
        } else {
            deliveryDt.set("postposition", (Object)attachPosition);
        }
        deliveryDt.set("titleposition", (Object)titlePosition);
        deliveryDt.set("attachposition", (Object)attachPosition);
        deliveryDt.set("titlecity", (Object)mailInfo.getTitleCity());
        deliveryDt.set("attachcity", (Object)mailInfo.getAttachCity());
        return deliveryDt;
    }

    public static void publishRsmMsgToAILabel(Long rsmId) {
        LOG.info("RsmService.publishRsmMsgToAILabel send AI label msg rsmId : {},", (Object)rsmId);
        AILabelMsgHelper.publishMsg(rsmId, 0);
        LOG.info("RsmService.publishRsmMsgToAILabel stdRsm start");
        DynamicObject[] rsmDy = RsmHelper.findRsmById(rsmId, "stdrsm");
        Long stdRsmId = rsmDy[0].getLong("stdrsm");
        LOG.info("RsmService.publishRsmMsgToAILabel stdRsmId :[{}]", (Object)stdRsmId);
        DynamicObject event = EventHelper.queryBoEvent(stdRsmId, "1");
        if (HRObjectUtils.isEmpty((Object)event)) {
            return;
        }
        AILabelMsgHelper.publishMsg(stdRsmId, event.getLong("id"), 1);
        LOG.info("RsmService.publishRsmMsgToAILabel stdRsm end");
    }

    private List<DynamicObject> copyStdExpToRsmExp(List<DynamicObject> stdExpDyList, Long rsmId, String entityId) {
        if (stdExpDyList == null || stdExpDyList.isEmpty()) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList rsmExpDyList = Lists.newArrayListWithExpectedSize((int)stdExpDyList.size());
        for (DynamicObject stdExpDy : stdExpDyList) {
            DynamicObject rsmExpDy = ServiceHelperCache.getHrBaseServiceHelper((String)entityId).generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)stdExpDy, (DynamicObject)rsmExpDy, RSM_EXP_NOT_COPY_PROP);
            rsmExpDy.set("rsm", (Object)rsmId);
            rsmExpDy.set("id", (Object)ID.genLongId());
            rsmExpDyList.add(rsmExpDy);
        }
        return rsmExpDyList;
    }

    private DynamicObject copyStdRsmToRsm(DynamicObject stdRsmDy) {
        if (stdRsmDy == null) {
            return null;
        }
        DynamicObject rsmDy = ServiceHelperCache.getHrBaseServiceHelper((String)"tstpm_srrsm").generateEmptyDynamicObject();
        Set rsmPropNameList = rsmDy.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        Set stdRsmPropNameList = stdRsmDy.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        for (String propName : rsmPropNameList) {
            if (!stdRsmPropNameList.contains(propName)) continue;
            rsmDy.set(propName, stdRsmDy.get(propName));
        }
        rsmDy.set("id", (Object)ID.genLongId());
        rsmDy.set("stdrsm", stdRsmDy.get("id"));
        rsmDy.set("rsmsource", (Object)RsmSourceEnum.RP.getCode());
        ResumeAnalysisHelper.setCreatorAndTime((DynamicObject)rsmDy);
        return rsmDy;
    }

    private Map<Long, DynamicObject> transArrayToMap(DynamicObject[] dyArr) {
        if (dyArr == null || dyArr.length == 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap dyMap = Maps.newHashMapWithExpectedSize((int)dyArr.length);
        for (DynamicObject dy : dyArr) {
            dyMap.put(dy.getLong("id"), dy);
        }
        return dyMap;
    }

    private Map<Long, DynamicObject> getRsmMapByStdRsmIds(List<Long> stdRsmIds) {
        HashMap rsmMap = Maps.newHashMapWithExpectedSize((int)stdRsmIds.size());
        DynamicObject[] rsmArr = RsmHelper.findRsmByStdRsmIds(stdRsmIds);
        if (rsmArr == null || rsmArr.length == 0) {
            return rsmMap;
        }
        for (DynamicObject rsmDy : rsmArr) {
            Long stdRsmId = rsmDy.getLong("stdrsm");
            rsmMap.putIfAbsent(stdRsmId, rsmDy);
        }
        return rsmMap;
    }

    public DynamicObject getNewDelivery(DynamicObject deliveryDy, DynamicObject stdRsmMatchRsm) {
        DynamicObject deliveryDyCopy = null;
        if (null != deliveryDy) {
            deliveryDyCopy = ResumeUtilsHelper.copyDynamicObject((DynamicObject)deliveryDy);
            deliveryDyCopy.set("id", (Object)ID.genLongId());
            if (null != stdRsmMatchRsm) {
                Object recruchnlnm = stdRsmMatchRsm.getDynamicObject("delivery").getDynamicObject("recruchnlnm").get("id");
                deliveryDyCopy.set("recruchnlnm", recruchnlnm);
            }
        }
        return deliveryDyCopy;
    }

    static class HandlerThread
    implements Callable<SaveCandidateResult> {
        private AddResumeHandleService addCandidateService = new AddResumeHandleService();
        private AppResumeBo resumeBo;
        private DynamicObject positionDy;

        public HandlerThread(AppResumeBo resumeBo, DynamicObject positionDy) {
            this.setResumeBo(resumeBo);
            this.setPositionDy(positionDy);
        }

        @Override
        public SaveCandidateResult call() {
            return this.addCandidateService.handleNoUpdateStdRsm(this.resumeBo, this.positionDy, Boolean.FALSE);
        }

        public final void setResumeBo(AppResumeBo resumeBo) {
            this.resumeBo = resumeBo;
        }

        public final void setPositionDy(DynamicObject positionDy) {
            this.positionDy = positionDy;
        }
    }
}

