/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.rule;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.tsc.tsrbd.business.domain.rule.context.BatchRuleContext;

public class StdRsmBatchRuleContext
extends BatchRuleContext {
    private static final String DEFAULT_POOL_KEY = "pool";
    private final List<SceneResult> sceneResults = Lists.newArrayListWithCapacity((int)16);
    private final List<DynamicObject> talentPoolResult = Lists.newArrayListWithCapacity((int)16);

    protected void afterExecute() {
        for (SceneResult sceneResult : this.sceneResults) {
            List results = sceneResult.getPolicyResults();
            List ruleResult = this.getRuleResult(results);
            if (ruleResult.isEmpty()) {
                List<Map<String, Object>> list = results.stream().map(PolicyResult::getDefaultResults).collect(Collectors.toList());
                if (list.isEmpty()) continue;
                this.addRuleMatchTalentPoolNumber(list);
                continue;
            }
            List matchResults = this.getMatchResults(ruleResult);
            if (matchResults.isEmpty()) continue;
            this.addRuleMatchTalentPoolNumber(matchResults);
        }
    }

    protected void buildBizSceneResult(List<Map<String, Object>> map) {
        for (Map<String, Object> ruleMap : map) {
            SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult(ruleMap);
            this.sceneResults.add(sceneResult);
        }
    }

    private void addRuleMatchTalentPoolNumber(List<Map<String, Object>> matchResults) {
        List talentPoolDyList = (List)this.analysisMatchResults(matchResults, DEFAULT_POOL_KEY);
        if (this.talentPoolResult.isEmpty()) {
            this.talentPoolResult.addAll(talentPoolDyList);
        } else {
            for (DynamicObject matchDy : talentPoolDyList) {
                Optional<DynamicObject> optional = this.talentPoolResult.stream().filter(dy -> dy.getLong("id") == matchDy.getLong("id")).findFirst();
                if (optional.isPresent()) continue;
                this.talentPoolResult.add(matchDy);
            }
        }
    }

    public List<DynamicObject> getTalentPoolResult() {
        return this.talentPoolResult;
    }
}

