/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.sendmessage.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tstpm.business.domain.rsm.rsmupdate.service.InviteUpdateService;
import kd.tsc.tstpm.business.domain.sendmessage.pojo.Recipient;
import kd.tsc.tstpm.business.domain.sendmessage.service.MessagePushScene;
import kd.tsc.tstpm.business.domain.sendmessage.service.SendMsgServiceHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tstpm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;

public class InviteDeliveryResumeImpl
extends MessagePushScene {
    public static final String PAGE_TSIRP_INTRECOADVDETAI_EXT = "tsirp_intrecoadvdetai_ext";
    private static final long serialVersionUID = 3063024643146736301L;

    public InviteDeliveryResumeImpl() {
        this.paramMap.put("msgSceneType", CfgMsgScenes.TALENT_DELIVER_RESUME.getBaseDataId());
        this.paramMap.put("msgReceiverType", CfgMsgRecvType.CANDIDATE.getBaseDataId());
        Map userInfoMap = (Map)UserServiceHelper.get((List)ImmutableList.of((Object)RequestContext.get().getCurrUserId())).get(0);
        String operatorName = RequestContext.get().getUserName();
        Object operatorPhone = userInfoMap.get("phone");
        Object operatorEmail = userInfoMap.get("email");
        this.paramMap.put("operatorname", operatorName);
        this.paramMap.put("operatorphone", operatorPhone);
        this.paramMap.put("operatoremail", operatorEmail);
    }

    @Override
    public boolean send(IFormView sendMessageView) {
        IFormView msgIntegrateView = sendMessageView.getView(sendMessageView.getPageCache().get("cfgmsgintegrate_pageid"));
        IFormView recipientView = sendMessageView.getView(sendMessageView.getPageCache().get("tstpm_recipients"));
        Map customParams = msgIntegrateView.getFormShowParameter().getCustomParams();
        Long positionId = recipientView.getModel().getDataEntity().getLong("positionid");
        DynamicObject position = SendMsgServiceHelper.getInstance().queryPositionById(positionId);
        String name = position.getString("name");
        String number = position.getString("number");
        String positionName = name + '(' + number + ')';
        Long advertisingId = (Long)DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tspr", (String)"AddAdvertisementServiceApi", (String)"newAdvertisementByPositionId", (Object[])new Object[]{position.getPkValue()});
        customParams.put("positionurl", advertisingId);
        customParams.put("positionname", positionName);
        customParams.put("positionurlname", positionName);
        Map<Long, Boolean> candidateDeliveryStatusMap = this.handleRecipients(sendMessageView, position.getLong("id"));
        boolean result = super.send(sendMessageView);
        this.setResultInfo(sendMessageView, candidateDeliveryStatusMap);
        return result;
    }

    @Override
    public void setParam(Recipient recipient, Map<String, Object> paramMap) {
        paramMap.put("phone", recipient.getPhone());
        paramMap.put("email", recipient.getEmail());
        paramMap.put("candidatename", recipient.getName());
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date validTime = HRDateTimeUtils.addDay((Date)nowTime, (long)7L);
        String validTimeStr = HRDateTimeUtils.format((Date)validTime);
        paramMap.put("resumeurlvalidtime", validTimeStr);
        long stdRsmId = recipient.getId();
        Object positionUrl = paramMap.get("positionurl");
        if (positionUrl instanceof Long) {
            HashMap params = Maps.newHashMapWithExpectedSize((int)1);
            params.put("advertisingId", positionUrl);
            String advertisingLink = InviteUpdateService.getRsmUpdateLink(stdRsmId, "stdrsmdeliver", PAGE_TSIRP_INTRECOADVDETAI_EXT, params);
            paramMap.put("positionurl", advertisingLink);
        } else {
            paramMap.put("positionurl", ResManager.loadKDString((String)"{\u804c\u4f4d\u94fe\u63a5}", (String)"InviteDeliveryResumeImpl_0", (String)"tsc-tstpm-business", (Object[])new Object[0]));
            paramMap.put("positionname", ResManager.loadKDString((String)"{\u804c\u4f4d\u540d\u79f0}", (String)"InviteDeliveryResumeImpl_1", (String)"tsc-tstpm-business", (Object[])new Object[0]));
        }
    }

    private void setResultInfo(IFormView sendMessageView, Map<Long, Boolean> candidateDeliveryStatusMap) {
        sendMessageView.getPageCache().put("totalNum", String.valueOf(candidateDeliveryStatusMap.size()));
        Set<Long> stdRsmIdSet = candidateDeliveryStatusMap.keySet();
        int notInProcessIdSize = 0;
        ArrayList inProcessIdList = Lists.newArrayListWithExpectedSize((int)candidateDeliveryStatusMap.size());
        for (Map.Entry<Long, Boolean> entry : candidateDeliveryStatusMap.entrySet()) {
            Long key = entry.getKey();
            Boolean value = entry.getValue();
            if (Boolean.TRUE == value) {
                ++notInProcessIdSize;
                continue;
            }
            inProcessIdList.add(key);
        }
        Map<Long, DynamicObject> stdRsmMap = StandardResumeDataHelper.batchQueryStdRsmToMap(stdRsmIdSet.stream().collect(Collectors.toList()));
        StringBuilder msgDetail = new StringBuilder();
        for (int i = 0; i < inProcessIdList.size(); ++i) {
            DynamicObject stdRsm = stdRsmMap.get(inProcessIdList.get(i));
            String name = stdRsm.getString("fullname");
            String number = stdRsm.getString("number");
            msgDetail.append(name).append('(').append(number).append(')');
            if (i == inProcessIdList.size() - 1) {
                msgDetail.append('\u3002');
                continue;
            }
            msgDetail.append("\u3001");
        }
        if (inProcessIdList.size() != 0) {
            String title = ResManager.loadKDString((String)"\u5171\u53d1\u9001%s\u4e2a\u5019\u9009\u4eba\uff0c%s\u4e2a\u53d1\u9001\u6210\u529f\uff0c%s\u4e2a\u65e0\u6cd5\u53d1\u9001\u3002", (String)"InviteDeliveryResumeImpl_0", (String)"tsc-tstpm-business", (Object[])new Object[0]);
            sendMessageView.getPageCache().put("inProcessMsgDetail", msgDetail.toString());
            sendMessageView.getPageCache().put("inProcessMsgTitle", String.format(title, stdRsmIdSet.size(), notInProcessIdSize, inProcessIdList.size()));
            sendMessageView.getPageCache().put("inProcessNum", String.valueOf(inProcessIdList.size()));
        }
    }

    private Map<Long, Boolean> handleRecipients(IFormView sendMessageView, long positionId) {
        IFormView recipientView = sendMessageView.getView(sendMessageView.getPageCache().get("tstpm_recipients"));
        List recipientList = JSON.parseArray((String)recipientView.getPageCache().get("recipients"), Recipient.class);
        List<Long> stdRsmIdList = recipientList.stream().map(recipient -> recipient.getId()).collect(Collectors.toList());
        Map<Long, Boolean> candidateDeliveryStatusMap = StdRsmBusiAppHelper.batchQueryCandidateDeliveryStatus(stdRsmIdList, positionId);
        Iterator iterator = recipientList.iterator();
        while (iterator.hasNext()) {
            Recipient recipient2 = (Recipient)iterator.next();
            if (candidateDeliveryStatusMap.get(recipient2.getId()).booleanValue()) continue;
            iterator.remove();
        }
        recipientView.getPageCache().put("recipients", JSON.toJSONString((Object)recipientList));
        recipientView.getPageCache().put("recipientsSize", String.valueOf(recipientList.size()));
        return candidateDeliveryStatusMap;
    }
}

