/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.sendmessage.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tstpm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tstpm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tstpm.business.domain.rsm.rsmupdate.service.InviteUpdateService;
import kd.tsc.tstpm.business.domain.sendmessage.pojo.Recipient;
import kd.tsc.tstpm.business.domain.sendmessage.service.MessagePushScene;
import kd.tsc.tstpm.common.utils.TalentPoolDeseUtil;

public class InviteUpdateResumeImpl
extends MessagePushScene {
    private static final long serialVersionUID = -2310291391422331824L;

    public InviteUpdateResumeImpl() {
        this.paramMap.put("msgSceneType", CfgMsgScenes.TALENT_UPDATE_RESUME.getBaseDataId());
        this.paramMap.put("msgReceiverType", CfgMsgRecvType.CANDIDATE.getBaseDataId());
        Map userInfoMap = (Map)UserServiceHelper.get((List)ImmutableList.of((Object)RequestContext.get().getCurrUserId())).get(0);
        String operatorName = RequestContext.get().getUserName();
        Object operatorPhone = userInfoMap.get("phone");
        Object operatorEmail = userInfoMap.get("email");
        this.paramMap.put("operatorname", operatorName);
        this.paramMap.put("operatorphone", operatorPhone);
        this.paramMap.put("operatoremail", operatorEmail);
    }

    @Override
    public void setParam(Recipient recipient, Map<String, Object> paramMap) {
        paramMap.put("phone", recipient.getPhone());
        paramMap.put("email", recipient.getEmail());
        paramMap.put("candidateemail", TalentPoolDeseUtil.replaceEmailX((String)recipient.getEmail()));
        paramMap.put("candidatename", recipient.getName());
        Long stdRsmId = recipient.getId();
        String rsmUpdateLink = InviteUpdateService.getRsmUpdateLink(stdRsmId, "stdrsm", "tstpm_srrsmupdatemain", Maps.newLinkedHashMapWithExpectedSize((int)0));
        paramMap.put("resumeurl", rsmUpdateLink);
        paramMap.put("resumeurlname", ResManager.loadKDString((String)"\u66f4\u65b0\u7b80\u5386", (String)"InviteUpdateResumeImpl_0", (String)"tsc-tstpm-business", (Object[])new Object[0]));
        String positionName = "";
        DynamicObject[] rsmDys = ResumeBoHelper.getAppFileNotNullOfRsmByStdRsmIds((List<Long>)ImmutableList.of((Object)stdRsmId));
        if (rsmDys != null && rsmDys.length > 0) {
            Long appfileId = rsmDys[0].getLong("appfile");
            DynamicObject appfile = RsmAppFileHelper.queryOneById(appfileId);
            positionName = appfile.getDynamicObject("position").getString("name");
        }
        paramMap.put("positionname", positionName);
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date validTime = HRDateTimeUtils.addDay((Date)nowTime, (long)7L);
        String validTimeStr = HRDateTimeUtils.format((Date)validTime);
        paramMap.put("resumevalidtime", validTimeStr);
    }
}

