/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tstpm.business.domain.sendmessage.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsrbd.common.enums.CfmMsgChannel;
import kd.tsc.tsrbs.business.domain.oprecord.service.OprecordMQ;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import kd.tsc.tstpm.business.domain.sendmessage.pojo.Recipient;
import kd.tsc.tstpm.business.domain.sendmessage.service.ISendMessage;
import kd.tsc.tstpm.business.domain.sendmessage.service.SendMsgServiceHelper;
import kd.tsc.tstpm.common.enums.stdrsm.MsgSceneEnum;
import org.apache.commons.lang3.StringUtils;

public class MessagePushScene
implements ISendMessage {
    private static final Log logger = LogFactory.getLog(MessagePushScene.class);
    private static final long serialVersionUID = -1802001553080202650L;
    protected Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize((int)16);

    public MessagePushScene() {
        SendMsgServiceHelper.getInstance().setOperatorParam(this.paramMap);
    }

    @Override
    public boolean send(IFormView sendMessageView) {
        boolean sendSuccess = false;
        IFormView recipientView = sendMessageView.getView(sendMessageView.getPageCache().get("tstpm_recipients"));
        IFormView msgIntegrateView = sendMessageView.getView(sendMessageView.getPageCache().get("cfgmsgintegrate_pageid"));
        List recipientList = JSON.parseArray((String)recipientView.getPageCache().get("recipients"), Recipient.class);
        if (null == recipientList || recipientList.size() < 1) {
            return true;
        }
        MsgSceneEnum msgSceneEnum = MsgSceneEnum.valueOf((String)((String)sendMessageView.getFormShowParameter().getCustomParams().get("cfgMsgScene")));
        Map customParams = msgIntegrateView.getFormShowParameter().getCustomParams();
        Object positionurl = customParams.get("positionurl");
        customParams.put("bizentity", "tstpm_stdrsm");
        sendMessageView.getPageCache().put("totalNum", String.valueOf(recipientList.size()));
        Map<Long, Long> recipientOpRecordMap = this.createOpRecord(recipientList, msgSceneEnum, msgIntegrateView);
        ArrayList recipientMapList = Lists.newArrayListWithCapacity((int)recipientList.size());
        for (Recipient recipient : recipientList) {
            HashMap recipientMap = Maps.newHashMapWithExpectedSize((int)16);
            if (StringUtils.equals((CharSequence)"D", (CharSequence)msgSceneEnum.getValue())) {
                recipientMap.put("positionurl", positionurl);
            }
            recipientMap.put("bizobj", recipient.getId());
            recipientMap.put("oprecordid", recipientOpRecordMap.get(recipient.getId()));
            this.setParam(recipient, recipientMap);
            this.copyParam(customParams, recipientMap);
            recipientMapList.add(recipientMap);
            logger.info("MessagePushScene.send.customParams:[{}]", (Object)customParams);
        }
        customParams.put("receiver_list", recipientMapList);
        OperationResult operationResult = msgIntegrateView.invokeOperation("sendmessage");
        if (operationResult.isSuccess()) {
            sendSuccess = true;
        }
        return sendSuccess;
    }

    @Override
    public Map<String, Object> setParam(IFormView sendMessageView) {
        List recipientList = JSON.parseArray((String)sendMessageView.getPageCache().get("recipients"), Recipient.class);
        Recipient recipient = (Recipient)recipientList.get(0);
        this.setParam(recipient, this.paramMap);
        return this.paramMap;
    }

    @Override
    public void updateVariable(IFormView recipientsView) {
        IFormView sendMessageView = recipientsView.getParentView();
        IFormView msgintegrateView = sendMessageView.getView(sendMessageView.getPageCache().get("cfgmsgintegrate_pageid"));
        List recipientList = JSON.parseArray((String)recipientsView.getPageCache().get("recipients"), Recipient.class);
        Recipient recipient = (Recipient)recipientList.get(0);
        Map customParams = msgintegrateView.getFormShowParameter().getCustomParams();
        this.setParam(recipient, customParams);
        msgintegrateView.cacheFormShowParameter();
    }

    protected void setParam(Recipient recipient, Map<String, Object> paramMap) {
    }

    private Map<Long, Long> createOpRecord(List<Recipient> recipientList, MsgSceneEnum msgSceneEnum, IFormView msgIntegrateView) {
        String opNumber = "";
        String oprText = "";
        ArrayList opRecordMessageModelList = Lists.newArrayListWithCapacity((int)recipientList.size());
        HashMap recipientOpRecordMap = Maps.newHashMapWithExpectedSize((int)recipientList.size());
        for (Recipient recipient : recipientList) {
            OprecordMessageModel oprecordMessageModel = new OprecordMessageModel();
            long modelId = ID.genLongId();
            oprecordMessageModel.setModelId(Long.valueOf(modelId));
            oprecordMessageModel.setOperator(Long.valueOf(RequestContext.get().getCurrUserId()));
            oprecordMessageModel.setOperatorname(RequestContext.get().getUserName());
            oprecordMessageModel.setBizobjname(recipient.getName());
            oprecordMessageModel.setBizentry("tstpm_stdrsm");
            oprecordMessageModel.setBizobj(recipient.getId());
            switch (msgSceneEnum) {
                case SEND_NOTIFICATION: {
                    opNumber = OpDefEnum.SEND_NOTICE.getCode();
                    oprText = ResManager.loadKDString((String)"%s\u7ed9\u5019\u9009\u4eba%s\u901a\u8fc7%s\u53d1\u901a\u77e5\u3002", (String)"MessagePushScene_0", (String)"tsc-tstpm-business", (Object[])new Object[0]);
                    break;
                }
                case INVITE_UPDATE_RESUME: {
                    opNumber = OpDefEnum.INVITE_UPDATE_RESUME.getCode();
                    oprText = ResManager.loadKDString((String)"%s\u901a\u8fc7%s\u9080\u8bf7\u5019\u9009\u4eba%s\u66f4\u65b0\u7b80\u5386\u3002", (String)"MessagePushScene_1", (String)"tsc-tstpm-business", (Object[])new Object[0]);
                    break;
                }
                case INVITE_DELIVERY_RESUME: {
                    opNumber = OpDefEnum.INVITE_SEND_RESUME.getCode();
                    oprText = ResManager.loadKDString((String)"%s\u901a\u8fc7%s\u9080\u8bf7\u5019\u9009\u4eba%s\u6295\u9012\u7b80\u5386\u3002", (String)"MessagePushScene_2", (String)"tsc-tstpm-business", (Object[])new Object[0]);
                    break;
                }
            }
            oprecordMessageModel.setOpnumber(opNumber);
            oprecordMessageModel.setOptime(new Date());
            oprecordMessageModel.setOprtext(this.generateOprText(oprText, recipient.getName(), msgSceneEnum, msgIntegrateView));
            opRecordMessageModelList.add(oprecordMessageModel);
            recipientOpRecordMap.put(recipient.getId(), modelId);
        }
        OprecordMQ.sendOpRecordChangeMessage((List)opRecordMessageModelList);
        return recipientOpRecordMap;
    }

    private String generateOprText(String oprText, String bizObjName, MsgSceneEnum msgSceneEnum, IFormView msgIntegrateView) {
        String operatorJName = RequestContext.get().getUserName();
        String result = "";
        String msgChannelStr = msgIntegrateView.getModel().getDataEntity().getString("msgchannellist");
        String[] msgChannels = msgChannelStr.split(",");
        StringBuilder channelNameSB = new StringBuilder();
        if (msgChannels != null) {
            for (String msgChannel : msgChannels) {
                if (msgChannel.trim().length() <= 0) continue;
                Long channelId = Long.parseLong(msgChannel);
                String channelName = CfmMsgChannel.getNameByChannelId((Long)channelId);
                if (channelNameSB.length() < 1) {
                    channelNameSB.append(channelName);
                    continue;
                }
                channelNameSB.append("\u3001");
                channelNameSB.append(channelName);
            }
        }
        result = msgSceneEnum == MsgSceneEnum.SEND_NOTIFICATION ? String.format(oprText, operatorJName, bizObjName, channelNameSB.toString()) : String.format(oprText, operatorJName, channelNameSB.toString(), bizObjName);
        return result;
    }

    private void copyParam(Map<String, Object> customParam, Map<String, Object> recipientMap) {
        Set<String> recipientMapKeys = recipientMap.keySet();
        String key = "";
        for (Map.Entry<String, Object> entry : customParam.entrySet()) {
            key = entry.getKey();
            if (recipientMapKeys.contains(key)) continue;
            recipientMap.put(key, entry.getValue());
        }
    }
}

